/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.excel.model.expr.Expr;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction;
import com.kingdee.bos.ctrl.excel.model.struct.URState;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.excel.model.struct.undo.AbstractUndoableEdit;

public class SheetAction_Named
extends SheetAction {
    private NamedObjectNode _no;
    private Expr _expr;

    public SheetAction_Named(Range rg, NamedObjectNode no, Expr expr) {
        super(rg, SheetChangeEvent.Changed_Content | SheetChangeEvent.Changed_Named);
        this._no = no;
        this._expr = expr;
    }

    @Override
    protected void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        if (this._rg._sheets.getSheet(0) != sheet) {
            return;
        }
        boolean change = false;
        if (this._expr == null) {
            change = true;
            this._expr = NamedObjectNode.getUndefinedExpr();
        } else {
            ExprContext ctx = sheet.getExprContextNode();
            String refersTo = this._expr.decode(ctx, sheet.getParserHelper());
            if (!refersTo.equals(this._no.getRefersTo())) {
                change = true;
            }
        }
        if (change) {
            this._no.queue(false);
            Expr old = this._no.setExpr(this._expr);
            if (state != null) {
                state.setData("NAMED_OBJ", this._no);
                state.setData("NAMED_OBJ_EXPR", old);
            }
        }
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        NamedObjectNode no = (NamedObjectNode)state.get("NAMED_OBJ");
        if (no != null) {
            no.setExpr((Expr)state.get("NAMED_OBJ_EXPR"));
            no.queue(false);
        }
    }

    @Override
    public String getPresentationName() {
        return LanguageManager.getLangMessage((String)"name", AbstractUndoableEdit.class, (String)"\u547d\u540d ") + super.getPresentationName();
    }
}

