/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct.embed.chart;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.embed.chart.ChartModel;
import com.kingdee.bos.ctrl.excel.model.struct.embed.chart.ChartRenderData;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.swing.KDChart;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import com.kingdee.bos.ctrl.swing.chart.data.CommonChartData;
import com.kingdee.bos.ctrl.swing.chart.data.IChartData;
import com.kingdee.bos.ctrl.swing.chart.data.PieChartData;
import com.kingdee.bos.ctrl.swing.chart.util.ChartDataUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;

final class ChartDataHelper {
    ChartDataHelper() {
    }

    public static JFreeChart createChart(ChartModel modal) {
        ChartRenderData data = modal.getChartData();
        ChartType type = modal.getChartType();
        int angle = modal.getAngle();
        KDChart chart = new KDChart();
        chart.setChartType(type);
        chart.getChartTitle().setText(modal.getChartTitle());
        DecimalFormat format = null;
        if (!StringUtil.isEmptyString((String)modal.getValueNumberFormatStr())) {
            format = new DecimalFormat(modal.getValueNumberFormatStr());
        }
        if (type == ChartType.CT_PIE || type == ChartType.CT_PIEEXPLODED || type == ChartType.CT_PIE3D || type == ChartType.CT_MULTIPIE) {
            double[][] dData = data.getValues();
            if (dData[0].length > 1) {
                PieChartData pieChartData = ChartDataUtil.createPieChartData((String[])data.getGroupsKeys(), (double[])data.getValues()[0]);
                chart.addChartData((IChartData)pieChartData);
            } else {
                double[] serialData = new double[dData.length];
                for (int i = 0; i < dData.length; ++i) {
                    serialData[i] = dData[i][0];
                }
                PieChartData pieChartData = ChartDataUtil.createPieChartData((String[])data.getGroupsKeys(), (double[])serialData);
                chart.addChartData((IChartData)pieChartData);
            }
            chart.setPieChartValueFormat((NumberFormat)format);
        } else {
            CommonChartData commonChartData = ChartDataUtil.createCommonChartData((String[])data.getSeriesKeys(), (String[])data.getGroupsKeys(), (double[][])data.getValues());
            chart.addChartData((IChartData)commonChartData);
            chart.setCategoryLabelPositions(angle);
            NumberAxis axis = new NumberAxis();
            axis.setNumberFormatOverride((NumberFormat)format);
            axis.setLabel(modal.getValueAxisTitle());
            Plot plot = chart.getDelegate().getPlot();
            if (plot instanceof CategoryPlot) {
                ((CategoryPlot)plot).setRangeAxis((ValueAxis)axis);
            } else if (plot instanceof XYPlot) {
                ((XYPlot)plot).setRangeAxis((ValueAxis)axis);
            }
        }
        chart.getAxes(0).getCategotyAxis().getTitle().setText(modal.getCategoryAxisTitle());
        chart.getAxes(0).getValueAxis().getTitle().setText(modal.getValueAxisTitle());
        return chart.getDelegate();
    }

    public static ChartRenderData createChartData(SortedCellBlockArray blocks, Sheet sheet, boolean colSeriese, ArrayList groupArray, List<String> serialKeys) {
        ChartRenderData data = new ChartRenderData();
        if (groupArray != null) {
            data.setGroupsKeys(groupArray);
        }
        if (colSeriese) {
            int row = 0;
            int count = 0;
            for (int i = 0; i < blocks.size(); ++i) {
                CellBlock block = blocks.getBlock(i);
                for (int s = 0; s < block.getHeight(); ++s) {
                    if (null != serialKeys && s < serialKeys.size()) {
                        data.addSeriesKey(serialKeys.get(s));
                        continue;
                    }
                    data.addSeriesKey(String.valueOf(count++));
                }
                int r1 = block.getRow();
                int r2 = block.getRow2();
                int c1 = block.getCol();
                int c2 = block.getCol2();
                int serieseCount = 0;
                for (int j = r1; j <= r2; ++j) {
                    int series = serieseCount;
                    for (int k = c1; k <= c2; ++k) {
                        Cell cell = sheet.getCell(j, k, false);
                        if (cell != null) {
                            Variant var = cell.getValue();
                            try {
                                Double d = new Double(var.toBigDecimal().doubleValue());
                                data.setValue(row, series++, d);
                            }
                            catch (SyntaxErrorException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        data.setValue(row, series++, null);
                    }
                    ++row;
                }
            }
        } else {
            int serieseCount = 0;
            if (!blocks.isEmpty()) {
                for (int s = 0; s < blocks.getBlock(0).getWidth(); ++s) {
                    if (null != serialKeys && s < serialKeys.size()) {
                        data.addSeriesKey(serialKeys.get(s));
                        continue;
                    }
                    data.addSeriesKey(String.valueOf(s));
                }
            }
            for (int i = 0; i < blocks.size(); ++i) {
                CellBlock block = blocks.getBlock(i);
                int r1 = block.getRow();
                int r2 = block.getRow2();
                int c1 = block.getCol();
                int c2 = block.getCol2();
                int row = 0;
                for (int j = c1; j <= c2; ++j) {
                    int series = serieseCount;
                    for (int k = r1; k <= r2; ++k) {
                        Cell cell = sheet.getCell(k, j, false);
                        if (cell != null) {
                            Variant var = cell.getValue();
                            try {
                                Double d = new Double(var.toBigDecimal().doubleValue());
                                data.setValue(row, series++, d);
                            }
                            catch (SyntaxErrorException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        data.setValue(row, series++, null);
                    }
                    ++row;
                }
                serieseCount += block.getHeight();
            }
        }
        return data;
    }
}

