/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct.embed.chart;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.struct.AbstractCalculable;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;

public class ChartDataNode
extends AbstractCalculable
implements Comparable {
    private Sheet sheet;
    private CellBlockNode[] blocks;
    private boolean change = true;
    private boolean _serialByCol;

    public ChartDataNode(Sheet sheet) {
        this(sheet, null);
        this._serialByCol = true;
    }

    public ChartDataNode(Sheet sheet, CellBlockNode[] blocks) {
        this.sheet = sheet;
        this.setRange(blocks);
    }

    public static CellBlockNode[] getRange(Sheet sheet, SortedCellBlockArray blockArray) {
        int size = blockArray.size();
        CellBlockNode[] blocks = new CellBlockNode[size];
        for (int i = 0; i < size; ++i) {
            CellBlock block = blockArray.getBlock(i);
            blocks[i] = CellBlockNode.getNewBlock(sheet, block.getRow(), block.getCol(), block.getRow2(), block.getCol2(), 0);
        }
        return blocks;
    }

    public static CellBlockNode[] getSelectionRange(Sheet sheet) {
        return ChartDataNode.getRange(sheet, sheet.getSheetOption().getSelection().toSortedBlocks());
    }

    public void setRange(CellBlockNode[] blocks) {
        if (this.blocks != null) {
            // empty if block
        }
        this.blocks = blocks;
        if (blocks != null) {
            this.setDependent(blocks);
        } else {
            blocks = new CellBlockNode[]{};
        }
    }

    public CellBlockNode[] getRange() {
        return this.blocks;
    }

    private void setDependent(CellBlockNode[] blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            this.sheet.setDependent((ICalculable)this, blocks[i]);
        }
    }

    @Override
    public boolean calc(ExprContext ctx) {
        this.setDependent(this.getRange());
        this.setChange(true);
        return true;
    }

    @Override
    public Sheet getSheet() {
        return this.sheet;
    }

    @Override
    public Variant getValue() {
        return null;
    }

    @Override
    public void updateExpr(boolean queue) {
    }

    @Override
    public void updateFormula() {
    }

    public boolean isChange() {
        return this.change;
    }

    public void setChange(boolean change) {
        this.change = change;
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        int cmp = 1;
        if (obj instanceof ICalculable && (cmp = this.getCalculableType() - ((ICalculable)obj).getCalculableType()) != 0) {
            return cmp;
        }
        if (cmp == 0) {
            return this.blocks[0].compareTo(((ChartDataNode)obj).blocks[0]);
        }
        return cmp;
    }

    @Override
    public int getCalculableType() {
        return 2;
    }

    public boolean isSerialByCol() {
        return this._serialByCol;
    }

    public void setSerialByCol(boolean serialByCol) {
        if (this._serialByCol != serialByCol) {
            this._serialByCol = serialByCol;
        }
    }
}

