/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct.embed.chart;

import com.kingdee.bos.ctrl.common.util.CollectionUtil;
import java.util.ArrayList;
import java.util.List;

final class ChartRenderData {
    private ArrayList seriesKeys = new ArrayList();
    private ArrayList groupsKeys = new ArrayList();
    private ArrayList values = new ArrayList();

    public String[] getSeriesKeys() {
        int size = this.seriesKeys.size();
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = (String)this.seriesKeys.get(i);
        }
        return keys;
    }

    public String[] getGroupsKeys() {
        int size = this.groupsKeys.size();
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = (String)this.groupsKeys.get(i);
        }
        return keys;
    }

    public void setGroupsKeys(ArrayList s) {
        this.groupsKeys = s;
    }

    public double[][] getValues() {
        int r = this.values.size();
        int c = 0;
        for (int i = 0; i < r; ++i) {
            ArrayList row = (ArrayList)this.values.get(i);
            if (row == null || row.size() <= c) continue;
            c = row.size();
        }
        double[][] vs = new double[r][c];
        for (int i = 0; i < r; ++i) {
            ArrayList row = (ArrayList)this.values.get(i);
            if (row == null) continue;
            for (int j = 0; j < row.size(); ++j) {
                Double d = (Double)row.get(j);
                if (d == null) continue;
                vs[i][j] = d;
            }
        }
        return vs;
    }

    public void addSeriesKey(String key) {
        this.seriesKeys.add(key);
    }

    public void addGroupKey(String key) {
        this.groupsKeys.add(key);
    }

    public void setValue(int r, int c, Double d) {
        if (r == this.values.size()) {
            this.values.add(new ArrayList());
        } else if (r > this.values.size()) {
            CollectionUtil.resizeList((List)this.values, (int)(r + 1));
        }
        ArrayList<Double> row = (ArrayList<Double>)this.values.get(r);
        if (row == null) {
            row = new ArrayList<Double>();
            this.values.set(r, row);
        }
        if (c == row.size()) {
            row.add(null);
        } else if (c > row.size()) {
            CollectionUtil.resizeList(row, (int)(c + 1));
        }
        row.set(c, d);
    }
}

