/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.bim.tabledesigner;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTColumnMoveEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTColumnMoveListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTResizeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTResizeListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.report.forapp.bim.tabledesigner.BasicValue;
import com.kingdee.bos.ctrl.report.forapp.bim.tabledesigner.BindObjectDialog;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class KDTDesignerPanel
extends KDPanel {
    private static final long serialVersionUID = -1398245074749684239L;
    private KDSplitPane mainSplitPane;
    private KDPanel treePane;
    private KDSplitPane rightSplitPane;
    private KDPanel designPanel;
    private KDPanel propertyPanel;
    private KDTable designTable;
    private KDTable propertyTable;
    private DesignTableMoveListener tableMoveListener;
    private int panelWidth;
    private int panelHeight;
    private IRow headRow;
    private KDPromptSelector dialog;
    private KDPopupMenu popup;
    private KDPromptBox pb;
    private KDSpinner spinner;
    private boolean contentChanged = false;
    private KDPopupMenu propertyTablePopup;

    public KDTDesignerPanel(BindObjectDialog dialog) {
        this(550, 300, dialog);
    }

    public KDTDesignerPanel(int width, int height, BindObjectDialog dialog) {
        super((LayoutManager)new BorderLayout());
        this.panelWidth = width;
        this.panelHeight = height;
        this.setSize(width, height);
        this.setF7Dialog(dialog);
        this.init();
    }

    public IRow getHeadRow() {
        if (this.headRow == null) {
            this.headRow = this.designTable.getHeadRow(0);
        }
        return this.headRow;
    }

    public KDSplitPane getMainSplitPane() {
        if (this.mainSplitPane == null) {
            this.mainSplitPane = new KDSplitPane(1, (Component)this.getTreePane(), (Component)this.getRightSplitPane());
            this.mainSplitPane.setDividerLocation(170);
        }
        return this.mainSplitPane;
    }

    public KDPanel getTreePane() {
        if (this.treePane == null) {
            this.treePane = new KDPanel();
            TreeUINode root = ((BindObjectDialog)this.dialog).getTreeCtrl().getTreeUI().getRootNode();
            ((BindObjectDialog)this.dialog).getTreeCtrl().getTreeUI().removeAllChildrenNodes(root);
            for (int i = 0; i < ((BindObjectDialog)this.dialog).getTreeCtrl().getSchemes().length; ++i) {
                MetaClass scheme = ((BindObjectDialog)this.dialog).getTreeCtrl().getSchemes()[i];
                TreeUINode nodeScheme = new TreeUINode(scheme.getName());
                nodeScheme.setAlias(scheme.getAlias());
                nodeScheme.setUserObject((Object)scheme);
                ((BindObjectDialog)this.dialog).getTreeCtrl().getTreeUI().addChildNode(nodeScheme, root);
            }
            ((BindObjectDialog)this.dialog).getTreeCtrl().getTreeUI().expand(new TreePath(root));
            this.treePane.setLayout((LayoutManager)new BorderLayout());
            this.treePane.add((Component)((BindObjectDialog)this.dialog).getTreeCtrl().getTreeUI());
            ((BindObjectDialog)this.dialog).getTreeCtrl().getTreeUI().setTitle(LanguageManager.getLangMessage((String)"KDTDesignerPanel.label.fields", KDTDesignerPanel.class, (String)""));
        }
        return this.treePane;
    }

    public KDSplitPane getRightSplitPane() {
        if (this.rightSplitPane == null) {
            this.rightSplitPane = new KDSplitPane(0, (Component)this.getDesignPanel(), (Component)this.getPropertyPanel());
            this.rightSplitPane.setDividerLocation(0.3);
            this.rightSplitPane.setSize(this.panelWidth, this.panelHeight);
        }
        return this.rightSplitPane;
    }

    private KDPanel getDesignPanel() {
        if (this.designPanel == null) {
            KDContainer container = new KDContainer();
            container.setContainerType(2);
            container.setTitle(LanguageManager.getLangMessage((String)"KDTDesignerPanel.designerPanel.title", KDTDesignerPanel.class, (String)""));
            container.getContentPane().setLayout(new BorderLayout());
            container.getContentPane().add((Component)this.getDesignTable(), "Center");
            this.designPanel = new KDPanel();
            this.designPanel.setLayout((LayoutManager)new BorderLayout());
            this.designPanel.add((Component)new KDContainer(), (Object)"Center");
            this.designPanel.add((Component)container, (Object)"Center");
            this.designPanel.setToolTipText(LanguageManager.getLangMessage((String)"KDTDesignerPanel.tooltips.design", KDTDesignerPanel.class, (String)""));
        }
        return this.designPanel;
    }

    private KDPanel getPropertyPanel() {
        if (this.propertyPanel == null) {
            KDContainer container = new KDContainer();
            container.setContainerType(2);
            container.setTitle(LanguageManager.getLangMessage((String)"KDTDesignerPanel.propertyPanel.title", KDTDesignerPanel.class, (String)""));
            container.getContentPane().setLayout(new BorderLayout());
            container.getContentPane().add((Component)this.getPropertyTable(), "Center");
            this.propertyPanel = new KDPanel();
            this.propertyPanel.setLayout((LayoutManager)new BorderLayout());
            this.propertyPanel.add((Component)container, (Object)"Center");
        }
        return this.propertyPanel;
    }

    private KDPromptBox getKDPromptBox() {
        if (this.pb == null) {
            this.pb = new KDPromptBox();
            this.pb.setSelector(this.getF7Dialog());
            this.pb.setEditable(true);
            this.pb.setSize(200, 100);
        }
        return this.pb;
    }

    private KDTable getPropertyTable() {
        if (this.propertyTable == null) {
            this.propertyTable = new KDTable(6, 1, 0);
            this.propertyTable.getColumn(1).getStyleAttributes().setHided(true);
            this.propertyTable.getColumn(2).getStyleAttributes().setLocked(true);
            KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((IKDEditor)this.getKDPromptBox());
            this.propertyTable.getColumn(3).setEditor((ICellEditor)cellEditor);
            KDFormattedTextField integerField = new KDFormattedTextField(0);
            KDTDefaultCellEditor cellEditor2 = new KDTDefaultCellEditor((JTextField)integerField);
            this.propertyTable.getColumn(4).setEditor((ICellEditor)cellEditor2);
            this.propertyTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    int rowIndex = e.getRowIndex();
                    int colIndex = e.getColIndex();
                    switch (colIndex) {
                        case 0: {
                            if (e.getValue() != null) {
                                KDTDesignerPanel.this.getHeadRow().getCell(e.getRowIndex()).setValue(e.getValue());
                            }
                            KDTDesignerPanel.this.setContentChanged(true);
                            break;
                        }
                        case 1: {
                            if (e.getValue() != null) {
                                KDTDesignerPanel.this.designTable.getColumn(e.getRowIndex()).setKey(e.getValue().toString());
                            }
                            KDTDesignerPanel.this.setContentChanged(true);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            if (e.getValue() != null) {
                                try {
                                    KDTDesignerPanel.this.propertyTable.getCell(e.getRowIndex(), e.getColIndex() - 1).setValue((Object)((BasicValue)KDTDesignerPanel.this.propertyTable.getCell(e.getRowIndex(), e.getColIndex()).getValue()).getSimple());
                                    KDTDesignerPanel.this.propertyTable.getCell(e.getRowIndex(), 0).setValue((Object)((BasicValue)KDTDesignerPanel.this.propertyTable.getCell(e.getRowIndex(), e.getColIndex()).getValue()).getFieldAliasName());
                                    KDTDesignerPanel.this.getHeadRow().getCell(e.getRowIndex()).setValue((Object)((BasicValue)KDTDesignerPanel.this.propertyTable.getCell(e.getRowIndex(), e.getColIndex()).getValue()).getFieldAliasName());
                                    KDTDesignerPanel.this.designTable.getColumn(e.getRowIndex()).setKey(e.getValue().toString());
                                    KDTDesignerPanel.this.designTable.getDataRequestManager().putBindContents(rowIndex, ((BasicValue)e.getValue()).getObject(), ((BasicValue)e.getValue()).getField());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            KDTDesignerPanel.this.setContentChanged(true);
                            break;
                        }
                        case 4: {
                            try {
                                int width = Integer.parseInt(e.getValue().toString());
                                KDTDesignerPanel.this.designTable.getColumn(e.getRowIndex()).setWidth(width);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            KDTDesignerPanel.this.setContentChanged(true);
                        }
                    }
                }

                public void editValueChanged(KDTEditEvent e) {
                    int colIndex = e.getColIndex();
                    switch (colIndex) {
                        case 5: {
                            try {
                                boolean hide = (Boolean)e.getValue();
                                KDTDesignerPanel.this.designTable.getColumn(e.getRowIndex()).getStyleAttributes().setHided(hide);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            KDTDesignerPanel.this.setContentChanged(true);
                        }
                    }
                }
            });
            this.propertyTable.setSize(this.panelWidth - 30, this.panelHeight / 2 - 10);
            this.propertyTable.setPreferredSize(new Dimension(this.panelWidth, this.panelHeight / 2));
            this.propertyTable.getSelectManager().setSelectMode(2);
            IRow headRow = this.propertyTable.getHeadRow(0);
            headRow.getCell(0).setValue((Object)LanguageManager.getLangMessage((String)"KDTDesignerPanel.propertyPanel.name", KDTDesignerPanel.class, (String)""));
            headRow.getCell(1).setValue((Object)LanguageManager.getLangMessage((String)"KDTDesignerPanel.propertyPanel.alias", KDTDesignerPanel.class, (String)""));
            headRow.getCell(2).setValue((Object)LanguageManager.getLangMessage((String)"KDTDesignerPanel.propertyPanel.bindObject", KDTDesignerPanel.class, (String)""));
            headRow.getCell(3).setValue((Object)LanguageManager.getLangMessage((String)"KDTDesignerPanel.propertyPanel.bindField", KDTDesignerPanel.class, (String)""));
            headRow.getCell(4).setValue((Object)LanguageManager.getLangMessage((String)"KDTDesignerPanel.propertyPanel.width", KDTDesignerPanel.class, (String)""));
            headRow.getCell(5).setValue((Object)LanguageManager.getLangMessage((String)"KDTDesignerPanel.propertyPanel.hide", KDTDesignerPanel.class, (String)""));
            this.propertyTable.addKDTMouseListener(new KDTMouseListener(){

                public void tableClicked(KDTMouseEvent e) {
                    if (SwingUtilities.isRightMouseButton((MouseEvent)e) && e.getClickCount() == 1) {
                        KDTDesignerPanel.this.getPropertyTablePopup().show(e.getOriginView(), e.getX(), e.getY());
                    }
                }
            });
        }
        return this.propertyTable;
    }

    public String getXML() {
        return this.getDesignTable().getFormatXml();
    }

    public void getStream(OutputStream out) {
        KDTable kdt = this.getDesignTable();
        kdt.setID(Locale.getDefault().toString());
        kdt.getFormatXml(out);
    }

    public void setStream(InputStream input) {
        this.getDesignTable().setFormatXml(input);
        this.getDesignTable().checkParsed(true);
        KDTDesignerPanel.convertChinese(this.getDesignTable());
        for (int j = 0; j < 3; ++j) {
            this.getDesignTable().addRow();
        }
        int count = this.getDesignTable().getColumnCount();
        for (int i = 0; i < count; ++i) {
            this.getPropertyTable().addRow();
        }
        for (int m = 0; m < count; ++m) {
            IColumn col = this.getDesignTable().getColumn(m);
            Object name = this.getHeadRow().getCell(m).getValue();
            String name2 = col.getKey();
            String object = col.getDataSourceName();
            String field = col.getFieldName();
            int width = col.getKDTColumn().getWidth();
            boolean hide = col.getStyleAttributes().isHided();
            this.designToProperty(m, name, name2, object, field, width, hide);
        }
    }

    public void setXML(String string) {
        this.getDesignTable().setFormatXml(string);
        this.getDesignTable().checkParsed(true);
        for (int j = 0; j < 5; ++j) {
            this.getDesignTable().addRow();
        }
        int count = this.getDesignTable().getColumnCount();
        for (int i = 1; i < count; ++i) {
            this.getPropertyTable().addRow();
        }
        for (int m = 0; m < count; ++m) {
            IColumn col = this.getDesignTable().getColumn(m);
            Object name = this.getHeadRow().getCell(m).getValue();
            String name2 = col.getKey();
            String object = col.getDataSourceName();
            String field = col.getFieldName();
            int width = col.getKDTColumn().getWidth();
            boolean hide = col.getStyleAttributes().isHided();
            this.designToProperty(m, name, name2, object, field, width, hide);
        }
    }

    private void designToProperty(int i, Object name, String name2, String object, String field, int width, boolean hide) {
        IRow row = this.getPropertyTable().getRow(i);
        if (name != null) {
            row.getCell(0).setValue((Object)name.toString());
        }
        if (name2 != null) {
            row.getCell(1).setValue((Object)name2);
        }
        if (object != null) {
            row.getCell(2).setValue((Object)object);
        }
        if (field != null) {
            row.getCell(3).setValue((Object)field);
        }
        row.getCell(4).setValue((Object)new Integer(width));
        row.getCell(5).setValue((Object)new Boolean(hide));
    }

    private KDTable getDesignTable() {
        if (this.designTable == null) {
            this.designTable = new KDTable(0, 1, 3);
            this.designTable.setColumnMoveable(true);
            this.designTable.setEditable(false);
            this.designTable.setPreferredSize(new Dimension(this.panelWidth, this.panelHeight / 2));
            this.popup = new KDPopupMenu();
            KDMenuItem addColumnItem = new KDMenuItem(LanguageManager.getLangMessage((String)"KDTDesignerPanel.menu.insertColumnItem", KDTDesignerPanel.class, (String)""));
            addColumnItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KDTDesignerPanel.this.addColumn();
                }
            });
            KDMenuItem addColumnsItem = new KDMenuItem(LanguageManager.getLangMessage((String)"KDTDesignerPanel.menu.insertColumnsItem", KDTDesignerPanel.class, (String)""));
            addColumnsItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TypicalDialog dlg = new TypicalDialog(){
                        private static final long serialVersionUID = -4116007927616414089L;
                        private KDLabelContainer lbContainer;

                        protected void todoInit() {
                            KDTDesignerPanel.this.spinner = new KDSpinner();
                            this.lbContainer = new KDLabelContainer();
                            this.lbContainer.setBoundEditor((JComponent)KDTDesignerPanel.this.spinner);
                            this.lbContainer.setBoundLabelText(LanguageManager.getLangMessage((String)"KDTDesignerPanel.label.columnNumbersToInsert", KDTDesignerPanel.class, (String)""));
                            this.lbContainer.setBoundLabelUnderline(true);
                            this.setSize(300, 110);
                        }

                        protected void todoAddControls(Container parent, Cell thisCell) {
                            parent.add((Component)this.lbContainer, thisCell);
                        }
                    };
                    if (dlg.showDialog()) {
                        int columnNum = (Integer)KDTDesignerPanel.this.spinner.getValue();
                        KDTDesignerPanel.this.addColumns(columnNum);
                    }
                }
            });
            KDMenuItem deleteColumnItem = new KDMenuItem(LanguageManager.getLangMessage((String)"KDTDesignerPanel.menu.deleteColumnItem", KDTDesignerPanel.class, (String)""));
            deleteColumnItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KDTDesignerPanel.this.removeColumn();
                }
            });
            KDMenuItem moveColumnItem = new KDMenuItem(LanguageManager.getLangMessage((String)"KDTDesignerPanel.menu.moveColumnItem", KDTDesignerPanel.class, (String)""));
            moveColumnItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KDTDesignerPanel.this.moveColumn();
                }
            });
            this.popup.add((JMenuItem)addColumnItem);
            this.popup.add((JMenuItem)addColumnsItem);
            this.popup.add((JMenuItem)deleteColumnItem);
            this.popup.add((JMenuItem)moveColumnItem);
            this.designTable.getSelectManager().setSelectMode(12);
            this.designTable.addKDTSelectListener(new KDTSelectListener(){

                public void tableSelectChanged(KDTSelectEvent e) {
                    KDTDesignerPanel.this.showTableToEditTable();
                }
            });
            this.designTable.addKDTMouseListener(new KDTMouseListener(){

                public void tableClicked(KDTMouseEvent e) {
                    if (SwingUtilities.isRightMouseButton((MouseEvent)e)) {
                        KDTDesignerPanel.this.popup.show(e.getOriginView(), e.getX(), e.getY());
                    }
                }
            });
            this.designTable.addKDTResizeListener(new KDTResizeListener(){

                public void tableRowResize(KDTResizeEvent e) {
                }

                public void tableColumnResize(KDTResizeEvent e) {
                    KDTable edit = KDTDesignerPanel.this.getPropertyTable();
                    KDTColumns cols = ((KDTable)e.getSource()).getColumns();
                    for (int i = 0; i < cols.size(); ++i) {
                        edit.getRow(i).getCell(4).setValue((Object)new Integer(cols.getColumnWidth(i)));
                    }
                }
            });
        }
        if (this.tableMoveListener == null) {
            this.tableMoveListener = new DesignTableMoveListener(this.designTable, this.getPropertyTable());
            this.designTable.addKDTColumnMoveListener((KDTColumnMoveListener)this.tableMoveListener);
        }
        return this.designTable;
    }

    private void init() {
        this.setCustomInsets(new Insets(10, 10, 10, 10));
        this.add((Component)this.getMainSplitPane(), "Center");
    }

    public void addColumns(int colCount) {
        KDTSelectBlock sbCurr = this.getDesignTable().getSelectManager().get();
        IColumn column = null;
        IRow row = null;
        if (sbCurr == null) {
            for (int i = 0; i < colCount; ++i) {
                column = this.getDesignTable().addColumn();
                column.setWidth(100);
                row = this.getPropertyTable().addRow();
                row.getCell(4).setValue((Object)new Integer(100));
                row.getCell(5).setValue((Object)new Boolean(false));
            }
        } else {
            int activeColIndex = sbCurr.getBeginCol();
            for (int i = 0; i < colCount; ++i) {
                column = this.getDesignTable().addColumn(activeColIndex);
                column.setWidth(100);
                row = this.getPropertyTable().addRow(activeColIndex);
                row.getCell(4).setValue((Object)new Integer(100));
                row.getCell(5).setValue((Object)new Boolean(false));
            }
        }
    }

    public void addColumn() {
        int index = this.getDesignTable().getSelectManager().getActiveColumnIndex();
        KDTSelectBlock sbCurr = this.getDesignTable().getSelectManager().get();
        if (index == -1) {
            if (sbCurr == null) {
                IColumn column = this.getDesignTable().addColumn();
                column.setWidth(100);
                IRow row = this.getPropertyTable().addRow();
                row.getCell(4).setValue((Object)new Integer(100));
                row.getCell(5).setValue((Object)new Boolean(false));
                this.getDesignTable().getSelectManager().setActiveColumnIndex(column.getColumnIndex());
                this.getPropertyTable().getSelectManager().setActiveRowIndex(row.getRowIndex());
            } else {
                IColumn column = this.getDesignTable().addColumn(sbCurr.getBeginCol());
                column.setWidth(100);
                IRow row = this.getPropertyTable().addRow(sbCurr.getBeginCol());
                row.getCell(4).setValue((Object)new Integer(100));
                row.getCell(5).setValue((Object)new Boolean(false));
                this.getDesignTable().getSelectManager().setActiveColumnIndex(column.getColumnIndex());
                this.getPropertyTable().getSelectManager().setActiveRowIndex(row.getRowIndex());
            }
        } else if (sbCurr == null) {
            IColumn column = this.getDesignTable().addColumn();
            column.setWidth(100);
            IRow row = this.getPropertyTable().addRow();
            row.getCell(4).setValue((Object)new Integer(100));
            row.getCell(5).setValue((Object)new Boolean(false));
            this.getDesignTable().getSelectManager().setActiveColumnIndex(column.getColumnIndex());
            this.getPropertyTable().getSelectManager().setActiveRowIndex(row.getRowIndex());
        } else {
            IColumn column = this.getDesignTable().addColumn(sbCurr.getBeginCol());
            column.setWidth(100);
            IRow row = this.getPropertyTable().addRow(sbCurr.getBeginCol());
            row.getCell(4).setValue((Object)new Integer(100));
            row.getCell(5).setValue((Object)new Boolean(false));
            this.getDesignTable().getSelectManager().setActiveColumnIndex(column.getColumnIndex());
            this.getPropertyTable().getSelectManager().setActiveRowIndex(row.getRowIndex());
        }
    }

    public void addColumn(String name, String alias, Object bindObject, String bindObjName) {
        KDTSelectBlock sbCurr = this.getDesignTable().getSelectManager().get();
        if (sbCurr == null) {
            IColumn column = this.getDesignTable().addColumn();
            column.setWidth(100);
            IRow row = this.getPropertyTable().addRow();
            row.getCell(0).setValue((Object)bindObjName);
            this.getHeadRow().getCell(row.getRowIndex()).setValue((Object)bindObjName);
            row.getCell(1).setValue((Object)alias);
            this.getDesignTable().getColumn(row.getRowIndex()).setKey(alias);
            row.getCell(2).setValue((Object)((BasicValue)bindObject).getSimple());
            this.getDesignTable().getDataRequestManager().putBindContents(row.getRowIndex(), ((BasicValue)bindObject).getObject(), ((BasicValue)bindObject).getField());
            row.getCell(3).setValue((Object)bindObjName);
            row.getCell(4).setValue((Object)new Integer(100));
            row.getCell(5).setValue((Object)new Boolean(false));
        } else {
            this.getDesignTable().addColumn(sbCurr.getBeginCol());
            IColumn column = this.getDesignTable().addColumn();
            column.setWidth(100);
            IRow row = this.getPropertyTable().addRow(sbCurr.getBeginCol());
            row.getCell(0).setValue((Object)bindObjName);
            this.getHeadRow().getCell(row.getRowIndex()).setValue((Object)bindObjName);
            row.getCell(1).setValue((Object)alias);
            this.getDesignTable().getColumn(row.getRowIndex()).setKey(alias);
            row.getCell(2).setValue(bindObject);
            this.getDesignTable().getDataRequestManager().putBindContents(row.getRowIndex(), ((BasicValue)bindObject).getObject(), ((BasicValue)bindObject).getField());
            row.getCell(3).setValue((Object)bindObjName);
            row.getCell(4).setValue((Object)new Integer(100));
            row.getCell(5).setValue((Object)new Boolean(false));
        }
    }

    public void removeColumn() {
        KDTSelectBlock sbCurr = this.getDesignTable().getSelectManager().get();
        if (sbCurr == null) {
            if (this.getDesignTable().getColumnCount() > 1) {
                this.getDesignTable().removeColumn(this.getDesignTable().getColumnCount() - 1);
                this.getPropertyTable().removeRow(this.getPropertyTable().getRowCount3() - 1);
            }
        } else {
            ArrayList list = this.getDesignTable().getSelectManager().getBlocks();
            for (int i = list.size() - 1; i >= 0; --i) {
                KDTSelectBlock blockitem = (KDTSelectBlock)list.get(i);
                int endCol = blockitem.getEndCol();
                int beginCol = blockitem.getBeginCol();
                for (int j = endCol; j >= beginCol; --j) {
                    if (this.getDesignTable().getColumnCount() <= 1) continue;
                    this.getDesignTable().removeColumn(j);
                    this.getPropertyTable().removeRow(j);
                }
            }
        }
    }

    public void editColumnStyle() {
        this.getDesignTable().showStyleDesigner();
    }

    public void moveColumn() {
        TypicalDialog dlg = new TypicalDialog(){
            private static final long serialVersionUID = -4116007927616414089L;
            private KDLabelContainer lbContainer;

            protected void todoInit() {
                KDTDesignerPanel.this.spinner = new KDSpinner();
                ((SpinnerNumberModel)KDTDesignerPanel.this.spinner.getModel()).setMinimum(new Integer(1));
                KDTDesignerPanel.this.spinner.setValue((Object)new Integer(1));
                this.lbContainer = new KDLabelContainer();
                this.lbContainer.setBoundEditor((JComponent)KDTDesignerPanel.this.spinner);
                this.lbContainer.setBoundLabelText(LanguageManager.getLangMessage((String)"KDTDesignerPanel.label.columnIndexToMove", KDTDesignerPanel.class, (String)""));
                this.lbContainer.setBoundLabelUnderline(true);
                this.setSize(300, 110);
            }

            protected void todoAddControls(Container parent, Cell thisCell) {
                parent.add((Component)this.lbContainer, thisCell);
            }
        };
        int fromColumnIndex = this.getDesignTable().getSelectManager().getActiveColumnIndex();
        int toColumnIndex = -1;
        if (dlg.showDialog()) {
            toColumnIndex = (Integer)this.spinner.getValue() - 1;
            if (toColumnIndex > fromColumnIndex) {
                this.getDesignTable().moveColumn(fromColumnIndex, toColumnIndex + 1);
            } else {
                this.getDesignTable().moveColumn(fromColumnIndex, toColumnIndex);
            }
            this.getDesignTable().getSelectManager().select(0, toColumnIndex);
        }
    }

    public void setF7Dialog(KDPromptSelector dialog) {
        this.dialog = dialog;
    }

    public KDPromptSelector getF7Dialog() {
        return this.dialog;
    }

    public void headColMerge() {
        KDTMergeManager mm = this.getDesignTable().getHeadMergeManager();
        int beginCol = this.getDesignTable().getSelectManager().get().getBeginCol();
        int endCol = this.getDesignTable().getSelectManager().get().getEndCol();
        mm.mergeBlock(0, beginCol, 0, endCol);
    }

    public void headColSplit() {
        KDTMergeManager mm = this.getDesignTable().getHeadMergeManager();
        int beginCol = this.getDesignTable().getSelectManager().get().getBeginCol();
        int endCol = this.getDesignTable().getSelectManager().get().getEndCol();
        mm.splitBlock(0, beginCol, 0, endCol);
    }

    public boolean isContentChanged() {
        return this.contentChanged;
    }

    public void setContentChanged(boolean contentChanged) {
        this.contentChanged = contentChanged;
    }

    private void showTableToEditTable() {
        KDTable show = this.getDesignTable();
        KDTable edit = this.getPropertyTable();
        int showActiveColIndex = show.getSelectManager().getActiveColumnIndex();
        if (showActiveColIndex >= 0) {
            edit.getSelectManager().select(showActiveColIndex, 0, 2);
        }
    }

    private KDPopupMenu getPropertyTablePopup() {
        if (this.propertyTablePopup == null) {
            this.propertyTablePopup = new KDPopupMenu();
            KDMenuItem hideItem = new KDMenuItem(LanguageManager.getLangMessage((String)"KDTDesignerPanel.hideAll", KDTDesignerPanel.class, (String)""));
            hideItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KDTDesignerPanel.this.hideAllColumn();
                }
            });
            KDMenuItem showItem = new KDMenuItem(LanguageManager.getLangMessage((String)"KDTDesignerPanel.showAll", KDTDesignerPanel.class, (String)""));
            showItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KDTDesignerPanel.this.showAllColumn();
                }
            });
            this.propertyTablePopup.add((JMenuItem)hideItem);
            this.propertyTablePopup.add((JMenuItem)showItem);
        }
        return this.propertyTablePopup;
    }

    private void hideAllColumn() {
        int rc = this.propertyTable.getRowCount();
        for (int i = 0; i < rc; ++i) {
            this.propertyTable.getCell(i, 5).setValue((Object)Boolean.TRUE);
            this.designTable.getColumn(i).getStyleAttributes().setHided(true);
        }
    }

    private void showAllColumn() {
        int rc = this.propertyTable.getRowCount();
        for (int i = 0; i < rc; ++i) {
            this.propertyTable.getCell(i, 5).setValue((Object)Boolean.FALSE);
            this.designTable.getColumn(i).getStyleAttributes().setHided(false);
        }
    }

    public static void convertChinese(KDTable kdt) {
        Locale dl = Locale.getDefault();
        if (!Locale.SIMPLIFIED_CHINESE.equals(dl) && !Locale.TRADITIONAL_CHINESE.equals(dl)) {
            return;
        }
        String lang = kdt.getID();
        Locale l = null;
        if (lang.startsWith("KDT")) {
            l = Locale.SIMPLIFIED_CHINESE;
        } else if (lang.equals(Locale.SIMPLIFIED_CHINESE.toString())) {
            l = Locale.SIMPLIFIED_CHINESE;
        } else if (lang.equals(Locale.TRADITIONAL_CHINESE.toString())) {
            l = Locale.TRADITIONAL_CHINESE;
        } else {
            return;
        }
        if (dl.equals(l)) {
            return;
        }
        boolean sc2tc = Locale.SIMPLIFIED_CHINESE == l;
        int colCount = kdt.getColumnCount();
        int z = kdt.getHeadRowCount();
        for (int i = 0; i < z; ++i) {
            IRow row = kdt.getHeadRow(i);
            for (int j = 0; j < colCount; ++j) {
                ICell cell = row.getCell(i);
                String s = (String)cell.getValue();
                if (!StringUtil.isEmptyString((String)s)) {
                    s = sc2tc ? STConverter.sc2tc((String)s) : STConverter.tc2sc((String)s);
                }
                cell.setValue((Object)s);
            }
        }
    }

    private class DesignTableMoveListener
    implements KDTColumnMoveListener {
        KDTable designTbl;
        KDTable propertiesTbl;

        public DesignTableMoveListener(KDTable designTbl, KDTable propertiesTbl) {
            this.designTbl = designTbl;
            this.propertiesTbl = propertiesTbl;
        }

        public void columnMoved(KDTColumnMoveEvent e) {
            this.propertiesTbl.moveRow(e.getValue1(), e.getValue2());
        }
    }
}

