/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataParameter;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintRuntimeException;
import com.kingdee.bos.dao.query.IMultiQueryExecutor;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.MultiQueryExecutorFactory;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class DefaultNoteDataProvider
extends AbstractPrintDataProvider {
    public static final Logger log = LogUtil.getPackageLogger(DefaultNoteDataProvider.class);
    private ICustomQueryExecutorFactory _customQueryExecutorFactory;
    private HashMap _proxyTargets;
    private HashMap _qpks;
    private HashMap _foreignKeys;
    private HashMap _customFilterMakers = new HashMap();
    private IMetaDataPK _qpk4Single;
    private ICustomFilterMaker _customFilterMaker4Single;
    private boolean _isBatchSupported = false;
    private int _numberOfEachBatch = 50;
    private HashMap _dsCache;
    private HashMap _assMainDsCursors;
    private Context ctx = null;

    public DefaultNoteDataProvider() {
    }

    public DefaultNoteDataProvider(Set dataIds) {
        this(dataIds, null);
    }

    public DefaultNoteDataProvider(List dataIds) {
        this(dataIds, null);
    }

    public DefaultNoteDataProvider(Set dataIds, IMetaDataPK singleQpk) {
        this.setMetaDataPK(singleQpk);
        this.setCustomFilterMaker(new DefaultIdFilterMaker(dataIds));
    }

    public DefaultNoteDataProvider(List dataIds, IMetaDataPK singleQpk) {
        this(new HashSet(dataIds), singleQpk);
    }

    public DefaultNoteDataProvider(Context ctx, List dataIds, IMetaDataPK singleQpk) {
        this(new HashSet(dataIds), singleQpk);
        this.ctx = ctx;
    }

    private HashMap getMapProxyTargets() {
        if (this._proxyTargets == null) {
            this._proxyTargets = new HashMap();
        }
        return this._proxyTargets;
    }

    private HashMap getMapForeignKeys() {
        if (this._foreignKeys == null) {
            this._foreignKeys = new HashMap();
        }
        return this._foreignKeys;
    }

    private HashMap getMapMetaDataPKs() {
        if (this._qpks == null) {
            this._qpks = new HashMap();
        }
        return this._qpks;
    }

    private HashMap getMapDs() {
        if (this._dsCache == null) {
            this._dsCache = new HashMap();
        }
        return this._dsCache;
    }

    private HashMap getMapCursors() {
        if (this._assMainDsCursors == null) {
            this._assMainDsCursors = new HashMap();
        }
        return this._assMainDsCursors;
    }

    public void addProxyTarget(String ds, AbstractPrintDataProvider dataProvider) {
        this.getMapProxyTargets().put(ds, dataProvider);
    }

    private AbstractPrintDataProvider getProxyTarget(String ds) {
        return (AbstractPrintDataProvider)this.getMapProxyTargets().get(ds);
    }

    public void setCustomQueryExecutorFactory(ICustomQueryExecutorFactory customQueryExecutorFactory) {
        this._customQueryExecutorFactory = customQueryExecutorFactory;
    }

    private ICustomQueryExecutorFactory getCustomQueryExecutorFactory() {
        if (this._customQueryExecutorFactory == null) {
            this._customQueryExecutorFactory = new DefaultQueryExecutorFactory();
        }
        return this._customQueryExecutorFactory;
    }

    public void setMetaDataPK(IMetaDataPK qpk) {
        this._qpk4Single = qpk;
    }

    public void addMetaDataPK(String ds, IMetaDataPK qpk) {
        this.getMapMetaDataPKs().put(ds, qpk);
    }

    private IMetaDataPK getMetaDataPK(String ds) {
        IMetaDataPK qpk = (IMetaDataPK)this.getMapMetaDataPKs().get(ds);
        if (qpk == null) {
            return this._qpk4Single;
        }
        return qpk;
    }

    public void addForeignKey(Object key, String colName) {
        this.getMapForeignKeys().put(key, colName);
    }

    private String getForeignKey(Object ds) {
        return (String)this.getMapForeignKeys().get(ds);
    }

    public void setCustomFilterMaker(ICustomFilterMaker customFilterMaker) {
        this._customFilterMaker4Single = customFilterMaker;
    }

    public void addCustomFilterMaker(String ds, ICustomFilterMaker customFilterMaker) {
        this._customFilterMakers.put(ds, customFilterMaker);
    }

    private ICustomFilterMaker getCustomFilterMaker_ForMain(String ds) {
        ICustomFilterMaker filter = (ICustomFilterMaker)this._customFilterMakers.get(ds);
        if (filter == null) {
            filter = this._customFilterMaker4Single;
        }
        return filter;
    }

    private ICustomFilterMaker getCustomFilterMaker(String ds) {
        ICustomFilterMaker filter = (ICustomFilterMaker)this._customFilterMakers.get(ds);
        return filter;
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        IRowSet rowSet;
        IMetaDataPK pk;
        String dsId = dataSource.getId();
        log.info((Object)("DefaultNoteDataProvider.getData start... Datasource id: " + dsId));
        AbstractPrintDataProvider proxyTarget = this.getProxyTarget(dsId);
        if (proxyTarget != null) {
            log.info((Object)"DefaultNoteDataProvider, get datasource from proxy.");
            return proxyTarget.getData(dataSource);
        }
        if (!StringUtil.isEmptyString((String)dataSource.getReference())) {
            pk = MetaDataPKFactory.getMetaDataPK((String)dataSource.getReference());
            log.info((Object)("DefaultNoteDataProvider, datasource has BOSQuery reference. MetaDataPK: " + pk));
        } else {
            pk = this.getMetaDataPK(dsId);
            if (pk == null) {
                throw new R1PrintRuntimeException(MultiLanguageUtil.getMLS("client.DefaultNoteDataProvider.exception"));
            }
            log.info((Object)("DefaultNoteDataProvider, MetaDataPK is appointed: " + pk));
        }
        R1PrintDataParameter assParam = dataSource.getAssociateParameter();
        if (assParam == null) {
            log.info((Object)("DefaultNoteDataProvider, " + dsId + " without associate parameter."));
            IQueryExecutor exec = this.createExecutor(pk, dsId, dataSource.createWrappedBosRuntimeInfo(), dataSource.getParams(), assParam);
            rowSet = exec.executeQuery();
            if (this._isBatchSupported) {
                IRowSet another = rowSet.createCopy();
                this.getMapDs().put(dsId, another);
            }
        } else {
            log.info((Object)("DefaultNoteDataProvider, " + dsId + " with associate parameter. It's a sub-datasource."));
            if (this._isBatchSupported) {
                rowSet = this.pollCachedRowSet(dsId);
                if (rowSet == null) {
                    log.info((Object)"DefaultNoteDataProvider, batch query...");
                    this.batchExecute(pk, dsId, dataSource.createWrappedBosRuntimeInfo(), dataSource.getParams(), assParam);
                    rowSet = this.pollCachedRowSet(dsId);
                } else {
                    log.info((Object)"DefaultNoteDataProvider, get batch executed rowset from cache.");
                }
            } else {
                IQueryExecutor exec = this.createExecutor(pk, dsId, dataSource.createWrappedBosRuntimeInfo(), dataSource.getParams(), assParam);
                rowSet = exec.executeQuery();
            }
        }
        log.info((Object)("DefaultNoteDataProvider.getData return! Datasource is " + dsId));
        return rowSet;
    }

    private IQueryExecutor createExecutor(IMetaDataPK pk, String ds, EntityViewInfo runtimeExtInfo, R1PrintDataParameter[] params, R1PrintDataParameter assParam) {
        EntityViewInfo evi;
        IQueryExecutor exec = this.getCustomQueryExecutorFactory().getQueryExecutor(pk);
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = true;
        if (assParam != null) {
            evi = this.customizeEntityViewInfo(runtimeExtInfo, this.getCustomFilterMaker(ds), params);
            String foreignKeyField = this.searchForeignKeyField(pk, ds, assParam);
            Object value = assParam.getValue().getValue();
            this.addAssociatedFilter(evi.getFilter(), foreignKeyField, value);
        } else {
            evi = this.customizeEntityViewInfo(runtimeExtInfo, this.getCustomFilterMaker_ForMain(ds), params);
        }
        exec.setObjectView(evi);
        return exec;
    }

    private EntityViewInfo customizeEntityViewInfo(EntityViewInfo evi, ICustomFilterMaker customFilterMaker, R1PrintDataParameter[] params) {
        FilterInfo filter;
        if (evi == null) {
            evi = new EntityViewInfo();
        }
        if ((filter = evi.getFilter()) == null) {
            filter = new FilterInfo();
            evi.setFilter(filter);
        }
        if (customFilterMaker != null) {
            customFilterMaker.customize(filter, params);
        }
        return evi;
    }

    private String searchForeignKeyField(IMetaDataPK pk, String ds, R1PrintDataParameter assParam) {
        String field = this.getForeignKey(pk);
        if (field == null) {
            field = this.getForeignKey(ds);
            if (field == null) {
                field = assParam.getId();
                log.info((Object)("DefaultNoteDataProvider, foreignkey of sub-datasource is from template. It's " + field));
            } else {
                log.info((Object)("DefaultNoteDataProvider, foreignkey of sub-datasource is appointed. It's " + field));
            }
        }
        return field;
    }

    private void addAssociatedFilter(FilterInfo filter, String foreignKeyField, Object value) {
        log.info((Object)new StringBuffer("DefaultNoteDataProvider, sub-datasource filter: " + foreignKeyField + " = " + value));
        FilterInfo newFilter = new FilterInfo();
        newFilter.getFilterItems().add(new FilterItemInfo(foreignKeyField, value, CompareType.EQUALS));
        try {
            filter.mergeFilter(newFilter, "AND");
        }
        catch (BOSException ex) {
            log.error((Object)"DefaultNoteDataProvider, sub-datasource merge filter error.", (Throwable)ex);
        }
    }

    public void setBatchSupported(boolean isBatchSupported) {
        this._isBatchSupported = isBatchSupported;
    }

    public void setNumberOfEachBatch(int number) {
        this._numberOfEachBatch = number;
    }

    private void batchExecute(IMetaDataPK pk, String ds, EntityViewInfo runtimeExtInfo, R1PrintDataParameter[] params, R1PrintDataParameter assParam) throws BOSException, SQLException {
        String mainDs = assParam.getAssociateSource();
        String primaryKey = assParam.getAssociateField();
        IRowSet mainRowSet = this.getCachedRowSet(mainDs);
        log.info((Object)new StringBuffer("DefaultNoteDataProvider.batchExecute, main-datasource: " + mainDs + ", primarykey: " + primaryKey));
        String foreignKeyField = this.searchForeignKeyField(pk, ds, assParam);
        Integer cursor = (Integer)this.getMapCursors().get(ds);
        if (cursor == null) {
            mainRowSet.beforeFirst();
        } else {
            mainRowSet.absolute(cursor.intValue());
        }
        log.info((Object)"DefaultNoteDataProvider.batchExecute, create batch filters.");
        ArrayList<EntityViewInfo> arrEvis = new ArrayList<EntityViewInfo>();
        int count = 0;
        Object oldAssValue = null;
        while (count < this._numberOfEachBatch && mainRowSet.next()) {
            boolean valueEquals;
            Object associateValue = mainRowSet.getObject(primaryKey);
            boolean bl = valueEquals = oldAssValue == null && associateValue == null || oldAssValue != null && oldAssValue.equals(associateValue);
            if (valueEquals && mainRowSet.getRow() != 1) continue;
            oldAssValue = associateValue;
            EntityViewInfo runtimeExtInfo2 = (EntityViewInfo)runtimeExtInfo.clone();
            EntityViewInfo evi = this.customizeEntityViewInfo(runtimeExtInfo2, this.getCustomFilterMaker(ds), params);
            this.addAssociatedFilter(evi.getFilter(), foreignKeyField, associateValue);
            arrEvis.add(evi);
            ++count;
        }
        EntityViewInfo[] evis = arrEvis.toArray(new EntityViewInfo[0]);
        this.getMapCursors().put(ds, new Integer(mainRowSet.getRow()));
        log.info((Object)"DefaultNoteDataProvider.batchExecute, batch query executing...");
        IMultiQueryExecutor executor = this.getCustomQueryExecutorFactory().getMultiQueryExecutor();
        IRowSet[] rowSets = executor.excuteMultiQuery(pk, evis);
        log.info((Object)new StringBuffer("DefaultNoteDataProvider.batchExecute, batch query executed. Got " + count + " rowsets."));
        ArrayList<IRowSet> arrBatchResult = new ArrayList<IRowSet>();
        for (int i = 0; i < rowSets.length; ++i) {
            arrBatchResult.add(rowSets[i]);
        }
        this.getMapDs().put(ds, arrBatchResult);
    }

    private IRowSet pollCachedRowSet(String key) {
        return this.getCachedRowSet(key, true);
    }

    private IRowSet getCachedRowSet(String key) {
        return this.getCachedRowSet(key, false);
    }

    private IRowSet getCachedRowSet(String key, boolean remove) {
        Object objResult = this.getMapDs().get(key);
        if (objResult instanceof IRowSet) {
            return (IRowSet)objResult;
        }
        if (objResult instanceof ArrayList) {
            ArrayList arrResult = (ArrayList)objResult;
            if (arrResult.size() == 0) {
                return null;
            }
            if (remove) {
                return (IRowSet)arrResult.remove(0);
            }
            return (IRowSet)arrResult.get(0);
        }
        return null;
    }

    public Context getContext() {
        return this.ctx;
    }

    public void setContext(Context ctx) {
        this.ctx = ctx;
    }

    private class DefaultQueryExecutorFactory
    implements ICustomQueryExecutorFactory {
        private DefaultQueryExecutorFactory() {
        }

        @Override
        public IQueryExecutor getQueryExecutor(IMetaDataPK pk) {
            if (DefaultNoteDataProvider.this.ctx == null) {
                return QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
            }
            return QueryExecutorFactory.getLocalInstance((Context)DefaultNoteDataProvider.this.ctx, (IMetaDataPK)pk);
        }

        @Override
        public IMultiQueryExecutor getMultiQueryExecutor() throws BOSException {
            if (DefaultNoteDataProvider.this.ctx == null) {
                return MultiQueryExecutorFactory.getRemoteInstance();
            }
            return MultiQueryExecutorFactory.getLocalInstance((Context)DefaultNoteDataProvider.this.ctx);
        }
    }

    public static interface ICustomQueryExecutorFactory {
        public IQueryExecutor getQueryExecutor(IMetaDataPK var1);

        public IMultiQueryExecutor getMultiQueryExecutor() throws BOSException;
    }

    public static class DefaultIdFilterMaker
    implements ICustomFilterMaker {
        private Set dataIds = null;

        public DefaultIdFilterMaker(Set dataIds) {
            this.dataIds = dataIds;
        }

        @Override
        public void customize(FilterInfo filter, R1PrintDataParameter[] params) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.dataIds, CompareType.INCLUDE));
        }
    }

    public static interface ICustomFilterMaker {
        public void customize(FilterInfo var1, R1PrintDataParameter[] var2);
    }
}

