/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions;

import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.bizshare.ConnectException;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions.ActionExport;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.ui.OverwritePromptDialog;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.actions.AbstractStorageResActionHandler;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.CommonBizStorageTreeCtrl;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.importexport.ImportFromFileStepNoBower;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.importexport.ProgressBar;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.importexport.model.ICopyBetweenStorage;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.importexport.model.ImportExportModel;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.BosBizContext;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorageUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.StorageCategory;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyExistsException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UserCancelException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ActionImportFromStandard
extends AbstractStorageResActionHandler {
    private static final Logger log = LogUtil.getPackageLogger(ActionImportFromStandard.class);
    private String path;
    private boolean _overwriteYesAll = false;

    protected boolean onAction() throws Exception {
        WizardDialog wd = (WizardDialog)WindowUtil.createWindow(WizardDialog.class, (Component)this.getTreeUI());
        wd.setBigSize(true);
        wd.setModal(true);
        wd.setTitle(MultiLanguageUtil.getMLS("actions.ActionImportFromStandard.importObjectFromTemplate"));
        BosBizContext ctx = new BosBizContext();
        try {
            String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
            ctx.login(rpcUrl, null, null, null, LangUtil.makeDefaultLang());
        }
        catch (KDRSException ex) {
            throw new ConnectException((Throwable)ex);
        }
        this.path = this.getTreeUI().getSelectionPathText();
        if (StringUtil.equals((String)this.path, null)) {
            this.path = "/kdnote/template";
        }
        ImportExportModel context = new ImportExportModel();
        IBizStorage fromSto = ctx.getBizStorage();
        context.setFromStorage(fromSto);
        context.setFromPath("\\");
        ImportStep fromFileStep = new ImportStep((ICopyBetweenStorage)context);
        ArrayList<ImportStep> list = new ArrayList<ImportStep>();
        list.add(fromFileStep);
        wd.setStepsList(list);
        wd.show();
        if (this.getTreeUI().getSelectionNode() != null) {
            this.getBizStorageTreeCtrl().getTreeUI().refreshSelectionNode();
        }
        ctx.logout();
        return false;
    }

    public IBizContent getBizContent() {
        return (IBizContent)this.getBizStorage();
    }

    void copyWithUI(final IBizStorage fromSto, final IBizContent toCnt, final TreeUINode tnFrom, final String toPath) {
        final ProgressBar bar = (ProgressBar)WindowUtil.createWindow(ProgressBar.class, (Component)this.getTreeUI());
        bar.setTitle(MultiLanguageUtil.getMLS("actions.ActionImportFromStandard.importObjectFromTemplate"));
        new Thread(new Runnable(){

            @Override
            public void run() {
                CopyWithTree cwt = new CopyWithTree(fromSto, (IBizStorage)toCnt, new Creater(), bar);
                try {
                    String getFromPath = "/kdnote/template";
                    cwt.copy(getFromPath, toPath, tnFrom);
                }
                catch (KDRSException ex) {
                    log.error((Object)"\u5bfc\u5165\u5931\u8d25", (Throwable)ex);
                    WindowUtil.showException((String)MultiLanguageUtil.getMLS("actions.ActionImportFromStandard.importFailed"), (Throwable)ex, (String)MultiLanguageUtil.getMLS("actions.ActionImportFromStandard.importObjectFromTemplate"), (Component)ActionImportFromStandard.this.getTreeUI());
                }
                catch (UserCancelException userCancelException) {
                    // empty catch block
                }
                bar.finished();
            }
        }).start();
        bar.show();
    }

    private class Creater
    implements BizStorageUtil.IResourceCreator {
        private String templatePostfix = ".kdrs-form";
        private String metadataPostfix = ".bos-query";
        private String r1TemplatePostfix = ".r1-print";
        private String noteDynQueryPostfix = ".note-dynquery";

        private Creater() {
        }

        public HashMap create(IBizStorage fromSto, String fromPath, IBizStorage toSto1, String toPath) throws KDRSException {
            IBizContent toCnt = (IBizContent)toSto1;
            HashMap attrs = fromSto.getAttributes(fromPath, new String[]{"name", "type"});
            Object type = attrs.get("type");
            String name = (String)attrs.get("name");
            if (StringUtil.equals((String)StorageCategory.FOLDER.getName(), (String)type.toString())) {
                try {
                    attrs = this.getOriAttrs(fromSto, fromPath, ActionImportFromStandard.this._overwriteYesAll || fromPath == "/" ? 16 : 1);
                    attrs.put("category", "folder");
                    toCnt.create(toPath, attrs);
                }
                catch (AlreadyExistsException ex) {
                    switch (this.isOverwrite(toPath)) {
                        case 2: {
                            ActionImportFromStandard.this._overwriteYesAll = true;
                        }
                        case 1: {
                            break;
                        }
                        case 3: {
                            return null;
                        }
                        case 0: {
                            throw new UserCancelException();
                        }
                    }
                    this.putAttrPolicy(attrs, 16);
                    toCnt.create(toPath, attrs);
                }
            } else {
                attrs = null;
                if (name.endsWith(this.templatePostfix) || name.endsWith(this.r1TemplatePostfix)) {
                    HashMap att = this.getOriAttrs(fromSto, fromPath, ActionImportFromStandard.this._overwriteYesAll ? 16 : 1);
                    if (name.endsWith(this.templatePostfix)) {
                        att.put("category", "kdrs-form");
                    } else {
                        att.put("category", "r1-print");
                    }
                    att.remove("type");
                    try {
                        toCnt.create(toPath, att);
                    }
                    catch (AlreadyExistsException ex) {
                        switch (this.isOverwrite(toPath)) {
                            case 2: {
                                ActionImportFromStandard.this._overwriteYesAll = true;
                            }
                            case 1: {
                                break;
                            }
                            case 3: {
                                return null;
                            }
                            case 0: {
                                throw new UserCancelException();
                            }
                        }
                        this.putAttrPolicy(att, 16);
                        toCnt.create(toPath, att);
                    }
                    toCnt.writeTemplate(toPath, BizStorageUtil.readFile((IBizStorage)fromSto, (String)fromPath));
                } else if (name.endsWith(this.metadataPostfix) || name.endsWith(this.noteDynQueryPostfix)) {
                    HashMap att = this.getOriAttrs(fromSto, fromPath, ActionImportFromStandard.this._overwriteYesAll ? 16 : 1);
                    if (name.endsWith(this.noteDynQueryPostfix)) {
                        att.put("category", "note-dynquery");
                    } else {
                        att.put("category", "bos-query");
                    }
                    try {
                        toCnt.create(toPath, att);
                    }
                    catch (AlreadyExistsException ex) {
                        switch (this.isOverwrite(toPath)) {
                            case 2: {
                                ActionImportFromStandard.this._overwriteYesAll = true;
                            }
                            case 1: {
                                break;
                            }
                            case 3: {
                                return null;
                            }
                            case 0: {
                                throw new UserCancelException();
                            }
                        }
                        this.putAttrPolicy(att, 16);
                        toCnt.create(toPath, att);
                    }
                    toCnt.writeTemplate(toPath, BizStorageUtil.readFile((IBizStorage)fromSto, (String)fromPath));
                }
            }
            return attrs;
        }

        private HashMap getOriAttrs(IBizStorage sto, String pathText, int createPolicy) throws KDRSException {
            HashMap atts = sto.getAttributes(pathText, null);
            atts.remove("name");
            atts.remove("size");
            atts.remove("time");
            atts.remove("creator");
            atts.remove("last-access");
            atts.remove("last-modified");
            this.putAttrPolicy(atts, createPolicy);
            return atts;
        }

        private void putAttrPolicy(HashMap atts, int createPolicy) {
            atts.put("create_policy", new Integer(createPolicy));
        }

        private int isOverwrite(String pathText) {
            return OverwritePromptDialog.show((Component)ActionImportFromStandard.this.getTreeUI(), pathText + "  " + MultiLanguageUtil.getMLS("actions.ActionImportFromStandard.overWritePrompt"), MultiLanguageUtil.getMLS("actions.ActionImportFromStandard.overWriteTitle"));
        }
    }

    private class CopyWithTree {
        private IBizStorage fromStorage;
        private IBizStorage toStorage;
        private BizStorageUtil.IResourceCreator creator;
        private ProgressBar progressBar;

        public CopyWithTree(IBizStorage fromSto, IBizStorage toSto, BizStorageUtil.IResourceCreator creator, ProgressBar bar) {
            this.fromStorage = fromSto;
            this.toStorage = toSto;
            this.creator = creator;
            this.progressBar = bar;
            ActionImportFromStandard.this._overwriteYesAll = false;
        }

        public void copy(String fromPath, String toPath, TreeUINode tnFrom) throws KDRSException {
            if (this.progressBar != null) {
                this.progressBar.addLine(toPath);
            }
            if (!StringUtil.equals((String)toPath, (String)"/EAS_Node.kdrs")) {
                this.creator.create(this.fromStorage, fromPath, this.toStorage, toPath);
            }
            if (tnFrom.getAllowsChildren() && !tnFrom.isChildrenLoaded()) {
                ActionExport.copyFolder(this.fromStorage, fromPath, this.toStorage, toPath, this.creator, this.progressBar);
            } else if (!tnFrom.isLeaf()) {
                int j = tnFrom.getChildCount();
                for (int i = 0; i < j; ++i) {
                    TreeUINode tnChild = (TreeUINode)tnFrom.getChildAt(i);
                    if (tnChild.getCheckedValue() == 16) continue;
                    String childName = tnChild.getName();
                    String fromChild = PathUtil.makeChildPath((String)fromPath, (String)childName);
                    String toChild = PathUtil.makeChildPath((String)toPath, (String)childName);
                    this.copy(fromChild, toChild, tnChild);
                }
            }
        }
    }

    class ImportStep
    extends ImportFromFileStepNoBower {
        public ImportStep(ICopyBetweenStorage context) {
            super(context);
            this.pane = new NoteImportFromFilePane(context);
        }

        public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
            this.manager.setFinishEnabled(true);
            this.manager.setNextStepEnabled(false);
        }

        public IWizardStep outThisStep(boolean isOppose) {
            TreeUINode tnFrom = this.getFromTreeNode();
            if (!tnFrom.isChecked()) {
                WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("actions.ActionImportFromStandard.selectSource"), (String)MultiLanguageUtil.getMLS("actions.ActionImportFromStandard.importObject"), (Component)ActionImportFromStandard.this.getTreeUI());
                return this;
            }
            ActionImportFromStandard.this.copyWithUI(this.getPaneModel().getFromStorage(), ActionImportFromStandard.this.getBizContent(), tnFrom, "/EAS_Note.kdrs");
            return null;
        }

        class NoteImportTreeCtrl
        extends CommonBizStorageTreeCtrl {
            private String templatePostfix;
            private String metadataPostfix;
            private String r1TemplatePostfix;
            private String noteDynQueryPostfix;

            public NoteImportTreeCtrl(IBizStorage bizSto) {
                super(bizSto);
                this.templatePostfix = ".kdrs-form";
                this.metadataPostfix = ".bos-query";
                this.r1TemplatePostfix = ".r1-print";
                this.noteDynQueryPostfix = ".note-dynquery";
            }

            protected void initFolderNode(String pathText, TreeUINode node) throws KDRSException {
                HashMap rv = this.getBizStorage().list(pathText, LIST_ATTRS);
                String[] names = (String[])rv.get("name");
                String[] alias = (String[])rv.get("alias");
                String[] types = (String[])rv.get("type");
                for (int i = 0; i < names.length; ++i) {
                    StorageCategory category;
                    StorageCategory storageCategory = category = "Folder".equals(types[i]) ? StorageCategory.FOLDER : StorageCategory.FILE;
                    if (category == StorageCategory.FILE && !names[i].endsWith(this.templatePostfix) && !names[i].endsWith(this.r1TemplatePostfix) && !names[i].endsWith(this.metadataPostfix) && !names[i].endsWith(this.noteDynQueryPostfix)) continue;
                    TreeUINode tcnSub = NoteImportTreeCtrl.newTreeNode((Object)category, (String)names[i], (String)alias[i]);
                    this.getTreeUI().addChildNode(tcnSub, node);
                }
            }
        }

        class NoteImportFromFilePane
        extends ImportFromFileStepNoBower.ImportFromFilePaneNoBrower {
            public NoteImportFromFilePane(ICopyBetweenStorage context) {
                super(context);
            }

            protected CommonBizStorageTreeCtrl createBizStorageTreeCtrl(ICopyBetweenStorage model) {
                NoteImportTreeCtrl ctrl = new NoteImportTreeCtrl(this.getModel().getFromStorage());
                ctrl.setRootPath("/kdnote/template");
                ctrl.getTreeUI().setCheckboxMode(true);
                ctrl.getTreeUI().setRealtimeSelect(true);
                ctrl.getTreeUI().getRootNode().setAlias(this.getModel().getFromPath());
                ctrl.getTreeUI().expandRoot();
                ctrl.getTreeUI().setSelectionPathText(ActionImportFromStandard.this.path);
                ctrl.getTreeUI().setCheckedPathText(ActionImportFromStandard.this.path, true);
                return ctrl;
            }
        }
    }
}

