/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.adaptor;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataParameter;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSortItem;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class KdfToR1DataAdaptor
extends AbstractPrintDataProvider {
    public static final Logger log = LogUtil.getPackageLogger(KdfToR1DataAdaptor.class);
    private BOSQueryDelegate _kdfDataProvider;

    public KdfToR1DataAdaptor(BOSQueryDelegate kdfDataProvider) {
        this._kdfDataProvider = kdfDataProvider;
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        if (this._kdfDataProvider instanceof AbstractPrintDataProvider) {
            return ((AbstractPrintDataProvider)this._kdfDataProvider).getData(dataSource);
        }
        return this._kdfDataProvider.execute(KdfToR1DataAdaptor.changeDs(dataSource));
    }

    public static BOSQueryDataSource changeDs(R1PrintDataSource r1Ds) {
        BOSQueryDataSource kdfDs = new BOSQueryDataSource();
        kdfDs.setID(r1Ds.getId());
        R1PrintDataSortItem[] sortFields = r1Ds.getSortFields();
        List<R1PrintDataSortItem> list = Arrays.asList(sortFields);
        kdfDs.setSortFields(list);
        R1PrintDataParameter[] r1Params = r1Ds.getParams();
        for (int i = 0; i < r1Params.length; ++i) {
            R1PrintDataParameter r1Param = r1Params[i];
            DSParam kdfParam = new DSParam(r1Param.getId(), r1Param.getAssociateSource(), r1Param.getAssociateField());
            if (r1Param.getValue() != null) {
                kdfParam.setValue(new Variant(r1Param.getValue().getValue()));
                if (StringUtil.isEmptyString((String)r1Param.getAssociateSource())) {
                    kdfParam.setAssociateField(r1Param.getValue().toString());
                    log.info((Object)("KdfToR1\u8f6c\u53c2\u6570:" + kdfParam.getColName() + "" + kdfParam.getValue()));
                }
            } else {
                kdfParam.setValue(Variant.getNewEmptyVariant());
            }
            kdfDs.addParam(kdfParam);
        }
        return kdfDs;
    }
}

