/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.offline;

import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class NoteExtendAttributes {
    private static final Logger log = LogUtil.getLogger(NoteExtendAttributes.class);
    private HashMap _dotMetaNodes = new HashMap();

    public NoteExtendAttributes(File directory) {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("It must be an existent directory.");
        }
        try {
            this.load(directory);
        }
        catch (IOException e) {
            log.error((Object)("Load .meta error. " + directory.getPath()), (Throwable)e);
            return;
        }
        catch (JDOMException e) {
            log.error((Object)("Load .meta error. " + directory.getPath()), (Throwable)e);
            return;
        }
    }

    private void load(File directory) throws IOException, JDOMException {
        File[] dotMetas = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals(".meta");
            }
        });
        if (dotMetas == null || dotMetas.length != 1) {
            log.error((Object)("No .meta file. " + directory.getPath()));
            return;
        }
        Element dotMetaRoot = XmlUtil.loadXmlFile((File)dotMetas[0]);
        for (Element node : dotMetaRoot.getChild("Nodes").getChildren()) {
            this._dotMetaNodes.put(node.getAttributeValue("name"), node);
        }
    }

    public String getAlias(String fileName) {
        Element node = (Element)this._dotMetaNodes.get(fileName);
        return LangUtil.getAttrValue((Element)node, (String)"alias");
    }
}

