/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.ui;

import com.kingdee.bos.ctrl.common.ResourceManager;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.restree.ResObjectNode;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUI;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteTreeCtrl;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.multilanguage.Language;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteUseUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.BizRpcReducer;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IBizContext;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IContextSupplier;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.eas.common.client.SysContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class NoteFileDialog
extends TypicalDialog
implements TreeSelectionListener,
TreeExpansionListener,
ListSelectionListener {
    private static Logger log = LogUtil.getPackageLogger(NoteFileDialog.class);
    public static final HashMap List_Attrs = new HashMap();
    private static NoteTreeCtrl _tree;
    private KDList _lstFile;
    private NoteTemplatesPanel _rightPanel;
    private BizRpcReducer _rpcReducer;
    private KDCheckBox _chkSaveAsDefault;
    private boolean _isShowSaveAsDefault = false;
    private boolean _isShowFileName = false;

    public NoteFileDialog() {
        this.initControls();
    }

    public NoteFileDialog(Frame owner) {
        super(owner);
        this.initControls();
    }

    public NoteFileDialog(Dialog owner) {
        super(owner);
        this.initControls();
    }

    public NoteFileDialog(Frame owner, BizRpcReducer rpcReducer) {
        super(owner);
        this._rpcReducer = rpcReducer;
        this.initControls();
    }

    public NoteFileDialog(Dialog owner, BizRpcReducer rpcReducer) {
        super(owner);
        this._rpcReducer = rpcReducer;
        this.initControls();
    }

    public NoteFileDialog(BizRpcReducer rpcReducer) {
        this._rpcReducer = rpcReducer;
        this.initControls();
    }

    public static NoteFileDialog create(Component owner, BizRpcReducer rpcReducer) {
        Window win = owner instanceof Window ? (Window)owner : SwingUtilities.getWindowAncestor(owner);
        NoteFileDialog inst = win instanceof Frame ? new NoteFileDialog((Frame)win, rpcReducer) : (win instanceof Dialog ? new NoteFileDialog((Dialog)win, rpcReducer) : new NoteFileDialog(rpcReducer));
        return inst;
    }

    public void setNoteType(String noteType) {
        _tree.setPathTextToShow(noteType);
    }

    protected IBizContext getBizContext() {
        return KDNoteHelper.getContext();
    }

    protected void todoInit() {
        this.setTitle(MultiLanguageUtil.getMLS("ui.NoteFileDialog.selectTemplate"));
        this.setSize(770, 480);
        this.btnOk.setEnabled(false);
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        Table tb = thisCell.split(2, 1);
        KDSplitPane sep = new KDSplitPane(1);
        sep.setLeftComponent((Component)_tree.getTreeUI());
        sep.setRightComponent((Component)((Object)this._rightPanel));
        sep.setDividerLocation(220);
        parent.add((Component)sep, tb.cell(0));
        if (this._isShowSaveAsDefault) {
            this._chkSaveAsDefault = new KDCheckBox(MultiLanguageUtil.getMLS("ui.NoteFileDialog.saveAsDefault"));
            parent.add((Component)this._chkSaveAsDefault, tb.cell(1));
        }
    }

    private void initControls() {
        this._rightPanel = new NoteTemplatesPanel();
        this._lstFile = this._rightPanel.lstTemplates;
        this._lstFile.setCellRenderer((ListCellRenderer)new CustomListCellRender());
        this._lstFile.addListSelectionListener((ListSelectionListener)this);
        IContextSupplier supplier = new IContextSupplier(){

            public IBizContext getContext() {
                return NoteFileDialog.this.getBizContext();
            }
        };
        try {
            _tree = new NoteTreeCtrl(supplier, null, false);
        }
        catch (KDRSException ex) {
            LogUtil.showException((Logger)log, (Exception)((Object)ex));
            WindowUtil.msgboxError((Object)ex.toString(), (String)"Error", (Component)((Object)this));
        }
        _tree.setRelativeRoot("/EAS_Note.kdrs");
        _tree.getTreeUI().addTreeSelectionListener((TreeSelectionListener)this);
        TreeExpansionListener[] tels = _tree.getTreeUI().getTree().getTreeExpansionListeners();
        for (int i = 0; i < tels.length; ++i) {
            if (!(tels[i] instanceof TreeUI.EventLisnter)) continue;
            _tree.getTreeUI().getTree().removeTreeExpansionListener(tels[i]);
        }
        _tree.getTreeUI().getTree().addTreeExpansionListener((TreeExpansionListener)this);
        _tree.setShowLeaf(false);
        _tree.getTreeUI().setRealtimeSelect(false);
        _tree.getTreeUI().getTree().setShowsRootHandles(true);
        this._lstFile.setSelectionMode(0);
        this._lstFile.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                int idx = NoteFileDialog.this._lstFile.locationToIndex(e.getPoint());
                if (idx >= 0) {
                    NoteFileDialog.this.onOk();
                }
            }
        });
        this._rightPanel.cbUseOrgFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NoteFileDialog.this.refreshTemplateList();
            }
        });
        this._rightPanel.multiLanguage.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NoteFileDialog.this._rightPanel.lang = (Language)NoteFileDialog.this._rightPanel.multiLanguage.getSelectedItem();
                NoteFileDialog.this.refreshTemplateList();
            }
        });
    }

    public void setNoteName(String noteName) {
        int idx = 0;
        int c = this._lstFile.getElementCount() - 1;
        for (int i = 0; i < c; ++i) {
            ListElement le = (ListElement)this._lstFile.getElement(i);
            if (!StringUtil.equalsIgnoreCase((String)le.getName(), (String)noteName)) continue;
            idx = i;
        }
        this._lstFile.setSelectedIndex(idx);
        this.btnOk.setEnabled(idx != -1);
    }

    public String getNoteName() {
        ListElement le = (ListElement)this._lstFile.getSelectedValue();
        if (le != null) {
            return le.getName();
        }
        return null;
    }

    public String getNoteAlias() {
        ListElement le = (ListElement)this._lstFile.getSelectedValue();
        if (le != null) {
            return le.getAlias();
        }
        return null;
    }

    public String getNoteDir() {
        return PathUtil.makeChildPath((String)_tree.getRelativeRoot(), (String)_tree.getTreeUI().getSelectionPathText());
    }

    public String getNotePathText() {
        return PathUtil.makeChildPath((String)this.getNoteDir(), (String)this.getNoteName());
    }

    public String getNoteType() {
        return _tree.getTreeUI().getSelectionPathText();
    }

    public String getRelativeNotePathText() {
        return PathUtil.makeChildPath((String)this.getNoteType(), (String)this.getNoteName());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.btnOk.setEnabled(this._lstFile.getSelectedIndex() != -1);
    }

    private void refreshTemplateList() {
        TreeUINode selectedNode = _tree.getTreeUI().getSelectionNode();
        HashMap cacheValues = (HashMap)selectedNode.getUserObject();
        this.btnOk.setEnabled(false);
        this._lstFile.removeAllElements();
        HashMap vals = null;
        if (cacheValues == null) {
            if (selectedNode.isChildrenLoaded()) {
                return;
            }
            vals = this.expandNode(selectedNode, this.getNoteDir());
        } else {
            vals = cacheValues;
        }
        if (vals == null) {
            return;
        }
        String[] names = (String[])vals.get("name");
        String[] alias = (String[])vals.get("alias");
        String[] categories = (String[])vals.get("category");
        String[] orgss = (String[])vals.get("eas_template_relation_orgs");
        if (names != null && log.isDebugEnabled()) {
            log.debug((Object)("entries:" + names.length));
        }
        boolean doFilter = this._rightPanel.cbUseOrgFilter.isSelected();
        this.writeToProperties(doFilter);
        int idxKDFStart = 0;
        IBizContent bizCtn = _tree.getBizContent();
        for (int i = 0; i < names.length; ++i) {
            int j;
            boolean isR1;
            boolean isKDF;
            block16: {
                isKDF = "kdrs-form".equals(categories[i]);
                isR1 = "r1-print".equals(categories[i]);
                if (!isKDF && !isR1 || !this._rightPanel.lang.equal(Language.readTempLang(names[i])) && !isKDF) continue;
                try {
                    boolean isCanUse = NoteUseUtil.isCanUse(bizCtn, ((ResObjectNode)selectedNode).getResPath() + "/" + names[i]);
                    if (!isCanUse) {
                    }
                    break block16;
                }
                catch (KDRSException ex) {
                    log.debug((Object)(selectedNode + "\u83b7\u53d6\u5c5e\u6027\uff1aNoteUseUtil." + "user_enabled_users" + "Failed"));
                }
                continue;
            }
            if (doFilter && (orgss[i] == null || orgss[i].length() == 0 || orgss[i].indexOf(NoteUtil.getCurrentOrgUnitId()) == -1)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("ignore teplate/r1templat:" + names[i]));
                continue;
            }
            ListElement element = new ListElement(names[i], alias[i], categories[i]);
            int idx = idxKDFStart;
            if (isR1) {
                for (j = 0; j < idxKDFStart; ++j) {
                    if (element.compareTo(this._lstFile.getElement(j)) >= 0) continue;
                    idx = j;
                    break;
                }
                ++idxKDFStart;
            } else if (isKDF) {
                for (j = this._lstFile.getElementCount() - 1; j >= idxKDFStart; --j) {
                    if (element.compareTo(this._lstFile.getElement(j)) <= 0) continue;
                    idx = j + 1;
                    break;
                }
            }
            this._lstFile.insertElement((Object)element, idx);
        }
        if (this._lstFile.getElementCount() > 0) {
            this._lstFile.setSelectedIndex(0);
        }
        this.btnOk.setEnabled(this._lstFile.getSelectedIndex() != -1);
    }

    private void writeToProperties(boolean doFilter) {
        String easclientRoot = System.getProperty("user.dir");
        String fileName = "/deploy/client/ctrl_note.properties";
        File f = new File(easclientRoot + fileName);
        Properties pro = new Properties();
        FileOutputStream out = null;
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
            out = new FileOutputStream(f);
            pro.setProperty("isOrgFilterSelected", String.valueOf(doFilter));
            pro.store(out, new Date().toString());
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.refreshTemplateList();
    }

    public void setShowSaveAsDefault(boolean b) {
        this._isShowSaveAsDefault = b;
    }

    public boolean isSaveAsDefault() {
        return this._chkSaveAsDefault != null && this._chkSaveAsDefault.isSelected();
    }

    public boolean isShowFileName() {
        return this._isShowFileName;
    }

    public void setShowFileName(boolean isShowFileName) {
        this._isShowFileName = isShowFileName;
    }

    public final boolean isUseTemplateOrgFilter() {
        return this._rightPanel.cbUseOrgFilter.isSelected();
    }

    public final void setUseTemplateOrgFilter(boolean useTemplateOrgFilter) {
        this._rightPanel.cbUseOrgFilter.setSelected(useTemplateOrgFilter);
        _tree.setUseTemplateOrgFilter(useTemplateOrgFilter);
    }

    public void setUseTemplateOrgFilterEnabled(boolean enabled) {
        this._rightPanel.cbUseOrgFilter.setEnabled(enabled);
    }

    public boolean showDialog() {
        if (!this.isAddControls) {
            HashMap[] multiResult;
            block13: {
                String absPath = PathUtil.makeChildPath((String)"/EAS_Note.kdrs", (String)_tree.getPathTextToShow());
                multiResult = null;
                List_Attrs.put("FCOMPANYNUMBER", SysContext.getSysContext().getCurrentCtrlUnit().getNumber());
                if (this._rpcReducer != null) {
                    try {
                        multiResult = (HashMap[])this._rpcReducer.getBatchResult("IBizContent.list2", new Object[]{absPath, List_Attrs});
                    }
                    catch (NotFoundException e) {
                        WindowUtil.msgboxError((Object)(MultiLanguageUtil.getMLS("ui.NoteFileDialog.pathError1") + " " + _tree.getPathTextToShow() + " " + MultiLanguageUtil.getMLS("ui.NoteFileDialog.pathError")), (String)MultiLanguageUtil.getMLS("ui.NoteFileDialog.pathErrorTitle"), (Component)((Object)this));
                        return false;
                    }
                    catch (KDRSException e) {
                        log.error((Object)"GetBatchResult list2 error.", (Throwable)e);
                    }
                } else {
                    try {
                        multiResult = this.getBizContext().getBizContent().list2(absPath, List_Attrs);
                    }
                    catch (NotFoundException e) {
                        WindowUtil.msgboxError((Object)(MultiLanguageUtil.getMLS("ui.NoteFileDialog.pathError1") + _tree.getPathTextToShow() + " " + MultiLanguageUtil.getMLS("ui.NoteFileDialog.pathError")), (String)MultiLanguageUtil.getMLS("ui.NoteFileDialog.pathErrorTitle"), (Component)((Object)this));
                        return false;
                    }
                    catch (KDRSException e) {
                        log.error((Object)"", (Throwable)e);
                        if (!(e instanceof NotFoundException)) break block13;
                        WindowUtil.msgboxError((Object)(MultiLanguageUtil.getMLS("ui.NoteFileDialog.pathError1") + _tree.getPathTextToShow() + " " + MultiLanguageUtil.getMLS("ui.NoteFileDialog.pathError")), (String)MultiLanguageUtil.getMLS("ui.NoteFileDialog.pathErrorTitle"), (Component)((Object)this));
                        return false;
                    }
                }
            }
            TreeUINode node = _tree.getTreeUI().getRootNode();
            node.setChildrenLoaded(true);
            if (multiResult != null) {
                int relaRootDeep;
                for (int i = relaRootDeep = PathUtil.splitPath((String)"/EAS_Note.kdrs").length - 1; i < multiResult.length - 1; ++i) {
                    TreeUINode childNode;
                    String name = (String)multiResult[i].get("name");
                    String alias = (String)multiResult[i].get("alias");
                    try {
                        childNode = _tree.newTreeNode("folder", name, alias);
                    }
                    catch (Exception e) {
                        log.error((Object)"", (Throwable)e);
                        break;
                    }
                    _tree.getTreeUI().addChildNode(childNode, node);
                    childNode.setChildrenLoaded(true);
                    node = childNode;
                }
                node.setUserObject((Object)multiResult[multiResult.length - 1]);
                this.createUnloadedChildNode(node, multiResult[multiResult.length - 1]);
                _tree.getTreeUI().setSelectionNode(node);
                _tree.getTreeUI().expand(_tree.getTreeUI().getSelectionPath());
            }
        }
        return super.showDialog();
    }

    private void createUnloadedChildNode(TreeUINode targetNode, HashMap vals) {
        String[] names = (String[])vals.get("name");
        String[] alias = (String[])vals.get("alias");
        String[] categories = (String[])vals.get("category");
        for (int i = 0; i < names.length; ++i) {
            if (!"folder".equals(categories[i])) continue;
            TreeUINode childNode = null;
            try {
                childNode = _tree.newTreeNode("folder", names[i], alias[i]);
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
            if (childNode == null) continue;
            _tree.getTreeUI().addChildNode(childNode, targetNode);
        }
    }

    private HashMap expandNode(TreeUINode targetNode, String absPathText) {
        HashMap vals = null;
        try {
            vals = this.getBizContext().getBizContent().list(absPathText, List_Attrs);
        }
        catch (KDRSException e1) {
            log.error((Object)"\u53d6\u6587\u4ef6\u5939\u5185\u5bb9\u5217\u8868\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e1);
        }
        if (vals != null) {
            targetNode.setUserObject((Object)vals);
            targetNode.setChildrenLoaded(true);
            this.createUnloadedChildNode(targetNode, vals);
        }
        return vals;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        TreeUINode targetNode;
        TreePath treePath = event.getPath();
        if (treePath != null && !(targetNode = (TreeUINode)treePath.getLastPathComponent()).isChildrenLoaded()) {
            String targetPathText = TreeUtil.makePathText((TreePath)treePath);
            String absPathText = PathUtil.makeChildPath((String)_tree.getRelativeRoot(), (String)targetPathText);
            this.expandNode(targetNode, absPathText);
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    static {
        List_Attrs.put("name", null);
        List_Attrs.put("alias", null);
        List_Attrs.put("category", null);
        List_Attrs.put("eas_template_relation_orgs", null);
        List_Attrs.put("FCOMPANYNUMBER", SysContext.getSysContext().getCurrentCtrlUnit().getNumber());
    }

    private class ListElement {
        private String name;
        private String alias;
        private String category;

        public ListElement(String name, String alias, String category) {
            this.name = name;
            this.alias = alias;
            this.category = category;
        }

        public String getName() {
            return this.name;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getCategory() {
            return this.category;
        }

        public String toString() {
            if (StringUtil.isEmptyString((String)this.alias)) {
                return this.name;
            }
            if (NoteFileDialog.this.isShowFileName()) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.alias);
                sb.append("(");
                sb.append(this.name);
                sb.append(")");
                return sb.toString();
            }
            return this.alias;
        }

        public int compareTo(Object another) {
            return this.toString().compareTo(another.toString());
        }
    }

    class CustomListCellRender
    implements ListCellRenderer {
        ListCellRenderer render = new DefaultListCellRenderer();

        CustomListCellRender() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent c = (JComponent)this.render.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            c.setBorder(null);
            KDLabel lab = new KDLabel();
            ListElement le = (ListElement)value;
            if ("r1-print".equals(le.getCategory())) {
                lab.setIcon((Icon)ResourceManager.getIcon(NoteFileDialog.class, (String)"res/r1_print.gif"));
            } else if ("kdrs-form".equals(le.getCategory())) {
                lab.setIcon((Icon)ResourceManager.getIcon(NoteFileDialog.class, (String)"res/report_form.gif"));
            }
            lab.setOpaque(true);
            lab.setBackground(c.getBackground());
            TableLayout tl = TableLayout.splitCol((int)2);
            tl.colStyle(0).setWidth(22);
            tl.colStyle(1).setPriX(1);
            KDPanel pan = new KDPanel((LayoutManager)tl);
            pan.add((Component)lab, (Object)tl.cell(0));
            pan.add((Component)c, (Object)tl.cell(1));
            return pan;
        }
    }

    private static class NoteTemplatesPanel
    extends KDPanel {
        private KDList lstTemplates;
        private KDCheckBox cbUseOrgFilter;
        private KDComboBox multiLanguage = new KDComboBox((Object[])Language.SUPPORT_LANGUAGES);
        private Language lang = Language.locale2Language(Locale.getDefault());

        NoteTemplatesPanel() {
            this.lstTemplates = new KDList();
            this.cbUseOrgFilter = new KDCheckBox(MultiLanguageUtil.getMLS("ui.NoteFileDialog.useOrgFilter"));
            TableLayout2 layout = new TableLayout2(2, 2);
            layout.setFixedHeight(0, 20);
            layout.setRatableHeight(1, 1);
            layout.setRatableWidth(0, 1);
            layout.setRatableWidth(1, 1);
            layout.setRowsSpacing(TableLayout2.ALL, 3);
            this.setLayout((LayoutManager)layout);
            this.add((Component)this.cbUseOrgFilter, TableLayout2.param((int)0, (int)0));
            this.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.multiLanguage, (String)MultiLanguageUtil.getMLS("ui.NoteFileDialog.temLanguage"), (int)120), TableLayout2.param((int)0, (int)1));
            this.multiLanguage.setSelectedItem((Object)this.lang);
            this.add((Component)new KDScrollPane((Component)this.lstTemplates), TableLayout2.param((int)1, (int)0, (int)1, (int)1));
        }

        public Language getSelecteLanguage() {
            return this.lang;
        }
    }
}

