/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.util;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteTreeCtrl;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UserCancelException;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class NoteDistributionUtil {
    public static final String ATTR_WriteEnabledUsers = "write_enabled_users";
    public static final String READ_ONLY = "readOnly";

    private static HashMap getMapAttr(IBizContent bizCtn, String absPathText) throws KDRSException {
        HashMap attrs = bizCtn.getAttributes(absPathText, new String[]{ATTR_WriteEnabledUsers});
        return attrs;
    }

    private static String getStringAttr(HashMap attrs) {
        String strUsers = (String)attrs.get(ATTR_WriteEnabledUsers);
        return strUsers;
    }

    public static String getStringAttr(IBizContent bizCtn, String absPathText) throws KDRSException {
        HashMap attrs = NoteDistributionUtil.getMapAttr(bizCtn, absPathText);
        return NoteDistributionUtil.getStringAttr(attrs);
    }

    public static void setDistributed(NoteTreeCtrl noteTreeCtrl, String absPathText) throws KDRSException {
        NoteDistributionUtil.modifyAttr(noteTreeCtrl, absPathText, NoteUtil.getUser(), true);
    }

    public static void removeDistributed(NoteTreeCtrl noteTreeCtrl, String absPathText, String targetUser) throws KDRSException {
        NoteDistributionUtil.modifyAttr(noteTreeCtrl, absPathText, targetUser, false);
    }

    public static void removeAllDistributed(NoteTreeCtrl noteTreeCtrl, String absPathText) throws KDRSException {
        IBizContent bizCtn = noteTreeCtrl.getBizContent();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put(ATTR_WriteEnabledUsers, null);
        bizCtn.setAttributes(absPathText, attrs);
    }

    private static void modifyAttr(NoteTreeCtrl noteTreeCtrl, String absPathText, String targetUser, boolean isToAdd) throws KDRSException {
        NoteDistributionUtil.modifyAttr(noteTreeCtrl, absPathText, new String[]{targetUser}, isToAdd);
    }

    public static void modifyAttr(NoteTreeCtrl noteTreeCtrl, String absPathText, String[] targetUsers, boolean isToAdd) throws KDRSException {
        IBizContent bizCtn = noteTreeCtrl.getBizContent();
        HashMap attrs = NoteDistributionUtil.getMapAttr(bizCtn, absPathText);
        String strUsers = NoteDistributionUtil.getStringAttr(attrs);
        HashSet<String> sets = new HashSet<String>();
        if (!CtrlUtil.Str.isEmptyString((String)strUsers)) {
            String[] users = CtrlUtil.Str.splitString((String)strUsers, (String)",");
            for (int i = 0; i < users.length; ++i) {
                sets.add(users[i]);
            }
        }
        for (int i = 0; i < targetUsers.length; ++i) {
            if (isToAdd) {
                sets.add(targetUsers[i]);
                continue;
            }
            sets.remove(targetUsers[i]);
        }
        Object[] users = new String[sets.size()];
        sets.toArray(users);
        strUsers = CtrlUtil.Array.objectArray2String((Object[])users, (String)",");
        attrs.put(ATTR_WriteEnabledUsers, strUsers);
        bizCtn.setAttributes(absPathText, attrs);
    }

    public static Set usersStr2Set(String strUsers) {
        HashSet<String> sets = new HashSet<String>();
        if (!CtrlUtil.Str.isEmptyString((String)strUsers)) {
            String[] users = CtrlUtil.Str.splitString((String)strUsers, (String)",");
            for (int i = 0; i < users.length; ++i) {
                sets.add(users[i]);
            }
        }
        return sets;
    }

    public static boolean isDistributed(HashMap attrs) {
        String currentUser = NoteUtil.getUser();
        String users = (String)attrs.get(ATTR_WriteEnabledUsers);
        Set usersSet = NoteDistributionUtil.usersStr2Set(users);
        return usersSet.contains(currentUser);
    }

    public static boolean isDistributed(IBizContent bizCtn, String absPathText) throws KDRSException {
        HashMap attrs = NoteDistributionUtil.getMapAttr(bizCtn, absPathText);
        return NoteDistributionUtil.isDistributed(attrs);
    }

    public static boolean isReadOnly(IBizContent bizCtn, String absPathText, Component parentCtrl) throws KDRSException {
        if (!NoteDistributionUtil.isDistributed(bizCtn, absPathText)) {
            if (NoteDistributionUtil.innerPromptReadOnly(parentCtrl, MultiLanguageUtil.getMLS("util.NoteDistributionUtil.editor"), true)) {
                return true;
            }
            throw new UserCancelException("Read only. Not continue.");
        }
        return false;
    }

    public static void promptReadOnly(Component parentCtrl, String title) {
        NoteDistributionUtil.innerPromptReadOnly(parentCtrl, title, false);
    }

    private static boolean innerPromptReadOnly(Component parentCtrl, String title, boolean ask) {
        StringBuffer sb = new StringBuffer(MultiLanguageUtil.getMLS("util.NoteDistributionUtil.warning1"));
        if (ask) {
            sb.append(MultiLanguageUtil.getMLS("util.NoteDistributionUtil.yesNo"));
            return WindowUtil.msgboxYesNo((Component)parentCtrl, (Object)sb.toString(), (String)title);
        }
        WindowUtil.msgboxWarning((Object)sb.toString(), (String)title, (Component)parentCtrl);
        return true;
    }

    public static void promptCantdo(Component parentCtrl, String title, String actionName, String targetPath) {
        StringBuffer sb = new StringBuffer();
        sb.append(MultiLanguageUtil.getMLS("util.NoteDistributionUtil.warning2"));
        sb.append(actionName);
        sb.append("\u3002");
        sb.append(StringUtil.RETURN);
        sb.append(targetPath);
        WindowUtil.msgboxWarning((Object)sb.toString(), (String)title, (Component)parentCtrl);
    }
}

