/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.util;

import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteUserConfig;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorageUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.fs.FSStorage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class UpgradeDefaultTemplate {
    public static void upgrade(IBizStorage localSto, String filePath) throws KDRSException {
        byte[] bs;
        File localPath = GlobalLocator.getInstance().locateResourceFolder("/client/storage/eas/kdnote/template");
        FSStorage fss = new FSStorage(localPath.getAbsolutePath(), true);
        BizStorage oriLocalSto = new BizStorage((IStorage)fss);
        HashMap<String, Object> listAttrs = new HashMap<String, Object>();
        listAttrs.put("name", null);
        listAttrs.put("type", null);
        listAttrs.put("default", null);
        Element rootNode = new Element("UpdrageDefaultTemplate");
        Element nodeDefos = new Element("DefaultTemplates");
        Element nodeUsers = new Element("UserUpgraded");
        rootNode.addContent((Content)nodeDefos);
        rootNode.addContent((Content)nodeUsers);
        UpgradeDefaultTemplate.iterateSto((IBizStorage)oriLocalSto, listAttrs, "/", nodeDefos);
        try {
            bs = XmlUtil.saveXmlBytes((Element)rootNode);
        }
        catch (IOException ex) {
            throw KDRSException.makeException((String)(filePath + " Save UpdrageDefaultTemplate I/O Error."), (Throwable)ex);
        }
        try {
            localSto.writeFile(filePath, -1, bs);
        }
        catch (KDRSException ex) {
            localSto.delete(filePath);
            throw ex;
        }
    }

    private static void iterateSto(IBizStorage oriLocalSto, HashMap listAttrs, String pathText, Element parentNode) throws KDRSException {
        HashMap rv = oriLocalSto.list(pathText, listAttrs);
        String[] names = (String[])rv.get("name");
        String[] types = (String[])rv.get("type");
        String[] defaults = (String[])rv.get("default");
        for (int i = 0; i < names.length; ++i) {
            String childPathText;
            String name = names[i];
            String defo = defaults[i];
            if (!StringUtil.isEmptyString((String)defo)) {
                childPathText = PathUtil.makeChildPath((String)pathText, (String)name);
                Element node = new Element("Item");
                node.setAttribute("path", childPathText);
                node.addContent(defo);
                parentNode.addContent((Content)node);
            }
            if (!"Folder".equals(types[i])) continue;
            childPathText = PathUtil.makeChildPath((String)pathText, (String)name);
            UpgradeDefaultTemplate.iterateSto(oriLocalSto, listAttrs, childPathText, parentNode);
        }
    }

    public static boolean upgradeUser(IBizStorage localSto, String filePath, String user) throws KDRSException {
        byte[] bs = BizStorageUtil.readFile((IBizStorage)localSto, (String)filePath);
        Element root = null;
        try {
            root = XmlUtil.loadXmlBytes((byte[])bs);
        }
        catch (IOException ex1) {
            throw KDRSException.makeException((String)(filePath + " Load UpdrageDefaultTemplate I/O Error."), (Throwable)ex1);
        }
        catch (JDOMException ex2) {
            throw KDRSException.makeException((String)(filePath + " Load UpdrageDefaultTemplate Error."), (Throwable)ex2);
        }
        Element usersNode = root.getChild("UserUpgraded");
        for (Element userNode : usersNode.getChildren()) {
            if (!StringUtil.equals((String)user, (String)userNode.getText())) continue;
            return false;
        }
        Element nodeDefos = root.getChild("DefaultTemplates");
        for (Element itemNode : nodeDefos.getChildren("Item")) {
            String path = itemNode.getAttributeValue("path");
            String defo = itemNode.getText();
            if (defo.endsWith(".kdf")) {
                defo = defo.substring(0, defo.length() - 4);
            }
            defo = defo + ".";
            defo = defo + "kdrs-form";
            String pathText = PathUtil.makeChildPath((String)"/EAS_Note.kdrs", (String)path);
            NoteUserConfig config = NoteUserConfig.load(localSto, pathText);
            config.putDefaultTemplateName(user, defo);
            NoteUserConfig.save(localSto, pathText, config);
        }
        Element userNode = new Element("User");
        userNode.setText(user);
        usersNode.addContent((Content)userNode);
        try {
            bs = XmlUtil.saveXmlBytes((Element)root);
        }
        catch (IOException ex) {
            throw KDRSException.makeException((String)(filePath + " Save UpdrageDefaultTemplate I/O Error."), (Throwable)ex);
        }
        localSto.writeFile(filePath, -1, bs);
        return true;
    }
}

