/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.integrate2;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteVarListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteDataUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.integrate2.PreviewPanel;
import com.kingdee.bos.ctrl.report.forapp.kdnote.integrate2.TemplateReadException;
import com.kingdee.bos.ctrl.report.impl.r1note.specialdata.NoteInteriorDataProviderFactory;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.print.browser.R1PrintBrowser;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.IPrintVariantListener;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.RuntimeModel;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.AbstractInteriorDataProviderFactory;
import java.io.ByteArrayInputStream;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class PreviewArea {
    public static final Logger log = LogUtil.getPackageLogger(PreviewArea.class);
    private PreviewPanel _ctrl = new PreviewPanel();
    private R1PrintBrowser _browser;

    public PreviewArea() {
        this.initBrowser();
    }

    private void initBrowser() {
        this._browser = new R1PrintBrowser();
        this._browser.setPrinterCtrl(new KDPrinter());
        this._browser.setVariantListener((IPrintVariantListener)new NoteVarListener.R1VarListener());
    }

    public JComponent getCtrl() {
        return this._ctrl;
    }

    public void preview(String templatePath, AbstractPrintDataProvider dataProvider) throws TemplateReadException {
        if (templatePath == null || dataProvider == null) {
            throw new IllegalArgumentException("param must be not null");
        }
        this.updatePreview("/EAS_Note.kdrs" + templatePath, dataProvider);
    }

    private void updatePreview(String absTemplatePath, AbstractPrintDataProvider dataProvider) throws TemplateReadException {
        RuntimeModel templateModel = this.createRunTimeModel(absTemplatePath);
        templateModel.hookDataProvider(dataProvider, (AbstractInteriorDataProviderFactory)new NoteInteriorDataProviderFactory());
        Paper paper = this._browser.getPrintPaper(templateModel);
        this._ctrl.setPaper(paper);
        this._ctrl.revalidate();
        this._ctrl.repaint();
    }

    private RuntimeModel createRunTimeModel(String absTemplatePath) throws TemplateReadException {
        IBizContent _bizContent = null;
        byte[] bytes = null;
        try {
            _bizContent = KDNoteHelper.getBizContent();
            bytes = _bizContent.readTemplate(absTemplatePath);
        }
        catch (KDRSException e) {
            log.error((Object)"\u8bfb\u53d6\u6a21\u677f\u5931\u8d25", (Throwable)e);
            throw new TemplateReadException(MultiLanguageUtil.getMLS("previewArea.readTemplateFailed"), e);
        }
        if (bytes == null || bytes.length == 0) {
            throw new TemplateReadException(MultiLanguageUtil.getMLS("previewArea.templateNotFound"));
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        NoteDataUtil.R1RuntimeDsInfoCreator rtDsInfoCreator = new NoteDataUtil.R1RuntimeDsInfoCreator(new NoteDataUtil.DefaultReferenceResourceLoader(_bizContent), absTemplatePath);
        try {
            return KDNoteHelper.loadR1Model(inputStream, null, rtDsInfoCreator);
        }
        catch (R1Exception e2) {
            log.error((Object)"\u89e3\u6790\u6a21\u677f\u5931\u8d25", (Throwable)e2);
            throw new TemplateReadException(MultiLanguageUtil.getMLS("previewArea.resolveTemplateFailed"), e2);
        }
    }
}

