/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.server.publishedcheck;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class PublishedTempletChecker {
    private static final Logger log = LogUtil.getLogger(PublishedTempletChecker.class);
    private static String[] AcceptsPostfix = new String[]{".bos-query", ".note-dynquery", ".r1-print", ".kdrs-form"};
    private String _startPath;
    private int _rootPathLength;
    private List _excepts;
    private StringBuffer _errorInfo;
    private StringBuffer _warningInfo;
    private boolean _isOK;

    public void setCtrlhome(String ctrlhome) {
        this._startPath = ctrlhome + "/server/storage/eas/kdnote/template";
        this._rootPathLength = this._startPath.length();
    }

    public void setRootPath(String rootPath) {
        this._startPath = rootPath;
        this._rootPathLength = this._startPath.length();
    }

    public void setRelativePath(String path) {
        this._startPath = this._startPath + path;
    }

    public void addExcept(String name) {
        if (this._excepts == null) {
            this._excepts = new ArrayList();
        }
        this._excepts.add(name);
    }

    public StringBuffer getErrorInfo() {
        if (this._errorInfo == null) {
            this._errorInfo = new StringBuffer();
        }
        return this._errorInfo;
    }

    public StringBuffer getWarningInfo() {
        if (this._warningInfo == null) {
            this._warningInfo = new StringBuffer();
        }
        return this._warningInfo;
    }

    public boolean isOK() {
        return this._isOK;
    }

    public boolean check() {
        this._errorInfo = new StringBuffer();
        this._warningInfo = new StringBuffer();
        this.checkResource(this._startPath);
        this._isOK = this._errorInfo.length() == 0 && this._warningInfo.length() == 0;
        return this._isOK;
    }

    private void checkResource(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            this.addErrorInfo(MultiLanguageUtil.getMLS("publishedcheck.PublishedTempletChecker.pathError") + filePath, filePath);
            return;
        }
        if (file.isDirectory()) {
            this.checkFolder(file);
        } else {
            this.checkFile(file);
        }
    }

    private void checkFolder(File folder) {
        int i;
        Map mapDotMeta = null;
        boolean dotMetaExist = false;
        ArrayList<String> listChildren = new ArrayList<String>();
        String folderPath = folder.getPath() + "/";
        String[] childrenName = folder.list();
        for (i = 0; i < childrenName.length; ++i) {
            if (this._excepts != null && this._excepts.contains(childrenName[i])) continue;
            String fileName = folderPath + childrenName[i];
            if (".meta".equals(childrenName[i])) {
                dotMetaExist = true;
                File dotMetaFile = new File(fileName);
                this.checkFile(dotMetaFile);
                try {
                    mapDotMeta = this.pickDotMeta(dotMetaFile);
                }
                catch (Exception ex) {
                    this.addErrorInfo(MultiLanguageUtil.getMLS("publishedcheck.PublishedTempletChecker.parseError"), fileName);
                    log.error((Object)"", (Throwable)ex);
                }
                continue;
            }
            File existFile = new File(fileName);
            if (existFile.isDirectory() || this.isAcceptType(childrenName[i])) {
                listChildren.add(childrenName[i]);
                continue;
            }
            this.addErrorInfo(MultiLanguageUtil.getMLS("publishedcheck.PublishedTempletChecker.fileError"), fileName);
        }
        if (!dotMetaExist) {
            this.addErrorInfo(MultiLanguageUtil.getMLS("publishedcheck.PublishedTempletChecker.missMetError"), folderPath);
        }
        if (mapDotMeta != null) {
            for (String nameInDotMeta : mapDotMeta.keySet()) {
                String fileName = folderPath + nameInDotMeta;
                if (listChildren.contains(nameInDotMeta)) {
                    ResMetaInfo resMetaInfo = (ResMetaInfo)mapDotMeta.get(nameInDotMeta);
                    File existFile = new File(fileName);
                    if (resMetaInfo.isDirectory()) {
                        if (!existFile.isDirectory()) {
                            this.addErrorInfo(MultiLanguageUtil.getMLS("publishedcheck.PublishedTempletChecker.notFolderError"), fileName);
                        }
                    } else if (existFile.isDirectory()) {
                        this.addErrorInfo(MultiLanguageUtil.getMLS("publishedcheck.PublishedTempletChecker.notFileError"), fileName);
                    }
                } else {
                    this.addErrorInfo(MultiLanguageUtil.getMLS("publishedcheck.PublishedTempletChecker.missSourceError"), fileName);
                }
                if (!nameInDotMeta.endsWith(".kdrs-form")) continue;
                this.addWarningInfo(MultiLanguageUtil.getMLS("publishedcheck.PublishedTempletChecker.nominateR1"), fileName);
            }
        }
        int c = listChildren.size();
        for (i = 0; i < c; ++i) {
            String nameOfExistFile = (String)listChildren.get(i);
            String fileName = folderPath + nameOfExistFile;
            if (mapDotMeta != null && !mapDotMeta.containsKey(nameOfExistFile)) {
                this.addErrorInfo(MultiLanguageUtil.getMLS("publishedcheck.PublishedTempletChecker.notExitError"), fileName);
            }
            this.checkResource(fileName);
        }
    }

    private void checkFile(File file) {
        if (file.length() == 0L) {
            this.addErrorInfo(MultiLanguageUtil.getMLS("publishedcheck.PublishedTempletChecker.zeroLength"), file.getPath());
        } else {
            String code = null;
            CodeChecker codeChecker = new CodeChecker();
            try {
                code = codeChecker.getCharSet(file);
            }
            catch (IOException ex) {
                log.error((Object)"", (Throwable)ex);
                this.addErrorInfo(MultiLanguageUtil.getMLS("publishedcheck.PublishedTempletChecker.ioException"), file.getPath());
            }
            if ("UTF-8" != code && "ASCII" != code) {
                this.addErrorInfo(MultiLanguageUtil.getMLS("publishedcheck.PublishedTempletChecker.fileCode") + code + ")", file.getPath());
            }
        }
    }

    private Map pickDotMeta(File dotMetaFile) throws IOException, JDOMException {
        HashMap<String, ResMetaInfo> result = new HashMap<String, ResMetaInfo>();
        Element root = XmlUtil.loadXmlFile((File)dotMetaFile);
        Element nodes = root.getChild("Nodes");
        for (Element node : nodes.getChildren()) {
            String name = node.getAttributeValue("name");
            String type = node.getAttributeValue("type");
            result.put(name, new ResMetaInfo(name, "Folder".equalsIgnoreCase(type)));
        }
        return result;
    }

    private void addErrorInfo(String info, String filePath) {
        this._errorInfo.append("\u25a0 ");
        this._errorInfo.append(info);
        this._errorInfo.append(": ");
        this._errorInfo.append(filePath.substring(this._rootPathLength));
        this._errorInfo.append(StringUtil.RETURN);
    }

    private void addWarningInfo(String info, String filePath) {
        this._warningInfo.append("\u25b2 ");
        this._warningInfo.append(info);
        this._warningInfo.append(": ");
        this._warningInfo.append(filePath.substring(this._rootPathLength));
        this._warningInfo.append(StringUtil.RETURN);
    }

    private boolean isAcceptType(String fileName) {
        int c = AcceptsPostfix.length;
        for (int i = 0; i < c; ++i) {
            if (!fileName.endsWith(AcceptsPostfix[i])) continue;
            return true;
        }
        return false;
    }

    private static class CodeChecker {
        private static final String CODE_UNKNOW = "unkown";
        private static final String CODE_ASCII = "ASCII";
        private static final String CODE_GBK = "GBK";
        private static final String CODE_UTF8 = "UTF-8";
        private static final String CODE_UTF16LE = "UTF-16LE";
        private static final String CODE_UTF16BE = "UTF-16BE";
        private boolean _isOnlyReadBom = false;

        private CodeChecker() {
        }

        public void setOnlyReadBom(boolean is) {
            this._isOnlyReadBom = is;
        }

        private static boolean isUTF16LE(byte[] first3Bytes) {
            return first3Bytes[0] == -1 && first3Bytes[1] == -2;
        }

        private static boolean isUTF16BE(byte[] first3Bytes) {
            return first3Bytes[0] == -2 && first3Bytes[1] == -1;
        }

        private static boolean isUTF8(byte[] first3Bytes) {
            return first3Bytes[0] == -17 && first3Bytes[1] == -69 && first3Bytes[2] == -65;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getCharSet(File file) throws IOException {
            BufferedInputStream bis = null;
            String result = CODE_UNKNOW;
            try {
                byte[] first3Bytes = new byte[3];
                bis = new BufferedInputStream(new FileInputStream(file));
                bis.mark(0);
                int read = bis.read(first3Bytes, 0, 3);
                if (read != -1) {
                    if (CodeChecker.isUTF8(first3Bytes)) {
                        result = CODE_UTF8;
                    } else if (CodeChecker.isUTF16LE(first3Bytes)) {
                        result = CODE_UTF16LE;
                    } else if (CodeChecker.isUTF16BE(first3Bytes)) {
                        result = CODE_UTF16BE;
                    }
                }
                if (!this._isOnlyReadBom && result == CODE_UNKNOW) {
                    bis.reset();
                    result = CodeChecker.getCharSetFromContent(bis);
                }
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return result;
        }

        private static String getCharSetFromContent(BufferedInputStream bis) throws IOException {
            int read;
            while ((read = bis.read()) != -1) {
                if (read >= 240) {
                    return CODE_GBK;
                }
                if (128 <= read && read <= 191) {
                    return CODE_GBK;
                }
                if (192 <= read && read <= 223) {
                    read = bis.read();
                    if (128 <= read && read <= 191) continue;
                    return CODE_GBK;
                }
                if (224 > read || read > 239) continue;
                read = bis.read();
                if (128 <= read && read <= 191) {
                    read = bis.read();
                    if (128 <= read && read <= 191) {
                        return CODE_UTF8;
                    }
                    return CODE_GBK;
                }
                return CODE_GBK;
            }
            return CODE_ASCII;
        }
    }

    private static class ResMetaInfo {
        private String _name;
        private boolean _isDirectory;

        public ResMetaInfo(String name, boolean isDirectory) {
            this._name = name;
            this._isDirectory = isDirectory;
        }

        public String getName() {
            return this._name;
        }

        public boolean isDirectory() {
            return this._isDirectory;
        }
    }
}

