/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.impl.r1note;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteDataUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.actions.operate.data.AbstractDataOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.DataTree;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractDataProcessor;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.Component;
import java.awt.LayoutManager;

public class DataInfoOperate
extends AbstractDataOperate {
    public static final String EXT_DataProcessClassName = "processClassName";

    public void setSelectedData(DataExtend[] data) {
        this.isValid = data != null && data.length == 1;
    }

    public boolean operate() {
        DataExtend dataExt;
        try {
            dataExt = this.getCore().getDataTree().getSelectedData()[0];
        }
        catch (DataTree.SelectErrorException e) {
            WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("r1note.DataInfoOperate.notChooseData"), (String)this.getPromptTitle(), (Component)this.getParentCtrl());
            return false;
        }
        Object pcn = dataExt.getProperty(EXT_DataProcessClassName);
        CustomPanel pan = new CustomPanel();
        pan.setInfo(dataExt.getInfo());
        pan.setProcessClassName(pcn == null ? null : pcn.toString());
        SimpleDialog dlg = SimpleDialog.create((Component)this.getParentCtrl());
        dlg.setSize(640, 280);
        dlg.setTitle(MultiLanguageUtil.getMLS("r1note.DataInfoOperate.dataSourceInfo"));
        dlg.setComponent((Component)((Object)pan));
        if (dlg.showDialog()) {
            String processClassName = pan.getProcessClassName();
            dataExt.setProperty(EXT_DataProcessClassName, (Object)processClassName);
            this.getCore().getModel().setDirty(true);
        }
        return true;
    }

    class CustomPanel
    extends KDPanel
    implements SimpleDialog.PanelOfSimpleDialog {
        private KDTextArea txaDataInfo;
        private KDTextField txtProcess;
        private KDTextArea txaPrompt;

        private CustomPanel() {
            this.init();
        }

        private void init() {
            this.txtProcess = new KDTextField();
            this.txaDataInfo = new KDTextArea();
            this.txaDataInfo.setBorder(null);
            this.txaDataInfo.setEnabled(false);
            this.txaPrompt = new KDTextArea();
            this.txaPrompt.setBorder(null);
            this.txaPrompt.setEnabled(false);
            this.txaPrompt.setText(MultiLanguageUtil.getMLS("r1note.DataInfoOperate.promt"));
            TableLayout tl = TableLayout.splitRow((int)6);
            tl.rowStyle(0).setHeight(20);
            tl.rowStyle(1).setHeight(40);
            tl.rowStyle(2).setHeight(60);
            tl.rowStyle(2).setMarginBottom(20);
            tl.rowStyle(3).setHeight(20);
            tl.rowStyle(4).setHeight(20);
            tl.rowStyle(5).setPriY(1);
            this.setLayout((LayoutManager)tl);
            this.add((Component)new KDLabel(MultiLanguageUtil.getMLS("r1note.DataInfoOperate.dataSource")), tl.cell(0));
            this.add((Component)new KDScrollPane((Component)this.txaDataInfo), tl.cell(1));
            this.add((Component)this.txaPrompt, tl.cell(2));
            this.add((Component)new KDLabel(MultiLanguageUtil.getMLS("r1note.DataInfoOperate.info")), tl.cell(3));
            this.add((Component)new KDScrollPane((Component)this.txtProcess), tl.cell(4));
        }

        public void setInfo(String info) {
            this.txaDataInfo.setText(NoteDataUtil.getMetaPrompt(info));
            String c = NoteDataUtil.checkMetaCategoryFromInfo(info);
            this.txaPrompt.setVisible(c == "::" || c == "dynquery://");
        }

        public void setProcessClassName(String className) {
            this.txtProcess.setText(className);
        }

        public String getProcessClassName() {
            return this.txtProcess.getText();
        }

        public boolean verify() {
            String pcn = this.getProcessClassName();
            if (StringUtil.isEmptyString((String)pcn)) {
                return true;
            }
            String prompt = null;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(pcn);
            }
            catch (ClassNotFoundException e) {
                prompt = MultiLanguageUtil.getMLS("r1note.DataInfoOperate.classNotexit") + StringUtil.RETURN + pcn;
            }
            if (clazz != null) {
                boolean isFound = false;
                do {
                    if ((clazz = clazz.getSuperclass()) != AbstractDataProcessor.class) continue;
                    isFound = true;
                    break;
                } while (clazz != null);
                if (!isFound) {
                    prompt = MultiLanguageUtil.getMLS("r1note.DataInfoOperate.classWorning");
                }
            }
            if (prompt != null) {
                WindowUtil.msgboxError((Object)prompt, (String)DataInfoOperate.this.getPromptTitle(), (Component)DataInfoOperate.this.getParentCtrl());
                return false;
            }
            return true;
        }
    }
}

