/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.exception.NoteDynQuery_LoadException;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.exception.NoteDynQuery_MainQueryParseException;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.exception.NoteDynQuery_NotExistException;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryCondition;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryEntityNode;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryFieldNode;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryLinkType;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryUtil;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;

public class NoteDynQueryModel {
    private QueryInfo _mainQuery;
    private NoteDynQueryEntityNode _rootEntityNode;
    private List _orders = new ArrayList();
    private List _renameFiled = new ArrayList();
    private HashMap _renameFields;
    public static final String N_ALIAS = "alias";

    public NoteDynQueryModel(String mainQueryPath) throws NoteDynQuery_MainQueryParseException {
        this._mainQuery = NoteDynQueryUtil.getQueryInfo(mainQueryPath);
        if (this._mainQuery == null) {
            throw new NoteDynQuery_MainQueryParseException(mainQueryPath);
        }
        try {
            this._rootEntityNode = NoteDynQueryUtil.convertRootEntityNode(this._mainQuery);
        }
        catch (BOSException ex) {
            throw new NoteDynQuery_MainQueryParseException(mainQueryPath, ex);
        }
    }

    public QueryInfo getMainQuery() {
        return this._mainQuery;
    }

    public String getMainQueryPath() {
        return this._mainQuery.getFullName();
    }

    public NoteDynQueryEntityNode getRootEntityNode() {
        return this._rootEntityNode;
    }

    public void addOrderByField(NoteDynQueryFieldNode fieldNode) {
        this._orders.add(fieldNode);
    }

    public void removeOrderByField(NoteDynQueryFieldNode fieldNode) {
        this._orders.remove(fieldNode);
    }

    public void removeAllOrderByFields() {
        this._orders.clear();
    }

    public NoteDynQueryFieldNode[] getOrderByFields() {
        return this._orders.toArray(new NoteDynQueryFieldNode[0]);
    }

    public void addRenameField(NoteDynQueryFieldNode fieldNode) {
        this._renameFiled.add(fieldNode);
    }

    public void removeRenameField(NoteDynQueryFieldNode fieldNode) {
        this._renameFiled.remove(fieldNode);
    }

    public NoteDynQueryFieldNode[] getRenameFields() {
        return this._renameFiled.toArray(new NoteDynQueryFieldNode[0]);
    }

    public HashMap getRenameFields2() {
        if (this._renameFields == null) {
            NoteDynQueryFieldNode[] renameds = this.getRenameFields();
            this._renameFields = new HashMap(renameds.length);
            for (int i = renameds.length - 1; i >= 0; --i) {
                this._renameFields.put(renameds[i].getFieldName(), renameds[i]);
            }
        }
        return this._renameFields;
    }

    public void removeAllRenameFields() {
        this._renameFiled.clear();
    }

    public NoteDynQueryFieldNode[] getMainQueryFields() {
        ArrayList<NoteDynQueryFieldNode> result = new ArrayList<NoteDynQueryFieldNode>();
        ArrayList fields = this.getMainQuery().getSelector().getFields();
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            QueryFieldInfo fieldInfo = (QueryFieldInfo)fields.get(i);
            NoteDynQueryFieldNode fieldNode = new NoteDynQueryFieldNode(fieldInfo.getName(), fieldInfo.getDisplayName());
            fieldNode.setSystem(true);
            try {
                fieldNode.setDataType(DataType.fromJdbcType((int)fieldInfo.getMappingFieldType().getSQLType()));
            }
            catch (BOSException ex) {
                fieldNode.setDataType(DataType.NULL);
            }
            if (this.getRenameFields2().containsKey(fieldNode.getFieldName())) {
                NoteDynQueryFieldNode node = (NoteDynQueryFieldNode)this.getRenameFields2().get(fieldNode.getFieldName());
                fieldNode.setProperty(node.getProperties());
            }
            result.add(fieldNode);
        }
        return result.toArray(new NoteDynQueryFieldNode[0]);
    }

    public NoteDynQueryFieldNode[] getDynamicFields() {
        ArrayList result = new ArrayList();
        NoteDynQueryModel.pickupDynFields(result, this.getRootEntityNode(), this.getRenameFields2());
        return result.toArray(new NoteDynQueryFieldNode[0]);
    }

    private static void pickupDynFields(List result, NoteDynQueryEntityNode entityNode, HashMap renameFields) {
        int i;
        int c = entityNode.getSelectedFieldsCount();
        for (i = 0; i < c; ++i) {
            NoteDynQueryFieldNode fieldNode = entityNode.getSelectedField(i);
            if (renameFields.containsKey(fieldNode.getFieldName())) {
                NoteDynQueryFieldNode node = (NoteDynQueryFieldNode)renameFields.get(fieldNode.getFieldName());
                fieldNode.setProperty(node.getProperties());
            }
            result.add(fieldNode);
        }
        c = entityNode.getChildrenCount();
        for (i = 0; i < c; ++i) {
            NoteDynQueryEntityNode childEntityNode = entityNode.getChild(i);
            NoteDynQueryModel.pickupDynFields(result, childEntityNode, renameFields);
        }
    }

    public Element toXml() {
        ArrayList fields = new ArrayList();
        Element xmlMainQuery = new Element("MainQuery");
        xmlMainQuery.setAttribute("fullName", this.getMainQueryPath());
        Element xmlEntities = new Element("Entities");
        NoteDynQueryModel.saveEntities(this.getRootEntityNode(), xmlEntities, fields);
        Element xmlFields = new Element("Fields");
        for (NoteDynQueryFieldNode field : fields) {
            Element xmlField = new Element("Field");
            xmlField.setAttribute("name", field.getFieldName());
            xmlFields.addContent((Content)xmlField);
        }
        Element xmlOrders = new Element("Orders");
        for (NoteDynQueryFieldNode field : this._orders) {
            Element xmlField = new Element("Field");
            xmlField.setAttribute("name", field.getFieldName());
            if (field.getOrderType() == 2) {
                xmlField.setAttribute("sort", "desc");
            } else {
                xmlField.setAttribute("sort", "asc");
            }
            xmlOrders.addContent((Content)xmlField);
        }
        Element xmlRenameAlias = new Element("RenameAlias");
        for (NoteDynQueryFieldNode field : this._renameFiled) {
            Element xmlField = new Element("Field");
            xmlField.setAttribute("name", field.getFieldName());
            HashMap aliasMap = new HashMap();
            LangUtil.setProperty(aliasMap, (String)N_ALIAS, (Map)field.getProperties());
            LangUtil.saveProperty((String)N_ALIAS, aliasMap, (Element)xmlField);
            xmlRenameAlias.addContent((Content)xmlField);
        }
        Element xmlRoot = new Element("NoteDynQueryModel");
        xmlRoot.setAttribute("version", "6.1.0");
        xmlRoot.addContent((Content)xmlMainQuery);
        xmlRoot.addContent((Content)xmlEntities);
        xmlRoot.addContent((Content)xmlFields);
        xmlRoot.addContent((Content)xmlOrders);
        xmlRoot.addContent((Content)xmlRenameAlias);
        return xmlRoot;
    }

    private static void saveEntities(NoteDynQueryEntityNode entityNode, Element xmlEntities, List fields) {
        int i;
        if (!entityNode.isSystem()) {
            Element xmlEntity = new Element("Entity");
            xmlEntity.setAttribute("name", entityNode.getEntityName());
            xmlEntity.setAttribute("parent", entityNode.getParent().getEntityName());
            xmlEntity.setAttribute("bosObjectId", entityNode.getBosObjectId());
            xmlEntity.setAttribute("linkType", entityNode.getLinkType().toStore());
            int c = entityNode.getConditionsCount();
            for (int i2 = 0; i2 < c; ++i2) {
                NoteDynQueryCondition condition = entityNode.getCondition(i2);
                Element xmlCondition = new Element("Condition");
                xmlCondition.setAttribute("left", condition.getLeftField().getFieldName());
                xmlCondition.setAttribute("compare", condition.getCompareType().toString());
                xmlCondition.setAttribute("right", condition.getRightField().getFieldName());
                xmlEntity.addContent((Content)xmlCondition);
            }
            xmlEntities.addContent((Content)xmlEntity);
        }
        int c = entityNode.getSelectedFieldsCount();
        for (i = 0; i < c; ++i) {
            fields.add(entityNode.getSelectedField(i));
        }
        c = entityNode.getChildrenCount();
        for (i = 0; i < c; ++i) {
            NoteDynQueryModel.saveEntities(entityNode.getChild(i), xmlEntities, fields);
        }
    }

    public static NoteDynQueryModel fromXml(Element xmlRoot) throws NoteDynQuery_MainQueryParseException, NoteDynQuery_LoadException {
        Element xmlMainQuery = xmlRoot.getChild("MainQuery");
        Element xmlEntities = xmlRoot.getChild("Entities");
        Element xmlFields = xmlRoot.getChild("Fields");
        Element xmlOrders = xmlRoot.getChild("Orders");
        Element xmlRenameAlias = xmlRoot.getChild("RenameAlias");
        String mainQueryPath = xmlMainQuery.getAttributeValue("fullName");
        NoteDynQueryModel model = new NoteDynQueryModel(mainQueryPath);
        StringBuffer prompt = new StringBuffer();
        String error = NoteDynQueryModel.loadEntities(xmlEntities, model.getRootEntityNode());
        prompt.append(error);
        error = NoteDynQueryModel.loadFields(xmlFields, model.getRootEntityNode());
        prompt.append(error);
        NoteDynQueryModel.loadOrders(xmlOrders, model);
        NoteDynQueryModel.loadRenameFields(xmlRenameAlias, model);
        if (prompt.length() > 0) {
            throw new NoteDynQuery_LoadException(prompt.toString(), model);
        }
        return model;
    }

    private static String loadEntities(Element xmlEntities, NoteDynQueryEntityNode rootEntityNode) throws NoteDynQuery_LoadException {
        StringBuffer prompt = new StringBuffer();
        for (Element xmlEntity : xmlEntities.getChildren("Entity")) {
            EntityObjectInfo entity;
            String name = xmlEntity.getAttributeValue("name");
            String parentName = xmlEntity.getAttributeValue("parent");
            String bosObjectId = xmlEntity.getAttributeValue("bosObjectId");
            String linkType = xmlEntity.getAttributeValue("linkType");
            try {
                entity = NoteDynQueryUtil.getEntity(bosObjectId);
            }
            catch (MetaDataNotFoundException ex) {
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.dynamicAdded"));
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.entity"));
                prompt.append(name);
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.comma"));
                prompt.append("BOSType[" + bosObjectId + "]");
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.comma"));
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.currentEnv"));
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.notExist"));
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.fullstop"));
                prompt.append(StringUtil.RETURN);
                continue;
            }
            NoteDynQueryEntityNode entityNode = new NoteDynQueryEntityNode();
            entityNode.setSystem(false);
            entityNode.setBosObjectId(bosObjectId);
            entityNode.setEntityAlias(entity.getAlias());
            entityNode.setEntityName(name);
            entityNode.setLinkType(NoteDynQueryLinkType.fromStore(linkType));
            NoteDynQueryEntityNode parentNode = rootEntityNode.searchNode(parentName);
            if (parentNode == null) {
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.dynamicAdded"));
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.entity"));
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.colon"));
                prompt.append(name);
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.comma"));
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.currentEnv"));
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.parentEntity"));
                prompt.append(parentName);
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.notExist"));
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.fullstop"));
                prompt.append(StringUtil.RETURN);
                continue;
            }
            parentNode.addChild(entityNode);
            String error = NoteDynQueryModel.loadConditions(xmlEntity, parentNode, entityNode);
            if (StringUtil.isEmptyString((String)error)) continue;
            prompt.append(error);
        }
        return prompt.toString();
    }

    private static String loadConditions(Element xmlEntity, NoteDynQueryEntityNode parentNode, NoteDynQueryEntityNode entityNode) {
        StringBuffer prompt = new StringBuffer();
        for (Element xmlCondition : xmlEntity.getChildren("Condition")) {
            StringBuffer sb;
            String leftFieldName = xmlCondition.getAttributeValue("left");
            String compare = xmlCondition.getAttributeValue("compare");
            String rightFieldName = xmlCondition.getAttributeValue("right");
            NoteDynQueryFieldNode leftField = null;
            NoteDynQueryFieldNode rightField = null;
            try {
                leftField = parentNode.getAppointedProperty(leftFieldName);
            }
            catch (NoteDynQuery_NotExistException e) {
                sb = new StringBuffer();
                sb.append(parentNode.getEntityName() + "." + leftFieldName);
                sb.append(compare);
                sb.append(entityNode.getEntityName() + "." + rightFieldName);
                NoteDynQueryModel.makeConditionErrorPrompt(prompt, sb.toString(), parentNode.getEntityName(), leftFieldName);
            }
            try {
                rightField = entityNode.getAppointedProperty(rightFieldName);
            }
            catch (NoteDynQuery_NotExistException e) {
                sb = new StringBuffer();
                sb.append(parentNode.getEntityName() + "." + leftFieldName);
                sb.append(compare);
                sb.append(entityNode.getEntityName() + "." + rightFieldName);
                NoteDynQueryModel.makeConditionErrorPrompt(prompt, sb.toString(), entityNode.getEntityName(), rightFieldName);
            }
            if (leftField == null || rightField == null) continue;
            NoteDynQueryFieldNode leftFieldNode = new NoteDynQueryFieldNode(leftFieldName, leftField.getFieldAlias());
            NoteDynQueryFieldNode rightFieldNode = new NoteDynQueryFieldNode(rightFieldName, rightField.getFieldAlias());
            CompareType compareType = CompareType.getEnum((String)compare);
            NoteDynQueryCondition condition = new NoteDynQueryCondition(leftFieldNode, compareType, rightFieldNode);
            entityNode.addCondition(condition);
        }
        return prompt.toString();
    }

    private static void makeConditionErrorPrompt(StringBuffer prompt, String condition, String entityName, String errorProperty) {
        prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.joinCondition"));
        prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.colon"));
        prompt.append(condition);
        prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.comma"));
        prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.currentEnv"));
        prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.entity"));
        prompt.append(entityName);
        prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.notContains"));
        prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.property"));
        prompt.append(errorProperty);
        prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.fullstop"));
        prompt.append(StringUtil.RETURN);
    }

    private static String loadFields(Element xmlFields, NoteDynQueryEntityNode rootEntityNode) {
        StringBuffer prompt = new StringBuffer();
        for (Element xmlField : xmlFields.getChildren("Field")) {
            String fieldFullName = xmlField.getAttributeValue("name");
            int dotIdx = fieldFullName.indexOf(".");
            String entityName = fieldFullName.substring(0, dotIdx);
            String fieldName = fieldFullName.substring(dotIdx + 1);
            NoteDynQueryEntityNode entityNode = rootEntityNode.searchNode(entityName);
            if (entityNode == null) {
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.dynamicAdded"));
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.field"));
                prompt.append(fieldFullName);
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.comma"));
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.currentEnv"));
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.entity"));
                prompt.append(entityName);
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.notExist"));
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.fullstop"));
                prompt.append(StringUtil.RETURN);
                continue;
            }
            NoteDynQueryFieldNode srcFieldNode = null;
            try {
                srcFieldNode = entityNode.getAppointedField(fieldName);
            }
            catch (NoteDynQuery_NotExistException ex) {
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.dynamicAdded"));
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.field"));
                prompt.append(fieldFullName);
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.comma"));
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.currentEnv"));
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.entity"));
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.notContains"));
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.field"));
                prompt.append(fieldName);
                prompt.append(MultiLanguageUtil.getMLS("model.NoteDynQueryModel.fullstop"));
                prompt.append(StringUtil.RETURN);
            }
            if (srcFieldNode == null) continue;
            String fieldAlias = srcFieldNode.getFieldAlias();
            NoteDynQueryFieldNode fieldNode = new NoteDynQueryFieldNode(fieldFullName, fieldAlias);
            fieldNode.setSystem(false);
            fieldNode.setDataType(srcFieldNode.getDataType());
            entityNode.addSelectedField(fieldNode);
        }
        return prompt.toString();
    }

    private static void loadOrders(Element xmlOrders, NoteDynQueryModel model) {
        for (Element xmlField : xmlOrders.getChildren("Field")) {
            String fieldName = xmlField.getAttributeValue("name");
            String orderType = xmlField.getAttributeValue("sort");
            NoteDynQueryFieldNode field = new NoteDynQueryFieldNode(fieldName, null);
            if ("desc".equals(orderType)) {
                field.setOrderType(2);
            } else {
                field.setOrderType(1);
            }
            model.addOrderByField(field);
        }
    }

    private static void loadRenameFields(Element xmlRenameAlias, NoteDynQueryModel model) {
        if (xmlRenameAlias == null) {
            return;
        }
        for (Element xmlField : xmlRenameAlias.getChildren("Field")) {
            String fieldName = xmlField.getAttributeValue("name");
            NoteDynQueryFieldNode field = new NoteDynQueryFieldNode(fieldName, null);
            LangUtil.loadProperty((String)N_ALIAS, (Map)field.getProperties(), (Element)xmlField);
            field.setProperty(LangUtil.getPropertyStr((Map)field.getProperties(), (String)N_ALIAS));
            field.setRenameAlias(true);
            model.addRenameField(field);
        }
    }
}

