/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.impl.r1note.templetwizard;

import com.kingdee.bos.ctrl.common.CtrlEnv;
import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.report.impl.r1note.templetwizard.ITempletWizardModel;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;

class TempletWizardModel
implements ITempletWizardModel {
    private String _resourcePackage;
    private String _resourceName;
    private String _bizType;
    private InputStream _templet;
    private ArrayList _necessaryDatas;
    private String _demoInformation;
    private String _temMode;

    public TempletWizardModel(String resourcePackage, String resourceName) {
        this._resourcePackage = resourcePackage;
        this._resourceName = resourceName;
    }

    public void load() throws Exception {
        String pack = this._resourcePackage + "/";
        String resourcePath = pack + this._resourceName + ".xml";
        InputStream is = CtrlEnv.getEnvClassLoader().getResourceAsStream(resourcePath);
        Element xmlRoot = XmlUtil.loadXmlStream((InputStream)is);
        this._bizType = xmlRoot.getAttributeValue("bizType");
        String templetName = LangUtil.getAttrValue((Element)xmlRoot, (String)"templet");
        String templetPath = pack + templetName;
        this._templet = CtrlEnv.getEnvClassLoader().getResourceAsStream(templetPath);
        if (this._templet == null) {
            throw new TempletLoadException("Load demo templet file error.");
        }
        this._necessaryDatas = new ArrayList();
        Element xmlNDs = xmlRoot.getChild("NecessaryDatas");
        List listNDs = xmlNDs.getChildren("NecessaryData");
        int c = listNDs.size();
        for (int i = 0; i < c; ++i) {
            NecessaryData nd = new NecessaryData();
            Element xmlND = (Element)listNDs.get(i);
            nd.setName(xmlND.getAttributeValue("name"));
            nd.setMetaInfo(xmlND.getAttributeValue("metaInfo"));
            nd.setDescription(LangUtil.getAttrValue((Element)xmlND, (String)"desc"));
            Element xmlAss = xmlND.getChild("Associate");
            if (xmlAss != null) {
                String paramName = xmlAss.getAttributeValue("paramName");
                String mainDs = xmlAss.getAttributeValue("mainDs");
                String mainField = xmlAss.getAttributeValue("mainField");
                nd.setAssociate(paramName, mainDs, mainField);
            }
            this._necessaryDatas.add(nd);
        }
        Element xmlInfo = xmlRoot.getChild("Information");
        Element xmlInfo_lang = LangUtil.getLangChildNode((Element)xmlInfo);
        if (xmlInfo_lang != null) {
            this._demoInformation = xmlInfo_lang.getText();
        }
    }

    @Override
    public String getBizType() {
        return this._bizType;
    }

    @Override
    public ITempletWizardModel.INecessaryData[] getNecessaryDatas() {
        return this._necessaryDatas.toArray(new ITempletWizardModel.INecessaryData[0]);
    }

    @Override
    public InputStream getTemplet() {
        return this._templet;
    }

    @Override
    public String getDemoInformation() {
        return this._demoInformation;
    }

    @Override
    public void setTemMode(String mode) {
        this._temMode = mode;
    }

    @Override
    public String getTemMode() {
        return this._temMode;
    }

    private static class NecessaryData
    implements ITempletWizardModel.INecessaryData {
        private String _dsName;
        private String _description;
        private String _metaInfo;
        private ITempletWizardModel.IAssociate _associate;

        private NecessaryData() {
        }

        @Override
        public String getName() {
            return this._dsName;
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public String getMetaInfo() {
            return this._metaInfo;
        }

        @Override
        public ITempletWizardModel.IAssociate getAssociate() {
            return this._associate;
        }

        public void setName(String name) {
            this._dsName = name;
        }

        public void setDescription(String desc) {
            this._description = desc;
        }

        public void setMetaInfo(String metaInfo) {
            this._metaInfo = metaInfo;
        }

        public void setAssociate(String paramName, String mainDs, String mainField) {
            this._associate = new Associate(paramName, mainDs, mainField);
        }

        private static class Associate
        implements ITempletWizardModel.IAssociate {
            private String _paramName;
            private String _mainDs;
            private String _mainField;

            public Associate(String paramName, String mainDs, String mainField) {
                this._paramName = paramName;
                this._mainDs = mainDs;
                this._mainField = mainField;
            }

            @Override
            public String getParamName() {
                return this._paramName;
            }

            @Override
            public String getAssociateDs() {
                return this._mainDs;
            }

            @Override
            public String getAssociateField() {
                return this._mainField;
            }
        }
    }

    static class TempletLoadException
    extends Exception {
        public TempletLoadException(String message) {
            super(message);
        }
    }
}

