/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.base;

import com.kingdee.bos.olap.Cell;
import com.kingdee.bos.olap.Formatter;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.mdx.MdxMember;
import com.kingdee.bos.olap.util.ColorUtil;
import com.kingdee.bos.olap.util.Util;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;

public class CellImpl
implements Cell,
Serializable {
    private static final long serialVersionUID = -5194489819006676574L;
    Object value;
    Formatter format;
    boolean isNull;
    transient Member[] memberContext;
    MdxMember[] mdxMemberContext;

    public CellImpl(Member[] context, Object _value, Formatter _format) {
        this.memberContext = context;
        this.value = _value instanceof BigDecimal ? Util.internBigDecimal((BigDecimal)_value) : _value;
        this.format = _format;
    }

    public CellImpl(Member[] context) {
        this.memberContext = context;
        this.isNull = true;
    }

    public CellImpl(MdxMember[] context) {
        this.mdxMemberContext = context;
        this.isNull = true;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getFormattedValue() {
        if (this.isNull) {
            return "";
        }
        if (this.format == null) {
            if (this.value == null) {
                return "";
            }
            return this.value.toString();
        }
        return this.format.format(this.value);
    }

    @Override
    public boolean isNull() {
        return this.isNull;
    }

    @Override
    public Member[] getMemberContext() {
        return this.memberContext;
    }

    @Override
    public MdxMember[] getMdxMemberContext() {
        return this.mdxMemberContext;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.format);
        out.writeBoolean(this.isNull);
        if (!this.isNull) {
            out.writeObject(this.value);
        }
        if (this.mdxMemberContext == null) {
            out.writeInt(this.memberContext.length);
            for (int i = 0; i < this.memberContext.length; ++i) {
                out.writeObject(this.memberContext[i].getUniqueName());
            }
        } else {
            out.writeInt(this.mdxMemberContext.length);
            for (int i = 0; i < this.mdxMemberContext.length; ++i) {
                out.writeObject(this.mdxMemberContext[i].getUniqueName());
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.format = (Formatter)in.readObject();
        this.isNull = in.readBoolean();
        if (!this.isNull) {
            this.value = in.readObject();
        }
        int len = in.readInt();
        this.mdxMemberContext = new MdxMember[len];
        for (int i = 0; i < len; ++i) {
            this.mdxMemberContext[i] = new MdxMember((String)in.readObject());
        }
    }

    @Override
    public String getFormatString() {
        if (this.format == null) {
            return null;
        }
        return this.format.getFormatString();
    }

    @Override
    public Color getForeColor() {
        if (this.format == null) {
            return null;
        }
        if (this.format.getColor() != null) {
            return ColorUtil.getColor(this.format.getColor());
        }
        return null;
    }

    @Override
    public Color getBgColor() {
        if (this.format == null) {
            return null;
        }
        if (this.format.getBgColor() != null) {
            return ColorUtil.getColor(this.format.getBgColor());
        }
        return null;
    }

    @Override
    public String getStatus() {
        if (this.format == null) {
            return null;
        }
        return this.format.getStatus();
    }

    @Override
    public String getTrend() {
        if (this.format == null) {
            return null;
        }
        return this.format.getTrend();
    }
}

