/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.collection;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.IInnerList;
import com.kingdee.bos.olap.collection.IList;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.collection.IStorageManager;
import com.kingdee.bos.olap.collection.MemberListWrapper;
import com.kingdee.bos.olap.util.ObjectComparator;

public class CacheableMemberListWrapper
extends MemberListWrapper
implements IMemberList {
    IStorageManager storageManager;

    CacheableMemberListWrapper(IInnerList innerList, IStorageManager storageManager) {
        super(innerList);
        this.storageManager = storageManager;
    }

    @Override
    public void add(Object o) {
        super.add(o);
        this.doCache();
    }

    @Override
    public void addArray(Object[] objects) {
        super.addArray(objects);
        this.doCache();
    }

    @Override
    public void addFirst(Object o) {
        super.addFirst(o);
        this.doCache();
    }

    @Override
    public void addList(IList list) {
        super.addList(list);
        this.doCache();
    }

    @Override
    public void sort(ObjectComparator comparator) throws OLAPException {
        super.sort(comparator);
        this.doCache();
    }

    void doCache() {
        if (this.innerList.realSize() > 10000) {
            this.innerList.doCache(this.storageManager);
        }
    }
}

