/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.collection;

import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.collection.ArrayList;
import com.kingdee.bos.olap.collection.IInnerList;
import com.kingdee.bos.olap.collection.IList;
import com.kingdee.bos.olap.collection.IListFactory;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.collection.JoinList;
import com.kingdee.bos.olap.collection.ListWrapper;
import com.kingdee.bos.olap.collection.MemberListWrapper;
import com.kingdee.bos.olap.collection.UnionList;

public class DefaultListFactory
implements IListFactory {
    public static DefaultListFactory instance = new DefaultListFactory();

    @Override
    public IList createArrayList(int capacity) {
        return new ListWrapper(new ArrayList(capacity));
    }

    @Override
    public IList createArrayList() {
        return new ListWrapper(new ArrayList());
    }

    @Override
    public IList createArrayList(Object[] array) {
        if (array == null) {
            return IList.EMPTY;
        }
        IInnerList list = new ArrayList(array.length);
        list = list.innerAddArray(array);
        return new ListWrapper(list);
    }

    @Override
    public IMemberList createMemberList(int capacity) {
        return new MemberListWrapper(new ArrayList(capacity));
    }

    @Override
    public IMemberList createMemberList() {
        return new MemberListWrapper(new ArrayList());
    }

    @Override
    public IMemberList createMemberList(Member[] array) {
        if (array == null) {
            return IMemberList.EMPTY;
        }
        IInnerList list = new ArrayList(array.length);
        list = list.innerAddArray(array);
        return new MemberListWrapper(list);
    }

    @Override
    public IList createJoinList(IList list1, IList list2) {
        IInnerList innerList1 = ((ListWrapper)list1).innerList;
        IInnerList innerList2 = ((ListWrapper)list2).innerList;
        return new ListWrapper(new JoinList(innerList1, innerList2));
    }

    public IList createJoinList(Object[] list1, Object[] list2) {
        IInnerList innerList1 = new ArrayList();
        innerList1 = innerList1.innerAddArray(list1);
        IInnerList innerList2 = new ArrayList();
        innerList2 = innerList2.innerAddArray(list2);
        return new ListWrapper(new JoinList(innerList1, innerList2));
    }

    @Override
    public IList createUnionList(IList list1, IList list2) {
        IInnerList innerList1 = ((ListWrapper)list1).innerList;
        IInnerList innerList2 = ((ListWrapper)list2).innerList;
        return new ListWrapper(new UnionList(innerList1, innerList2));
    }

    public IList createUnionList(Object[] list1, Object[] list2) {
        IInnerList innerList1 = new ArrayList();
        innerList1 = innerList1.innerAddArray(list1);
        IInnerList innerList2 = new ArrayList();
        innerList2 = innerList2.innerAddArray(list2);
        return new ListWrapper(new UnionList(innerList1, innerList2));
    }

    @Override
    public void release() {
    }
}

