/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx;

import com.kingdee.bos.olap.CalculatedMember;
import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.CacheType;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.ExpBase;
import com.kingdee.bos.olap.mdx.ExpResolver;
import com.kingdee.bos.olap.mdx.FunCall;
import com.kingdee.bos.olap.mdx.Literal;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.MemberProperty;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mdx.Set;
import com.kingdee.bos.olap.mem.impl.SetImpl;
import com.kingdee.bos.olap.util.Util;
import java.io.Serializable;

public class Formula
implements Serializable {
    int type;
    String[] names;
    Exp scope;
    Exp exp;
    MemberProperty[] memberProperties;
    Member member;
    Set set;
    CacheType cacheType;

    public Formula(String[] names, Exp exp) {
        this(1, names, exp, new MemberProperty[0], null);
    }

    public Formula(String[] names, Exp exp, MemberProperty[] memberProperties, CacheType cacheType) {
        this(0, names, exp, memberProperties, cacheType);
    }

    public Formula(String[] names, Exp scope, Exp exp, MemberProperty[] memberProperties) {
        this(2, names, exp, memberProperties, null);
        this.scope = scope;
    }

    private Formula(int type, String[] names, Exp exp, MemberProperty[] memberProperties, CacheType cacheType) {
        this.type = type;
        this.names = names;
        this.exp = exp;
        this.cacheType = cacheType;
        this.memberProperties = memberProperties == null ? new MemberProperty[0] : memberProperties;
    }

    public void setExp(Exp exp) {
        this.exp = exp;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public void setMemberProperties(MemberProperty[] memberProperties) {
        this.memberProperties = memberProperties;
    }

    public boolean isMember() {
        return this.type == 0;
    }

    public boolean isSet() {
        return this.type == 1;
    }

    public boolean isCellCalculation() {
        return this.type == 2;
    }

    public Member getMember() {
        return this.member;
    }

    public Set getSet() {
        return this.set;
    }

    public OLAPElement getElement() {
        return this.isMember() ? this.member : this.set;
    }

    public String getUniqeName() {
        String str = "";
        for (int i = 0; i < this.names.length; ++i) {
            if (i > 0) {
                str = str + ".";
            }
            str = str + Util.bracketsAround(this.names[i]);
        }
        return str;
    }

    public String getFirstName() {
        return this.names[0];
    }

    public String getLastName() {
        int n = this.names.length - 1;
        return this.names[n];
    }

    public String toMdx() {
        int i;
        StringBuffer sb = new StringBuffer();
        if (this.isCellCalculation()) {
            sb.append("CELL CALCULATION ");
        } else if (this.isMember()) {
            if (this.cacheType != null) {
                sb.append(this.cacheType.toMdx()).append(" ");
            }
            sb.append("MEMBER ");
        } else {
            sb.append("SET ");
        }
        for (i = 0; i < this.names.length; ++i) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(Util.bracketsAround(this.names[i]));
        }
        if (this.isCellCalculation()) {
            sb.append(" FOR ").append(this.scope.toMdx());
        }
        sb.append(" AS '");
        sb.append(this.exp.toMdx());
        sb.append('\'');
        for (i = 0; i < this.memberProperties.length; ++i) {
            sb.append(',');
            sb.append(this.memberProperties[i].toMdx());
        }
        return sb.toString();
    }

    public Object clone() {
        MemberProperty[] cloneMemberProperties = new MemberProperty[this.memberProperties.length];
        for (int i = 0; i < cloneMemberProperties.length; ++i) {
            cloneMemberProperties[i] = (MemberProperty)this.memberProperties[i].clone();
        }
        Formula clone = new Formula(this.type, this.names, (Exp)this.exp.clone(), cloneMemberProperties, this.cacheType);
        clone.member = this.member;
        clone.set = this.set;
        return clone;
    }

    public Exp getExp() {
        return this.exp;
    }

    public int getSolveOrder() {
        Exp exp = this.getMemberProperty("SOLVE_ORDER");
        return exp != null ? ((Literal)exp).intValue() : 0;
    }

    private String getCaption() {
        Exp exp = this.getMemberProperty("caption");
        return exp != null ? ((Literal)exp).stringValue() : null;
    }

    public Exp getCondition() {
        return this.getMemberProperty("CONDITION");
    }

    public Exp getMemberProperty(String name) {
        return MemberProperty.get(this.memberProperties, name);
    }

    public Exp getMemberProperty(String[] names) {
        return MemberProperty.get(this.memberProperties, names);
    }

    public MemberProperty[] getMemberProperties() {
        return this.memberProperties;
    }

    public Exp resolve(ExpResolver resolver) throws OLAPException {
        int i;
        String id;
        this.exp = (ExpBase)resolver.resolve(this.exp);
        if (this.type == 2) {
            String mdx = this.scope.toMdx();
            this.scope = (ExpBase)resolver.resolve(this.scope);
            if (!this.scope.isSet() && !this.scope.isMember()) {
                throw new OLAPException("Mdx Cell Calculation " + mdx + " is not a Set.");
            }
        } else if (this.isMember()) {
            id = Util.quoteMdxIdentifier(this.names);
            if (!(!this.exp.isSet() || this.exp instanceof FunCall && ((FunCall)this.exp).isCallToTuple())) {
                throw new OLAPException("Mdx Member " + id + " is not a Member but Set.");
            }
        } else {
            id = Util.quoteMdxIdentifier(this.names);
            if (!this.exp.isSet()) {
                throw new OLAPException("Mdx Set " + id + " is not a Set.");
            }
        }
        for (i = 0; i < this.memberProperties.length; ++i) {
            resolver.resolve(this.memberProperties[i]);
        }
        if (this.isMember() && this.member != null) {
            for (i = 0; i < this.memberProperties.length; ++i) {
                Exp exp = this.memberProperties[i].getExp();
                if (exp == null) continue;
                String s = exp instanceof Literal ? ((Literal)exp).stringValue() : exp.toMdx();
                this.member.setProperty(this.memberProperties[i].getName(), s);
            }
        }
        return this.exp;
    }

    public void createElement(MdxQuery q) throws OLAPException {
        if (this.member != null || this.set != null) {
            return;
        }
        if (this.isMember()) {
            OLAPElement mdxElement = q.getCube();
            SchemaReader schemaReader = q.getSchemaReader();
            for (int i = 0; i < this.names.length; ++i) {
                Level level;
                Cube parent = mdxElement;
                if ((mdxElement = schemaReader.getElementChild(parent, this.names[i])) != null) continue;
                Member parentMember = null;
                if (parent instanceof Member) {
                    parentMember = (Member)((Object)parent);
                    level = parentMember.getLevel().getChildLevel();
                } else {
                    Hierarchy hierarchy = parent.getHierarchy();
                    if (hierarchy == null) {
                        throw new OLAPException("Mdx Calculated Hierarchy Error: " + Util.quoteMdxIdentifier(this.names));
                    }
                    level = hierarchy.getLevels()[0];
                }
                Member mdxMember = level.getHierarchy().createMember(parentMember, level, this.names[i], this.getCaption(), this, this.cacheType, false);
                Exp expMemberBefore = this.getMemberProperty("memberBefore");
                Member m2 = null;
                if (expMemberBefore != null) {
                    String uniqueName = ((Literal)expMemberBefore).stringValue();
                    uniqueName = Util.createUName(uniqueName);
                    try {
                        m2 = q.getSchemaReader().getMemberByUniqueName(q.getCube(), uniqueName);
                        if (m2.getDepth() != 0) {
                            m2 = null;
                        }
                    }
                    catch (OLAPException e) {
                        e.printStackTrace();
                    }
                    if (m2 != null) {
                        ((CalculatedMember)mdxMember).setOrdinal2(-0.2 + (double)m2.getOrdinal());
                    }
                } else {
                    Exp expMemberAfter = this.getMemberProperty("memberAfter");
                    if (expMemberAfter != null) {
                        String uniqueName = ((Literal)expMemberAfter).stringValue();
                        uniqueName = Util.createUName(uniqueName);
                        try {
                            m2 = q.getSchemaReader().getMemberByUniqueName(q.getCube(), uniqueName);
                            if (m2.getDepth() != 0) {
                                m2 = null;
                            }
                        }
                        catch (OLAPException oLAPException) {
                            // empty catch block
                        }
                        if (m2 != null) {
                            ((CalculatedMember)mdxMember).setOrdinal2(0.2 + (double)m2.getOrdinal());
                        }
                    }
                }
                mdxElement = mdxMember;
            }
            this.member = (Member)mdxElement;
        } else if (this.type == 1) {
            this.set = new SetImpl(this.names[0], this.exp);
        }
    }
}

