/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.elementexp;

import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.collection.IList;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.SchemaLookup;
import com.kingdee.bos.olap.mdx.elementexp.DimensionExpr;
import com.kingdee.bos.olap.mdx.elementexp.HierarchyExpr;
import com.kingdee.bos.olap.mdx.elementexp.LevelExpr;
import com.kingdee.bos.olap.mdx.elementexp.MemberExpr;
import java.util.Iterator;
import java.util.List;

public class ExprUtil {
    public static Exp toExp(OLAPElement ele) {
        if (ele == null) {
            return null;
        }
        return SchemaLookup.createExpr(ele);
    }

    public static MemberExpr[] toExp(Member[] members) {
        MemberExpr[] exprs = new MemberExpr[members.length];
        for (int i = 0; i < exprs.length; ++i) {
            exprs[i] = new MemberExpr(members[i]);
        }
        return exprs;
    }

    public static MemberExpr[] toExp(List members) {
        MemberExpr[] exprs = new MemberExpr[members.size()];
        for (int i = 0; i < exprs.length; ++i) {
            exprs[i] = new MemberExpr((Member)members.get(i));
        }
        return exprs;
    }

    public static MemberExpr[] toExp(IList members) {
        MemberExpr[] exprs = new MemberExpr[members.size()];
        int i = 0;
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            exprs[i++] = new MemberExpr((Member)iter.next());
        }
        return exprs;
    }

    public static Member toMember(Exp exp) {
        if (exp == null) {
            return null;
        }
        return ((MemberExpr)exp).getMember();
    }

    public static Level toLevel(Exp exp) {
        if (exp == null) {
            return null;
        }
        return ((LevelExpr)exp).getLevel();
    }

    public static Hierarchy toHierarchy(Exp exp) {
        if (exp == null) {
            return null;
        }
        return ((HierarchyExpr)exp).getHierarchy();
    }

    public static Dimension toDimension(Exp exp) {
        if (exp == null) {
            return null;
        }
        return ((DimensionExpr)exp).getDimension();
    }
}

