/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.func;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.ExpResolver;
import com.kingdee.bos.olap.mdx.FunCall;
import com.kingdee.bos.olap.mdx.FunDefBase;
import com.kingdee.bos.olap.mdx.FuncResolver;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.DummyExp;
import com.kingdee.bos.olap.mdx.calc.ExpCompiler;
import com.kingdee.bos.olap.mdx.calc.ListCalc;
import com.kingdee.bos.olap.mdx.calc.impl.func.CrossjoinCalc;
import com.kingdee.bos.olap.mdx.calc.impl.func.SetCalc;
import com.kingdee.bos.olap.mdx.type.SetType;
import com.kingdee.bos.olap.mdx.type.TupleType;
import com.kingdee.bos.olap.mdx.type.Type;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class CrossJoinFunDef
extends FunDefBase {
    private static Logger logger = CommonLogger.getLogger(CrossJoinFunDef.class);

    public CrossJoinFunDef(FuncResolver resolver, int returnType, int[] parameterTypes) {
        super(resolver, returnType, parameterTypes);
    }

    @Override
    public Type getResultType(ExpResolver resolver, Exp[] args) throws OLAPException {
        ArrayList list = new ArrayList();
        for (int i = 0; i < args.length; ++i) {
            Exp arg = args[i];
            Type type = arg.getType();
            if (type instanceof SetType) {
                SetType setType = (SetType)type;
                CrossJoinFunDef.addTypes(setType.getElementType(), list);
                continue;
            }
            if (this.getName().equals("*")) {
                CrossJoinFunDef.addTypes(type, list);
                continue;
            }
            throw new OLAPException("arg to crossjoin must be a set");
        }
        Type[] types = list.toArray(new Type[list.size()]);
        TupleType tupleType = new TupleType(types);
        return new SetType(tupleType);
    }

    private static void addTypes(Type type, ArrayList list) {
        if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            for (int i = 0; i < tupleType.elementTypes.length; ++i) {
                CrossJoinFunDef.addTypes(tupleType.elementTypes[i], list);
            }
        } else {
            list.add(type);
        }
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OLAPException {
        ListCalc listCalc1 = this.toListCalc(compiler, call.getArg(0));
        ListCalc listCalc2 = this.toListCalc(compiler, call.getArg(1));
        return new CrossjoinCalc((Exp)call, listCalc1, listCalc2);
    }

    private ListCalc toListCalc(ExpCompiler compiler, Exp exp) throws OLAPException {
        Type type = exp.getType();
        if (type instanceof SetType) {
            return compiler.compileList(exp);
        }
        return new SetCalc(new DummyExp(new SetType(type)), new Exp[]{exp}, compiler);
    }
}

