/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.func;

import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.Property;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.FunCall;
import com.kingdee.bos.olap.mdx.FunDef;
import com.kingdee.bos.olap.mdx.FunDefBase;
import com.kingdee.bos.olap.mdx.FuncResolverBase;
import com.kingdee.bos.olap.mdx.Literal;
import com.kingdee.bos.olap.mdx.Syntax;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.ExpCompiler;
import com.kingdee.bos.olap.mdx.calc.MemberCalc;
import com.kingdee.bos.olap.mdx.calc.StringCalc;
import com.kingdee.bos.olap.mdx.calc.impl.GenericCalc;
import com.kingdee.bos.olap.util.IntHolder;

class PropertiesFunDef
extends FunDefBase {
    public PropertiesFunDef(String name, String description, Syntax syntax, int returnType, int[] parameterTypes) {
        super(name, description, syntax, returnType, parameterTypes);
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OLAPException {
        final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        final StringCalc stringCalc = compiler.compileString(call.getArg(1));
        return new GenericCalc(call){

            @Override
            public Calc[] getCalcs() {
                return new Calc[]{memberCalc, stringCalc};
            }

            @Override
            public Object evaluate(Evaluator evaluator) throws OLAPException {
                String s;
                Member member = memberCalc.evaluateMember(evaluator);
                Object o = member.getProperty(s = stringCalc.evaluateString(evaluator));
                if (o == null) {
                    return null;
                }
                if (o instanceof Number || o instanceof Boolean || o instanceof String) {
                    return o;
                }
                return o.toString();
            }
        };
    }

    private static Property lookupProperty(Level level, String propertyName) {
        do {
            Property[] properties;
            if ((properties = level.getMemberProperties()) == null) {
                return null;
            }
            for (int i = 0; i < properties.length; ++i) {
                Property property = properties[i];
                if (!property.getName().equals(propertyName)) continue;
                return property;
            }
        } while ((level = level.getParentLevel()) != null);
        return null;
    }

    static class Resolver
    extends FuncResolverBase {
        Resolver() {
            super("Properties", "<Member>.Properties(<String Expression>)", "Returns the value of a member property.", Syntax.Method);
        }

        @Override
        public FunDef resolve(Exp[] args, IntHolder conversionCount) {
            int[] argTypes = new int[]{6, 9};
            if (args.length != 2 || args[0].getCategory() != 6 || args[1].getCategory() != 9) {
                return null;
            }
            int returnType = 9;
            if (args[1] instanceof Literal) {
                String dataType;
                String propertyName = ((Literal)args[1]).stringValue();
                Hierarchy hierarchy = args[0].getType().getHierarchy();
                Level[] levels = hierarchy.getLevels();
                Property property = PropertiesFunDef.lookupProperty(levels[levels.length - 1], propertyName);
                returnType = property == null ? 13 : ((dataType = (String)property.getProperty("dataType")) == null ? 9 : (dataType.equals("BOOLEAN") ? 5 : (dataType.equalsIgnoreCase("NUMERIC") ? 7 : (dataType.equalsIgnoreCase("STRING") ? 9 : 9))));
            } else {
                returnType = 13;
            }
            return new PropertiesFunDef(this.getName(), this.getDescription(), this.getSyntax(), returnType, argTypes);
        }

        @Override
        public boolean requireScalarExpression(int k) {
            return true;
        }
    }
}

