/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.func;

import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.ExpResolver;
import com.kingdee.bos.olap.mdx.FunCall;
import com.kingdee.bos.olap.mdx.FunDef;
import com.kingdee.bos.olap.mdx.FunDefBase;
import com.kingdee.bos.olap.mdx.FuncResolver;
import com.kingdee.bos.olap.mdx.FunctionException;
import com.kingdee.bos.olap.mdx.MultiFuncResolver;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.ExpCompiler;
import com.kingdee.bos.olap.mdx.calc.MemberCalc;
import com.kingdee.bos.olap.mdx.calc.impl.func.XtdCalc;
import com.kingdee.bos.olap.mdx.func.FuncUtil2;
import com.kingdee.bos.olap.mdx.type.MemberType;
import com.kingdee.bos.olap.mdx.type.SetType;
import com.kingdee.bos.olap.mdx.type.Type;

class XtdFunDef
extends FunDefBase {
    private final byte levelType;

    public XtdFunDef(FuncResolver resolver, int returnType, int[] parameterTypes, byte levelType) {
        super(resolver, returnType, parameterTypes);
        this.levelType = levelType;
    }

    @Override
    public Type getResultType(ExpResolver resolver, Exp[] args) throws OLAPException {
        if (args.length == 0) {
            Hierarchy hierarchy = resolver.getQuery().getCube().getTimeDimension().getHierarchy();
            return new SetType(new MemberType(hierarchy, null, null));
        }
        Type type = args[0].getType();
        if (!type.getHierarchy().getDimension().isTimeDimension()) {
            throw new FunctionException("Funciton '" + this.getName() + "' need Time Dimension.");
        }
        return super.getResultType(resolver, args);
    }

    private Level getLevel(Cube cube) {
        switch (this.levelType) {
            case 2: {
                return FuncUtil2.getTimeLevel(cube, (byte)2);
            }
            case 3: {
                return FuncUtil2.getTimeLevel(cube, (byte)3);
            }
            case 4: {
                return FuncUtil2.getTimeLevel(cube, (byte)4);
            }
            case 5: {
                return FuncUtil2.getTimeLevel(cube, (byte)5);
            }
            case 6: {
                return FuncUtil2.getTimeLevel(cube, (byte)5);
            }
        }
        return null;
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OLAPException {
        Level level = this.getLevel(compiler.getResolver().getQuery().getCube());
        MemberCalc memberCalc = null;
        if (call.getArgCount() > 0) {
            memberCalc = compiler.compileMember(call.getArg(0));
        }
        return new XtdCalc(call, level, memberCalc);
    }

    public static class Resolver
    extends MultiFuncResolver {
        private final byte levelType;

        public Resolver(String name, String signature, String description, String[] signatures, byte levelType) {
            super(name, signature, description, signatures);
            this.levelType = levelType;
        }

        @Override
        protected FunDef createFunDef(Exp[] args, int returnType, int[] parameterTypes) {
            return new XtdFunDef(this, returnType, parameterTypes, this.levelType);
        }
    }
}

