/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem.impl;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.base.Key;
import com.kingdee.bos.olap.dbsource.Table;
import com.kingdee.bos.olap.def.HierarchyDef;
import com.kingdee.bos.olap.def.SharedDimensionDef;
import com.kingdee.bos.olap.mem.impl.BuildContext;
import com.kingdee.bos.olap.mem.impl.DimensionBuildResult;
import com.kingdee.bos.olap.mem.impl.DimensionImpl;
import com.kingdee.bos.olap.mem.impl.HierarchyFetch;
import com.kingdee.bos.olap.mem.impl.HierarchyImpl;
import com.kingdee.bos.olap.mem.impl.MemberImpl;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class DimensionBuilder {
    private static Logger logger = CommonLogger.getLogger(DimensionBuilder.class);

    public static void buildSharedDimension(BuildContext buildContext, DimensionImpl dim, SharedDimensionDef dimDef) throws OLAPException, SQLException {
        int i;
        logger.debug((Object)("building shared dimension '" + dimDef.name + "'..."));
        int errorRows = 0;
        Table table = buildContext.getTableManager().getTable(dimDef.table);
        int hc = dimDef.hierarchies.length;
        HierarchyFetch[] hfs = new HierarchyFetch[hc];
        Key primaryKey = new Key(table, dimDef.primaryKey);
        DimensionBuildResult dbr = new DimensionBuildResult(dim);
        for (i = 0; i < hc; ++i) {
            HierarchyDef hieDef = dimDef.hierarchies[i];
            HierarchyImpl hie = dim.hies[i];
            hfs[i] = new HierarchyFetch(hieDef, hie);
        }
        while (table.next()) {
            for (i = 0; i < hc; ++i) {
                MemberImpl member = hfs[i].fetch(table);
                Object key = primaryKey.getCurrentValue();
                if (key == null) {
                    ++errorRows;
                    continue;
                }
                dbr.getHierarchyBuildResult(i).put(key, member);
            }
        }
        table.close();
        buildContext.getTableManager().releaseTable(dimDef.table);
        int globalOrder = 0;
        for (int i2 = 0; i2 < hc; ++i2) {
            hfs[i2].globalOrder = globalOrder;
            hfs[i2].finish();
            globalOrder = hfs[i2].globalOrder;
        }
        dim.memberCount = globalOrder;
        if (errorRows > 0) {
            logger.info((Object)("Found " + errorRows + " error rows when building shared dimension '" + dimDef.name + "'..."));
        }
        buildContext.setDimensionResult(dim.getName(), dbr);
    }
}

