/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem.impl;

import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.base.OLAPElementBase;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mdx.type.DimensionType;
import com.kingdee.bos.olap.mdx.type.Type;
import com.kingdee.bos.olap.mem.OLAPEngine;
import com.kingdee.bos.olap.mem.impl.HierarchyImpl;
import com.kingdee.bos.olap.util.Util;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DimensionImpl
extends OLAPElementBase
implements Dimension {
    public static final long serialVersionUID = 456721298477547547L;
    HierarchyImpl[] hies;
    byte dimensionType = 0;
    int memberCount;
    Map mapOrderToMember = new HashMap();
    private transient String uniqueName;
    boolean isParentChildren = false;

    @Override
    public Hierarchy[] getHierarchies() {
        return this.hies;
    }

    @Override
    public Hierarchy getHierarchy(String name) {
        for (int i = 0; i < this.hies.length; ++i) {
            if (!this.hies[i].getName().equalsIgnoreCase(name)) continue;
            return this.hies[i];
        }
        return null;
    }

    @Override
    public OLAPElement lookupChild(SchemaReader schemaReader, String name) throws OLAPException {
        Hierarchy hie = this.getHierarchy(name);
        if (hie != null) {
            return hie;
        }
        return this.getDefaultHierarchy().lookupChild(schemaReader, name);
    }

    @Override
    public Hierarchy getDefaultHierarchy() {
        if (this.hies == null || this.hies.length == 0) {
            return null;
        }
        return this.hies[0];
    }

    @Override
    public byte getDimensionType() {
        return this.dimensionType;
    }

    @Override
    public int getOrdinal(Cube cube) throws OLAPException {
        return cube.getDimensionOrdinal(this.name);
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public Member getMember(int globalOrder) {
        Object o = this.mapOrderToMember.get(new Integer(globalOrder));
        if (o == null) {
            return null;
        }
        return (Member)o;
    }

    public Type getExpType() {
        return new DimensionType(this);
    }

    public int getCategory() {
        return 2;
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = Util.makeFqName(this.getName());
        }
        return this.uniqueName;
    }

    @Override
    public boolean isMeasureDimension() {
        return this.dimensionType == -1;
    }

    @Override
    public boolean isTimeDimension() {
        return this.dimensionType == 1;
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.getDefaultHierarchy();
    }

    @Override
    public Dimension getDimension() {
        return this;
    }

    @Override
    public String getCaption() {
        if (this.caption != null) {
            return this.caption;
        }
        if (this.isMeasureDimension()) {
            return OLAPEngine.getResource(Locale.getDefault(), "measureDimensionCaption");
        }
        return super.getCaption();
    }

    @Override
    public boolean isParentChildrenDimension() {
        return this.isParentChildren;
    }
}

