/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem.impl;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.InnerMemberFactory;
import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.base.OLAPElementBase;
import com.kingdee.bos.olap.collection.DefaultListFactory;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.mdx.CacheType;
import com.kingdee.bos.olap.mdx.Formula;
import com.kingdee.bos.olap.mdx.SchemaLookup;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mdx.type.HierarchyType;
import com.kingdee.bos.olap.mdx.type.Type;
import com.kingdee.bos.olap.mem.OLAPEngine;
import com.kingdee.bos.olap.mem.impl.CalculatedMemberImpl;
import com.kingdee.bos.olap.mem.impl.DimensionImpl;
import com.kingdee.bos.olap.mem.impl.InnerMemberFactoryImpl;
import com.kingdee.bos.olap.mem.impl.LevelImpl;
import com.kingdee.bos.olap.mem.impl.MemberImpl;
import com.kingdee.bos.olap.util.Util;
import com.kingdee.bos.olap.util.Walker;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class HierarchyImpl
extends OLAPElementBase
implements Hierarchy {
    public static final long serialVersionUID = 3214563898477547547L;
    static final Logger logger = CommonLogger.getLogger(HierarchyImpl.class);
    DimensionImpl dim;
    LevelImpl[] levels;
    MemberImpl[] members;
    int memberCount;
    int depth;
    int ordinal = -1;
    String subName;
    String subCaption;
    String uniqueName;
    private Member defaultMember;
    private MemberImpl nullMember;
    private transient HashMap innerMembers = null;
    private transient LevelImpl innerLevel;
    private transient String allMemberName;
    private transient String allMemberCaption;

    public HierarchyImpl(DimensionImpl dim, String subName, String subCaption) {
        this.dim = dim;
        this.subName = subName;
        this.subCaption = subCaption;
        this.name = dim.getName();
        if (this.subName != null) {
            this.name = this.name + "." + subName;
            this.uniqueName = Util.makeFqName(this.name);
        } else {
            this.uniqueName = dim.getUniqueName();
        }
        this.caption = dim.getCaption();
        if (this.subCaption != null) {
            this.caption = this.caption + "." + subCaption;
        }
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public Dimension getDimension() {
        return this.dim;
    }

    @Override
    public Level[] getLevels() {
        return this.levels;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public boolean hasAll() {
        return (Boolean)this.getProperty("hasAll", Boolean.TRUE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Member getDefaultMember() {
        if (this.defaultMember != null) return this.defaultMember;
        if (this.hasAll() || this.getDimension().isMeasureDimension()) {
            MemberImpl[] ms = this.members;
            if (ms == null || ms.length <= 0) return null;
            this.defaultMember = ms[0];
            return this.defaultMember;
        } else {
            this.defaultMember = this.getInnerAllMember();
        }
        return this.defaultMember;
    }

    @Override
    public IMemberList getMembers() {
        return DefaultListFactory.instance.createMemberList(this.members);
    }

    public Type getExpType() {
        return new HierarchyType(this);
    }

    public int getCategory() {
        return 3;
    }

    @Override
    public Member getNullMember() {
        if (this.nullMember == null) {
            this.nullMember = new MemberImpl();
            this.nullMember.memberType = (byte)16;
            this.nullMember.level = this.levels[0];
            this.nullMember.setName("#NULL");
        }
        return this.nullMember;
    }

    public LevelImpl lookupLevel(String name) {
        if (name == null) {
            return null;
        }
        if (this.innerLevel != null && this.innerLevel.getName().equalsIgnoreCase(name)) {
            return this.innerLevel;
        }
        for (int i = 0; i < this.levels.length; ++i) {
            if (!name.equalsIgnoreCase(this.levels[i].getName())) continue;
            return this.levels[i];
        }
        return null;
    }

    private Map getInnerMembers() {
        if (this.innerMembers == null) {
            this.innerMembers = new HashMap(2, 1.0f);
        }
        return this.innerMembers;
    }

    public LevelImpl getInnerLevel() {
        if (this.innerLevel == null) {
            this.innerLevel = InnerMemberFactoryImpl.createInnerLevel(this);
        }
        return this.innerLevel;
    }

    @Override
    public OLAPElement lookupChild(SchemaReader schemaReader, String name) throws OLAPException {
        LevelImpl r = this.lookupLevel(name);
        if (r != null) {
            return r;
        }
        return this.lookupMember(schemaReader, name);
    }

    @Override
    public Member getInnerAllMember() {
        return this.lookupInnerMember("V$All");
    }

    public Member lookupInnerMember(String name) {
        Map map = this.getInnerMembers();
        Object member = map.get(name.toUpperCase());
        if (member == null) {
            member = InnerMemberFactoryImpl.createInnerMember(this, name);
            map.put(name.toUpperCase(), member);
        }
        return (Member)member;
    }

    public OLAPElement lookupMember(SchemaReader schemaReader, String name) throws OLAPException {
        if (InnerMemberFactory.exists(name)) {
            return this.lookupInnerMember(name);
        }
        return SchemaLookup.lookupHierarchyRootMember(schemaReader, this, name);
    }

    public Member lookupLeafMember(SchemaReader schemaReader, String name) throws OLAPException {
        return SchemaLookup.lookupHierarchyLeafMember(schemaReader, this, name);
    }

    public IMemberList getLevelMembers(LevelImpl level) {
        IMemberList list = DefaultListFactory.instance.createMemberList();
        Walker walker = new Walker(this);
        while (walker.hasMoreElements()) {
            Object element = walker.nextElement();
            if (!(element instanceof MemberImpl)) continue;
            MemberImpl member = (MemberImpl)element;
            if (member.level != level) continue;
            list.add(member);
            walker.prune();
        }
        return list;
    }

    public MemberImpl lookLevelMember(LevelImpl level, String name) {
        Walker walker = new Walker(this);
        while (walker.hasMoreElements()) {
            MemberImpl member = (MemberImpl)walker.nextElement();
            if (member.level != level) continue;
            if (member.getName().equals(name)) {
                return member;
            }
            walker.prune();
        }
        return null;
    }

    @Override
    public Object[] getChildren() {
        return this.members;
    }

    @Override
    public String getAllMemberName() {
        if (this.allMemberName == null) {
            this.allMemberName = "All " + this.getName();
        }
        return this.allMemberName;
    }

    @Override
    public String getAllMemberCaption() {
        if (this.allMemberCaption == null) {
            this.allMemberCaption = OLAPEngine.getResource(Locale.getDefault(), "allMemberCaptionPrefix") + this.getCaption();
        }
        return this.allMemberCaption;
    }

    @Override
    public String getCaption() {
        if (this.dim.isMeasureDimension()) {
            return this.dim.getCaption();
        }
        return super.getCaption();
    }

    @Override
    public Hierarchy getHierarchy() {
        return this;
    }

    @Override
    public Member createMember(String name, String caption, Formula formula, boolean calculatedInSchema) {
        return this.createMember(null, this.levels[0], name, caption, formula, null, calculatedInSchema);
    }

    @Override
    public Member createMember(Member parent, Level level, String name, String caption, Formula formula, CacheType cacheType, boolean calculatedInSchema) {
        return new CalculatedMemberImpl(parent, level, name, caption, formula, cacheType, calculatedInSchema);
    }

    @Override
    public boolean isAggregate() {
        return true;
    }

    @Override
    public Member createSlicerCompoundMember(int index, Member[] members) {
        return null;
    }

    @Override
    public String getSubName() {
        return this.subName;
    }
}

