/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem.impl;

import com.kingdee.bos.olap.Axis;
import com.kingdee.bos.olap.Cell;
import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Formatter;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.Position;
import com.kingdee.bos.olap.Query;
import com.kingdee.bos.olap.Result;
import com.kingdee.bos.olap.base.CellImpl;
import com.kingdee.bos.olap.mem.CubeData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ResultImpl
implements Result,
Serializable {
    private int[][] dimIndexs;
    private Query query;
    private Axis[] axes;
    private Cube cube;
    private CubeData data;
    private Member[] point;
    private Member[] measures;
    private Formatter[] fs;
    private transient HashMap cells = null;
    private transient Map pinCache = null;

    public ResultImpl(CubeData _data, Query _query) throws OLAPException {
        this(_data, _query, new HashMap());
    }

    public ResultImpl(CubeData _data, Query _query, Map pinCache) throws OLAPException {
        int i;
        this.pinCache = pinCache;
        this.data = _data;
        this.query = _query;
        this.cube = this.data.cube;
        Axis[] axis0 = this.query.getAxes();
        if (axis0 == null || axis0.length == 0) {
            throw new OLAPException("no axis defined.");
        }
        if (axis0.length > 2) {
            throw new OLAPException("Query must has one axis or two.");
        }
        this.axes = new _Axis[axis0.length];
        for (int i2 = 0; i2 < this.axes.length; ++i2) {
            this.axes[i2] = new _Axis(axis0[i2]);
        }
        Dimension[] dims = this.cube.getDimensions();
        boolean[] dimUsages = new boolean[dims.length];
        this.dimIndexs = new int[this.axes.length][];
        boolean measureUsaged = false;
        for (int i3 = 0; i3 < this.axes.length; ++i3) {
            Hierarchy[] hies = this.axes[i3].hierarchies();
            this.dimIndexs[i3] = new int[hies.length];
            for (int j = 0; j < hies.length; ++j) {
                int index;
                String dimName = hies[j].getDimension().getName();
                this.dimIndexs[i3][j] = index = this.cube.getDimensionOrdinal(dimName);
                if (index != -1) {
                    if (dimUsages[index]) {
                        throw new OLAPException("Dimension '" + dimName + "' reused in axes.");
                    }
                    dimUsages[index] = true;
                    continue;
                }
                if (measureUsaged) {
                    throw new OLAPException("Measure dimension usage in more than one Axis.");
                }
                measureUsaged = true;
            }
        }
        this.point = new Member[dims.length + 1];
        Member[] slicers = this.query.getSliceMembers();
        if (slicers == null) {
            slicers = new Member[]{};
        }
        for (i = 0; i < slicers.length; ++i) {
            String dimName = slicers[i].getDimension().getName();
            int mIndex = this.cube.getDimensionOrdinal(dimName);
            if (mIndex != -1 && dimUsages[mIndex]) {
                throw new OLAPException("Dimension '" + dimName + "' reused in axes and slicers.");
            }
            if (this.point[mIndex + 1] != null) {
                throw new OLAPException("Dimension '" + dimName + "' reused in slicers.");
            }
            this.point[mIndex + 1] = slicers[i];
        }
        for (i = 0; i < this.point.length; ++i) {
            if (this.point[i] != null) continue;
            this.point[i] = i == 0 ? ResultImpl.getDefaultMember(this.cube.getMeasureDimension()) : ResultImpl.getDefaultMember(dims[i - 1]);
        }
        this.measures = this.cube.getMeasures();
        this.fs = new Formatter[this.measures.length];
        for (i = 0; i < this.measures.length; ++i) {
            String fmtStr = (String)this.measures[i].getProperty("formatString");
            if (fmtStr == null) continue;
            this.fs[i] = new Formatter(fmtStr);
        }
        this.removeEmpty();
    }

    private void removeEmpty() throws OLAPException {
        int axiscount = this.axes.length;
        Position[] rp0 = null;
        Position[] rp1 = null;
        if (axiscount == 1) {
            _Axis axis = (_Axis)this.axes[0];
            if (axis.removeEmpty()) {
                Position[] poses = axis.positions();
                ArrayList<Position> listPos = new ArrayList<Position>(poses.length / 4);
                for (int j = 0; j < poses.length; ++j) {
                    Cell cell = this.getCell(new int[]{j});
                    if (cell.isNull()) continue;
                    listPos.add(poses[j]);
                }
                rp0 = new Position[listPos.size()];
                listPos.toArray(rp0);
            }
            axis.poses = rp0;
        } else if (axiscount == 2) {
            Cell cell;
            int k;
            boolean isnull;
            int j;
            ArrayList<Position> listPos;
            _Axis axis = (_Axis)this.axes[0];
            _Axis axis1 = (_Axis)this.axes[1];
            Position[] poses = axis.positions();
            Position[] poses1 = axis1.positions();
            if (axis.removeEmpty()) {
                listPos = new ArrayList<Position>(poses.length / 4);
                for (j = 0; j < poses.length; ++j) {
                    isnull = true;
                    k = 0;
                    while (k < poses1.length) {
                        if ((cell = this.getCell(new int[]{j, k++}, false)).isNull()) continue;
                        isnull = false;
                        break;
                    }
                    if (isnull) continue;
                    listPos.add(poses[j]);
                }
                rp0 = new Position[listPos.size()];
                listPos.toArray(rp0);
            }
            if (axis1.removeEmpty()) {
                listPos = new ArrayList(poses1.length / 4);
                for (j = 0; j < poses1.length; ++j) {
                    isnull = true;
                    k = 0;
                    while (k < poses.length) {
                        if ((cell = this.getCell(new int[]{k++, j}, false)).isNull()) continue;
                        isnull = false;
                        break;
                    }
                    if (isnull) continue;
                    listPos.add(poses1[j]);
                }
                rp1 = new Position[listPos.size()];
                listPos.toArray(rp1);
            }
            if (axis.removeEmpty() && rp0 != null && axis.poses.length != rp0.length) {
                axis.poses = rp0;
                if (this.cells != null) {
                    this.cells.clear();
                }
            }
            if (axis1.removeEmpty() && rp1 != null && axis1.poses.length != rp1.length) {
                axis1.poses = rp1;
                if (this.cells != null) {
                    this.cells.clear();
                }
            }
        }
    }

    private static Member getDefaultMember(Dimension dim) {
        Member member = dim.getDefaultHierarchy().getDefaultMember();
        return member;
    }

    @Override
    public Axis[] getAxes() {
        return this.axes;
    }

    @Override
    public Cell getCell(int[] pos) throws OLAPException {
        return this.getCell(pos, true);
    }

    private Cell getCell(int[] pos, boolean cache) throws OLAPException {
        _CellKey key;
        Cell cell;
        if (this.cells == null) {
            this.cells = new HashMap();
        }
        if ((cell = (Cell)this.cells.get(key = new _CellKey(pos))) != null) {
            return cell;
        }
        Member measure = this.point[0];
        Member[] p = new Member[this.point.length - 1];
        System.arraycopy(this.point, 1, p, 0, p.length);
        for (int i = 0; i < pos.length; ++i) {
            int[] indexs = this.dimIndexs[i];
            Member[] ms = this.axes[i].positions()[pos[i]].members();
            for (int j = 0; j < indexs.length; ++j) {
                if (indexs[j] == -1) {
                    measure = ms[j];
                    continue;
                }
                p[indexs[j]] = ms[j];
            }
        }
        int measureIndex = -1;
        for (int i = 0; i < this.measures.length; ++i) {
            if (!this.measures[i].getName().equals(measure.getName())) continue;
            measureIndex = i;
            break;
        }
        if (measureIndex == -1) {
            throw new OLAPException("Member '" + measure.getName() + "' not found.");
        }
        Object[] values = this.data.getData(p, this.pinCache);
        if (values == null) {
            CellImpl nullCell = new CellImpl(p);
            if (cache) {
                this.cells.put(key, nullCell);
            }
            return nullCell;
        }
        cell = new CellImpl(p, values[measureIndex], this.fs[measureIndex]);
        if (cache) {
            this.cells.put(key, cell);
        }
        return cell;
    }

    @Override
    public Cell getCell(int x, int y) throws OLAPException {
        int[] pos = new int[]{x, y};
        return this.getCell(pos);
    }

    @Override
    public Cell getCell(int x, int y, int z) throws OLAPException {
        int[] pos = new int[]{x, y, z};
        return this.getCell(pos);
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    static class _CellKey {
        int[] pos;
        int h = 0;

        _CellKey(int[] _pos) {
            this.pos = _pos;
            for (int i = 0; i < this.pos.length; ++i) {
                this.h = this.h + (this.h << 5) + this.pos[i];
            }
        }

        public int hashCode() {
            return this.h;
        }

        public boolean equals(Object x) {
            int[] pos1 = ((_CellKey)x).pos;
            if (this.pos.length != pos1.length) {
                return false;
            }
            for (int i = 0; i < this.pos.length; ++i) {
                if (this.pos[i] == pos1[i]) continue;
                return false;
            }
            return true;
        }
    }

    class _Position
    implements Position,
    Serializable {
        Member[] ms;
        _Axis axis;

        _Position(_Axis _axis, Position pos) throws OLAPException {
            this.axis = _axis;
            this.ms = pos.members();
        }

        @Override
        public Member[] members() {
            return this.ms;
        }
    }

    class _Axis
    implements Axis,
    Serializable {
        Position[] poses;
        String name;
        Hierarchy[] hies;
        boolean removeEmpty;

        _Axis(Axis axis) throws OLAPException {
            this.name = axis.getName();
            this.hies = axis.hierarchies();
            this.removeEmpty = axis.removeEmpty();
            Position[] poses1 = axis.positions();
            this.poses = new _Position[poses1.length];
            for (int i = 0; i < this.poses.length; ++i) {
                this.poses[i] = new _Position(this, poses1[i]);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Position[] positions() {
            return this.poses;
        }

        @Override
        public Hierarchy[] hierarchies() {
            return this.hies;
        }

        @Override
        public boolean removeEmpty() {
            return this.removeEmpty;
        }
    }
}

