/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem.storage;

import com.kingdee.bos.olap.mem.storage.BucketStorageManager;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Bucket {
    public int id;
    private int bucketSize;
    private int pageSize;
    private RandomAccessFile dataFile;
    public int[] pages;
    private byte[] buffer;
    private boolean isnew;
    private boolean[] dirty;
    private boolean[] readed;
    private int currentPosition = 4;
    private int usedSize = 0;

    public Bucket(BucketStorageManager bsm, boolean isnew) {
        this.bucketSize = bsm.bucketSize;
        this.pageSize = bsm.pageSize;
        this.dataFile = bsm.dataFile;
        this.isnew = isnew;
        this.pages = new int[this.bucketSize];
        this.dirty = new boolean[this.bucketSize];
        this.readed = new boolean[this.bucketSize];
        this.currentPosition = 4;
        this.buffer = new byte[this.bucketSize * this.pageSize];
    }

    private int getUsedPageCount() {
        int p = this.usedSize / this.pageSize;
        int offset = this.usedSize % this.pageSize;
        if (offset > 0) {
            return p + 1;
        }
        return p;
    }

    private int getPageIndex(int position) {
        return position / this.pageSize;
    }

    public void readFully() throws IOException {
        int i;
        if (this.buffer == null) {
            this.buffer = new byte[this.bucketSize * this.pageSize];
        }
        if (this.isnew) {
            this.usedSize = 0;
        } else {
            this.usedSize = this.readInt(0);
            int usedPage = (this.usedSize + 4) / this.pageSize;
            for (i = 0; i < usedPage; ++i) {
                this.readPage(i);
            }
            int len = (this.usedSize + 4) % this.pageSize;
            if (len > 0) {
                this.readPage(usedPage, 0, len);
            }
            this.currentPosition = 4;
        }
        int up = this.getUsedPageCount();
        for (i = 0; i < up; ++i) {
            this.readed[i] = true;
        }
    }

    public byte[] toByteArray() {
        byte[] bs = new byte[this.usedSize];
        System.arraycopy(this.buffer, 4, bs, 0, this.usedSize);
        return bs;
    }

    public void seekStart() {
        this.currentPosition = 4;
    }

    public void seek(int pos) {
        this.currentPosition = pos + 4;
    }

    public void skip(int len) throws IOException {
        if (this.currentPosition + len > this.length()) {
            throw new EOFException();
        }
        this.currentPosition += len;
    }

    public int length() {
        return this.usedSize + 4;
    }

    public int available() {
        int available = this.usedSize + 4 - this.currentPosition;
        return available;
    }

    public void flush() throws IOException {
        if (!this.dirty[0]) {
            this.writePage(0, 0, 4);
        }
        int usedPage = (this.usedSize + 4) / this.pageSize;
        int residue = (this.usedSize + 4) % this.pageSize;
        for (int i = 0; i < usedPage; ++i) {
            if (!this.dirty[i]) continue;
            this.writePage(i);
            this.dirty[i] = false;
        }
        if (residue > 0 && this.dirty[usedPage]) {
            this.writePage(usedPage, 0, residue);
            this.dirty[usedPage] = false;
        }
    }

    public void close() throws IOException {
        boolean hasDirty = false;
        for (int i = 0; i < this.dirty.length; ++i) {
            if (!this.dirty[i]) continue;
            hasDirty = true;
            break;
        }
        if (hasDirty) {
            this.flush();
        }
    }

    private void writeUsedSize() {
        this.buffer[0] = (byte)(this.usedSize >>> 24);
        this.buffer[1] = (byte)(this.usedSize >>> 16);
        this.buffer[2] = (byte)(this.usedSize >>> 8);
        this.buffer[3] = (byte)this.usedSize;
    }

    public void writeByte(byte b) throws IOException {
        if (this.currentPosition + 1 > this.buffer.length) {
            throw new EOFException("Fail writing,over bucket size.");
        }
        int pageIndex = this.getPageIndex(this.currentPosition);
        if (!this.isnew && !this.readed[pageIndex]) {
            this.readPage(pageIndex);
        }
        if (this.currentPosition + 1 > this.length()) {
            this.usedSize = this.currentPosition + 1 - 4;
            this.writeUsedSize();
        }
        this.dirty[pageIndex] = true;
        this.buffer[this.currentPosition++] = b;
    }

    public void writeBytes(byte[] bs) throws IOException {
        this.writeBytes(bs, 0, bs.length);
    }

    public void writeBytes(byte[] bs, int offset, int len) throws IOException {
        if (this.currentPosition + len > this.buffer.length) {
            throw new EOFException("Fail writing,over bucket size.");
        }
        int pageIndex = this.getPageIndex(this.currentPosition);
        int pageIndex2 = this.getPageIndex(this.currentPosition + len - 1);
        for (int i = pageIndex; i <= pageIndex2; ++i) {
            if (!this.isnew && !this.readed[i]) {
                this.readPage(pageIndex);
            }
            this.dirty[i] = true;
        }
        if (this.currentPosition + len > this.length()) {
            this.usedSize = this.currentPosition + len - 4;
            this.writeUsedSize();
        }
        System.arraycopy(bs, offset, this.buffer, this.currentPosition, len);
        this.currentPosition += len;
    }

    public void writeInt(int v) throws IOException {
        if (this.currentPosition + 4 > this.buffer.length) {
            throw new EOFException("Fail writing,over bucket size.");
        }
        int pageIndex = this.getPageIndex(this.currentPosition);
        if (!this.isnew && !this.readed[pageIndex]) {
            this.readPage(pageIndex);
        }
        this.dirty[pageIndex] = true;
        int pageIndex2 = this.getPageIndex(this.currentPosition + 4 - 1);
        if (pageIndex2 > pageIndex) {
            if (!this.isnew && !this.readed[pageIndex2]) {
                this.readPage(pageIndex2);
            }
            this.dirty[pageIndex2] = true;
        }
        if (this.currentPosition + 4 > this.length()) {
            this.usedSize = this.currentPosition + 4 - 4;
            this.writeUsedSize();
        }
        this.buffer[this.currentPosition++] = (byte)(v >>> 24);
        this.buffer[this.currentPosition++] = (byte)(v >>> 16);
        this.buffer[this.currentPosition++] = (byte)(v >>> 8);
        this.buffer[this.currentPosition++] = (byte)v;
    }

    public byte readByte() throws IOException {
        if (this.currentPosition > this.length()) {
            throw new EOFException();
        }
        int pageIndex = this.getPageIndex(this.currentPosition);
        if (!this.isnew && !this.readed[pageIndex]) {
            this.readPage(pageIndex);
        }
        return this.buffer[this.currentPosition++];
    }

    public byte[] readBytes(int len) throws IOException {
        int pageIndex2;
        if (this.currentPosition + len > this.length()) {
            throw new EOFException();
        }
        int pageIndex = this.getPageIndex(this.currentPosition);
        if (!this.isnew && !this.readed[pageIndex]) {
            this.readPage(pageIndex);
        }
        if ((pageIndex2 = this.getPageIndex(this.currentPosition + len - 1)) > pageIndex && !this.isnew && !this.readed[pageIndex2]) {
            this.readPage(pageIndex2);
        }
        byte[] bs = new byte[len];
        System.arraycopy(this.buffer, this.currentPosition, bs, 0, len);
        this.currentPosition += len;
        return bs;
    }

    public void readUsedSize() throws IOException {
        this.readPage(0);
    }

    public int readInt() throws IOException {
        int pageIndex2;
        if (this.currentPosition + 4 > this.length()) {
            throw new EOFException();
        }
        int pageIndex = this.getPageIndex(this.currentPosition);
        if (!this.isnew && !this.readed[pageIndex]) {
            this.readPage(pageIndex);
        }
        if ((pageIndex2 = this.getPageIndex(this.currentPosition + 4 - 1)) > pageIndex && !this.isnew && !this.readed[pageIndex2]) {
            this.readPage(pageIndex2);
        }
        int ch1 = this.buffer[this.currentPosition++] & 0xFF;
        int ch2 = this.buffer[this.currentPosition++] & 0xFF;
        int ch3 = this.buffer[this.currentPosition++] & 0xFF;
        int ch4 = this.buffer[this.currentPosition++] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    private void readPage(int pageIndex, int offset, int len) throws IOException {
        int newOffset = this.pages[pageIndex] * this.pageSize + offset;
        this.dataFile.seek(newOffset);
        this.dataFile.read(this.buffer, pageIndex * this.pageSize + offset, len);
        if (pageIndex == 0) {
            this.usedSize = this.readInt(0);
        }
        this.readed[pageIndex] = true;
    }

    private void readPage(int pageIndex) throws IOException {
        this.readPage(pageIndex, 0, this.pageSize);
    }

    private void writePage(int pageIndex, int offset, int len) throws IOException {
        int newOffset = this.pages[pageIndex] * this.pageSize + offset;
        this.dataFile.seek(newOffset);
        this.dataFile.write(this.buffer, pageIndex * this.pageSize + offset, len);
    }

    private void writePage(int pageIndex) throws IOException {
        this.writePage(pageIndex, 0, this.pageSize);
    }

    byte readByte(int position) throws IOException {
        int pageIndex = position / this.pageSize;
        int offset = position % this.pageSize;
        this.dataFile.seek(this.pages[pageIndex] * this.pageSize + offset);
        this.currentPosition = position + 1;
        return this.dataFile.readByte();
    }

    void writeByte(int position, byte b) throws IOException {
        int pageIndex = position / this.pageSize;
        int offset = position % this.pageSize;
        this.dataFile.seek(this.pages[pageIndex] * this.pageSize + offset);
        this.currentPosition = position + 1;
        this.dataFile.writeByte(b);
    }

    private int readInt(int position) throws IOException {
        int pageIndex = position / this.pageSize;
        int offset = position % this.pageSize;
        if (offset + 4 > this.pageSize && pageIndex == this.bucketSize - 1) {
            throw new EOFException();
        }
        this.dataFile.seek(this.pages[pageIndex] * this.pageSize + offset);
        int ret = this.dataFile.readInt();
        this.currentPosition = position + 4;
        return ret;
    }
}

