/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.query;

import com.kingdee.bos.olap.Axis;
import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.Position;
import com.kingdee.bos.olap.Query;
import com.kingdee.bos.olap.query.MemberSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class OLAPQuery
implements Query,
Serializable {
    Cube cube;
    _Axis[] axes;
    Member[] sliceMembers;

    public OLAPQuery(Cube _cube, MemberSet[] _axisSets, Member[] _sliceMembers) throws OLAPException {
        this(_cube, _axisSets, _sliceMembers, true);
    }

    public OLAPQuery(Cube _cube, MemberSet[] _axisSets, Member[] _sliceMembers, boolean removeEmpty) throws OLAPException {
        int i;
        this.cube = _cube;
        this.axes = new _Axis[_axisSets.length];
        if (this.axes.length == 0 || this.axes.length > 2) {
            throw new OLAPException("Query must has one axis or two.");
        }
        for (int i2 = 0; i2 < this.axes.length; ++i2) {
            this.axes[i2] = new _Axis("Axis(" + i2 + ")", _axisSets[i2], removeEmpty);
            Position[] poses = this.axes[i2].positions();
            if (poses != null && poses.length != 0) continue;
            throw new OLAPException("Illegal Query,No position defined in axis " + i2);
        }
        ArrayList hies = this.getAllHierarchy();
        for (int i3 = 0; i3 < this.axes.length; ++i3) {
            hies.removeAll(Arrays.asList(this.axes[i3].hies));
        }
        int count = hies.size();
        this.sliceMembers = new Member[count];
        HashMap<Hierarchy, Member> map = new HashMap<Hierarchy, Member>();
        if (_sliceMembers != null) {
            for (i = 0; i < _sliceMembers.length; ++i) {
                map.put(_sliceMembers[i].getHierarchy(), _sliceMembers[i]);
            }
        }
        for (i = 0; i < count; ++i) {
            Hierarchy hie = (Hierarchy)hies.get(i);
            Member member = (Member)map.get(hie);
            this.sliceMembers[i] = member != null ? member : ((Hierarchy)hies.get(i)).getDefaultMember();
        }
    }

    @Override
    public Cube getCube() {
        return this.cube;
    }

    @Override
    public Axis[] getAxes() {
        return this.axes;
    }

    @Override
    public Member[] getSliceMembers() {
        return this.sliceMembers;
    }

    public void dump() throws Exception {
        for (int i = 0; i < this.axes.length; ++i) {
            this.dump(this.axes[i]);
        }
    }

    private void dump(Axis axis) throws Exception {
        System.out.println(axis.getName());
        Position[] ps = axis.positions();
        for (int i = 0; i < ps.length; ++i) {
            this.dump(i, ps[i]);
        }
        System.out.println();
    }

    private void dump(int index, Position pos) throws Exception {
        System.out.print("\tpos(" + index + "):\t");
        Member[] ms = pos.members();
        for (int i = 0; i < ms.length; ++i) {
            if (i > 0) {
                System.out.print(", ");
            }
            System.out.print(ms[i].getName());
        }
        System.out.println();
    }

    private ArrayList getAllHierarchy() {
        Dimension[] dims = this.cube.getDimensions();
        ArrayList<Hierarchy> list = new ArrayList<Hierarchy>();
        list.add(this.cube.getMeasureDimension().getDefaultHierarchy());
        for (int i = 0; i < dims.length; ++i) {
            list.addAll(Arrays.asList(dims[i].getHierarchies()));
        }
        return list;
    }

    static class _Axis
    implements Axis,
    Serializable {
        Hierarchy[] hies;
        MemberSet set;
        String name;
        boolean removeEmpty;

        _Axis(String _name, MemberSet _set, boolean removeEmpty) {
            this.removeEmpty = removeEmpty;
            this.name = _name;
            this.set = _set;
            Position pos = this.set.positions()[0];
            Member[] members = pos.members();
            this.hies = new Hierarchy[members.length];
            for (int i = 0; i < this.hies.length; ++i) {
                this.hies[i] = members[i].getHierarchy();
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Position[] positions() {
            return this.set.positions();
        }

        @Override
        public Hierarchy[] hierarchies() {
            return this.hies;
        }

        @Override
        public boolean removeEmpty() {
            return this.removeEmpty;
        }
    }
}

