/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.rel.Aggregation;
import com.kingdee.bos.olap.rel.ColumnConstraint;
import com.kingdee.bos.olap.rel.Star;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AggregationManager {
    private Star star;
    private List aggregations;

    public AggregationManager(Star star) {
        this.star = star;
        this.aggregations = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aggregation lookupOrCreateAggregation(Star.Column[] columns) throws OLAPException {
        List list = this.aggregations;
        synchronized (list) {
            Aggregation aggregation = this.lookupAggregation(columns);
            if (aggregation == null) {
                aggregation = new Aggregation(this.star, columns);
                this.aggregations.add(aggregation);
            }
            return aggregation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aggregation lookupAggregation(Star.Column[] columns) {
        List list = this.aggregations;
        synchronized (list) {
            int count = this.aggregations.size();
            for (int i = 0; i < count; ++i) {
                Aggregation aggregation = (Aggregation)this.aggregations.get(i);
                if (!this.equals(aggregation.getColumns(), columns)) continue;
                return aggregation;
            }
            return null;
        }
    }

    public void loadAggregation(Star.Column[] measures, Star.Column[] columns, ColumnConstraint[][] constraintses, Collection pinnedSegments) throws OLAPException {
        Aggregation aggregation = this.lookupOrCreateAggregation(columns);
        try {
            aggregation.optimizeConstraints(columns, constraintses);
            aggregation.load(measures, constraintses, pinnedSegments);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new OLAPException(e);
        }
    }

    private boolean equals(Star.Column[] columns1, Star.Column[] columns2) {
        int count = columns1.length;
        if (count != columns2.length) {
            return false;
        }
        for (int j = 0; j < count; ++j) {
            if (columns1[j] == columns2[j]) continue;
            return false;
        }
        return true;
    }
}

