/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.base.OLAPElementBase;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.def.PropertyDef;
import com.kingdee.bos.olap.def.TableDef;
import com.kingdee.bos.olap.mdx.func.FuncUtil2;
import com.kingdee.bos.olap.mem.impl.PropertyImpl;
import com.kingdee.bos.olap.rel.MemberKey;
import com.kingdee.bos.olap.rel.MemberReaderBase;
import com.kingdee.bos.olap.rel.RelDimensionImpl;
import com.kingdee.bos.olap.rel.RelHierarchyImpl;
import com.kingdee.bos.olap.rel.RelLevelImpl;
import com.kingdee.bos.olap.rel.RelMemberImpl;
import com.kingdee.bos.olap.rel.RelSchemaImpl;
import com.kingdee.bos.olap.rel.RelUtil;
import com.kingdee.bos.olap.rel.SqlQuery;
import com.kingdee.bos.olap.util.Util;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class MemberReaderImpl
extends MemberReaderBase {
    int lastOrdinal = 0;
    private RelMemberImpl allMember;
    private Map mapChildMemberSql = new HashMap();
    private HashMap levelCounts = new HashMap();

    public MemberReaderImpl(RelSchemaImpl schema, RelHierarchyImpl hie) {
        super(schema, hie);
    }

    @Override
    public RelMemberImpl getAllMember() {
        if (!this.hie.hasAll()) {
            return null;
        }
        if (this.allMember != null) {
            return this.allMember;
        }
        this.allMember = new RelMemberImpl(null);
        this.allMember.setName(this.hie.getAllMemberName());
        this.allMember.setCaption(this.hie.getAllMemberCaption());
        this.allMember.memberType = (byte)8;
        this.allMember.level = this.hie.levels[0];
        this.allMember.ordinal = this.lastOrdinal++;
        return this.allMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMemberList getMembersInLevel(RelLevelImpl level) throws OLAPException {
        if (level.isAll()) {
            IMemberList list = this.schema.conn.getListFactory().createMemberList();
            list.add(this.getAllMember());
            return list;
        }
        RelLevelImpl[] levels = (RelLevelImpl[])this.hie.getLevels();
        Connection jdbcConnection = this.schema.conn.getJdbcConnection();
        try {
            IMemberList iMemberList = this.getMembersInLevel(level, jdbcConnection, levels);
            return iMemberList;
        }
        finally {
            try {
                jdbcConnection.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private void decideDataType(OLAPElementBase element, Object value) {
        if (value == null || value == Util.nullValue) {
            return;
        }
        String dataType = (String)element.getProperty("dataType");
        if (dataType == null) {
            dataType = Util.decideDataType(value);
            element.setProperty("dataType", dataType);
        }
    }

    private String getLevelNameColumn(RelLevelImpl level) {
        PropertyImpl[] properties = level.props;
        for (int j = 0; j < properties.length; ++j) {
            PropertyImpl property = properties[j];
            if (!property.getName().equals("name")) continue;
            return (String)property.getProperty("column");
        }
        return null;
    }

    private IMemberList getMembersInLevel(RelLevelImpl level, Connection jdbcConnection, RelLevelImpl[] levels) throws OLAPException {
        String sql = this.makeLevelSql(level, jdbcConnection);
        ResultSet resultSet = null;
        resultSet = null;
        try {
            resultSet = RelUtil.executeQuery(jdbcConnection, sql, "MemberReaderImpl.getMembersInLevel");
            IMemberList list = this.schema.conn.getListFactory().createMemberList();
            int levelDepth = level.getDepth();
            RelMemberImpl allMember = null;
            if (this.hie.hasAll()) {
                allMember = this.getAllMember();
            }
            RelMemberImpl[] members = new RelMemberImpl[levels.length];
            IMemberList[] siblings = new IMemberList[levels.length + 1];
            RelMemberImpl lastMember = null;
            while (resultSet.next()) {
                RelMemberImpl member = null;
                for (int i = 0; i <= levelDepth; ++i) {
                    RelLevelImpl childLevel = levels[i];
                    if (childLevel.isAll()) {
                        member = allMember;
                        continue;
                    }
                    String columnName = levels[i].def.column;
                    if (levels[i].hie.dim.isTimeDimension()) {
                        columnName = this.getLevelSqlAlias(levels[i]);
                    }
                    String nameColumn = this.getLevelNameColumn(levels[i]);
                    Object value = resultSet.getObject(columnName);
                    if (value == null) continue;
                    this.decideDataType(childLevel, value);
                    RelMemberImpl parentMember = member;
                    String name = null;
                    name = nameColumn != null ? resultSet.getString(nameColumn) : value.toString();
                    String uniqueName = parentMember == null ? Util.makeFqName(this.getHierarchy(), name) : Util.makeFqName(parentMember, name);
                    member = this.cache.getMember(uniqueName);
                    if (member == null) {
                        member = this.makeMember(parentMember, childLevel, value, resultSet, uniqueName);
                    }
                    if (member.equals(members[i])) continue;
                    IMemberList children = siblings[i + 1];
                    if (children != null) {
                        this.cache.putChildren(members[i], children);
                    }
                    siblings[i + 1] = i < levelDepth && !this.cache.hasChildren(member) ? this.schema.conn.getListFactory().createMemberList() : null;
                    members[i] = member;
                    if (siblings[i] == null) continue;
                    siblings[i].add(member);
                }
                if (member == null || member.equals(lastMember)) continue;
                list.add(member);
                lastMember = member;
            }
            for (int i = 0; i < members.length; ++i) {
                RelMemberImpl member = members[i];
                IMemberList children = siblings[i + 1];
                if (member == null || children == null) continue;
                this.cache.putChildren(member, children);
            }
            IMemberList iMemberList = list;
            return iMemberList;
        }
        catch (SQLException e) {
            throw new OLAPException(e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private RelMemberImpl makeMember(RelMemberImpl parentMember, RelLevelImpl childLevel, Object value, ResultSet resultSet, String uniqueName) throws SQLException {
        RelMemberImpl member = new RelMemberImpl(parentMember);
        member.level = childLevel;
        member.setKey(value);
        member.setOrdinal(this.lastOrdinal++);
        PropertyImpl[] properties = childLevel.props;
        for (int j = 0; j < properties.length; ++j) {
            PropertyImpl property = properties[j];
            String propColumn = (String)property.getProperty("column");
            Object o = resultSet.getObject(propColumn);
            if (o == null) continue;
            member.setProperty(property.getName(), o);
            this.decideDataType(property, o);
        }
        this.cache.putMember(uniqueName, member);
        return member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMemberChildren(RelMemberImpl parentMember, IMemberList children) throws OLAPException {
        Connection con = this.schema.conn.getJdbcConnection();
        try {
            this.getMemberChildren(parentMember, children, con);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private void getMemberChildren(RelMemberImpl parentMember, IMemberList children, Connection jdbcConnection) throws OLAPException {
        String sql = null;
        RelLevelImpl parentLevel = (RelLevelImpl)parentMember.getLevel();
        RelLevelImpl childLevel = null;
        if (parentMember.isCalculated()) {
            return;
        }
        if (parentMember.isAll()) {
            children.addList(this.getMembersInLevel(parentLevel.child));
            return;
        }
        RelLevelImpl[] levels = (RelLevelImpl[])this.hie.getLevels();
        int childDepth = parentLevel.getDepth() + 1;
        if (childDepth >= levels.length) {
            return;
        }
        childLevel = levels[childDepth];
        SqlQuery query = (SqlQuery)this.mapChildMemberSql.get(parentMember.level);
        if (query == null) {
            query = this.makeChildMemberSql(parentMember.level, jdbcConnection);
            this.mapChildMemberSql.put(parentMember.level, query);
        }
        sql = query.toString();
        Object[] values = this.makeChildMemberSqlParam(parentMember);
        String nameColumn = this.getLevelNameColumn(childLevel);
        ResultSet resultSet = null;
        try {
            resultSet = RelUtil.executeQueryWithParam(jdbcConnection, sql, values, "MemberReaderImpl.getMemberChildren");
            while (resultSet.next()) {
                Object value = resultSet.getObject(1);
                if (value == null) continue;
                this.decideDataType(childLevel, value);
                String name = null;
                name = nameColumn != null ? resultSet.getString(nameColumn) : value.toString();
                String uniqueName = parentMember == null ? Util.makeFqName(this.getHierarchy(), name) : Util.makeFqName(parentMember, name);
                RelMemberImpl member = this.cache.getMember(uniqueName);
                if (member == null) {
                    member = this.makeMember(parentMember, childLevel, value, resultSet, uniqueName);
                }
                children.add(member);
            }
            return;
        }
        catch (SQLException e) {
            throw new OLAPException(e.getMessage());
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private Object[] makeChildMemberSqlParam(RelMemberImpl member) throws OLAPException {
        ArrayList<Object> alist = new ArrayList<Object>();
        for (RelMemberImpl m = member; m != null; m = (RelMemberImpl)m.getParentMember()) {
            RelLevelImpl level = (RelLevelImpl)m.getLevel();
            if (level.isAll()) continue;
            alist.add(m.getKey());
        }
        return alist.toArray(new Object[alist.size()]);
    }

    private SqlQuery makeChildMemberSql(RelLevelImpl parentLevel, Connection jdbcConnection) throws OLAPException {
        SqlQuery sqlQuery = this.newQuery(jdbcConnection, "makeChildMemberSql");
        sqlQuery.setDistinct(true);
        String table = parentLevel.hie.dim.getTable();
        TableDef tableDef = RelUtil.lookupOrCreateTableDef(parentLevel.hie.dim.schema, table);
        sqlQuery.addFrom(tableDef);
        HashSet columnSet = new HashSet();
        RelLevelImpl level = parentLevel;
        while (level != null) {
            if (!level.isAll()) {
                String q = level.def.column;
                if (this.hie.dim.isTimeDimension()) {
                    q = sqlQuery.getDateColumnFormater(this.schema.conn.dbType).formatDateColumn(level, level.def);
                }
                sqlQuery.addWhere(q, " = ", "?");
            }
            level = level.parent;
        }
        RelLevelImpl[] levels = (RelLevelImpl[])this.hie.getLevels();
        RelLevelImpl level2 = levels[parentLevel.getDepth() + 1];
        String q = level2.def.column;
        if (this.hie.dim.isTimeDimension()) {
            q = sqlQuery.getDateColumnFormater(this.schema.conn.dbType).formatDateColumn(level2, level2.def);
            this.addSelect(sqlQuery, columnSet, q, this.getLevelSqlAlias(level2));
        } else {
            this.addSelect(sqlQuery, columnSet, q);
        }
        PropertyDef[] properties = level2.def.properties;
        for (int j = 0; j < properties.length; ++j) {
            PropertyDef property = properties[j];
            String s = property.column;
            this.addSelect(sqlQuery, columnSet, s);
        }
        if (level2.def.orderBy != null) {
            String str = level2.def.orderBy;
            this.addSelect(sqlQuery, columnSet, str);
            if (level2.def.orderMethod != null) {
                str = str + " " + level2.def.orderMethod;
            }
            sqlQuery.addOrderBy(str);
        } else if (this.hie.dim.isTimeDimension()) {
            String column = sqlQuery.getDateColumnFormater(this.schema.conn.dbType).formatDateColumn(level2, level2.def);
            sqlQuery.addOrderBy(column);
        } else {
            String column = RelUtil.getLevelNameColumn(level2);
            if (column != null) {
                sqlQuery.addOrderBy(column);
            } else {
                column = (String)level2.getProperty("column");
                sqlQuery.addOrderBy(column);
            }
        }
        return sqlQuery;
    }

    @Override
    public IMemberList getRootMembers() throws OLAPException {
        return this.getMembersInLevel((RelLevelImpl)this.hie.getLevels()[0]);
    }

    @Override
    public IMemberList getHierarchizeMembers() throws OLAPException {
        IMemberList members = this.getMembers();
        FuncUtil2.hierarchize(members, false);
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMemberList getMembers() throws OLAPException {
        Connection jdbcConnection = this.schema.conn.getJdbcConnection();
        try {
            IMemberList iMemberList = this.getMembers(jdbcConnection);
            return iMemberList;
        }
        finally {
            try {
                jdbcConnection.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private IMemberList getMembers(Connection jdbcConnection) throws OLAPException {
        String sql = this.makeKeysSql(jdbcConnection);
        RelLevelImpl[] levels = (RelLevelImpl[])this.hie.getLevels();
        ResultSet resultSet = null;
        try {
            resultSet = RelUtil.executeQuery(jdbcConnection, sql, "MemberReaderImpl.getMembers");
            IMemberList list = this.getListFactory().createMemberList();
            HashMap<MemberKey, RelMemberImpl> map = new HashMap<MemberKey, RelMemberImpl>();
            RelMemberImpl root = null;
            if (this.hie.hasAll()) {
                root = this.getAllMember();
                list.add(root);
            }
            boolean isTime = this.hie.getDimension().isTimeDimension();
            while (resultSet.next()) {
                RelMemberImpl member = root;
                for (int i = 0; i < levels.length; ++i) {
                    RelMemberImpl parent;
                    MemberKey key;
                    Object value;
                    RelLevelImpl level = levels[i];
                    if (level.isAll()) continue;
                    String columnName = levels[i].def.column;
                    if (levels[i].hie.dim.isTimeDimension()) {
                        columnName = this.getLevelSqlAlias(levels[i]);
                    }
                    if ((value = resultSet.getObject(columnName)) == null) continue;
                    if (isTime) {
                        value = Util.getLevelValue(level.levelType, value);
                    }
                    if ((member = (RelMemberImpl)map.get(key = new MemberKey(parent = member, value))) == null) {
                        member = new RelMemberImpl(parent);
                        member.level = level;
                        member.setKey(value);
                        member.setOrdinal(this.lastOrdinal++);
                        list.add(member);
                        map.put(key, member);
                    }
                    PropertyDef[] properties = level.def.properties;
                    for (int j = 0; j < properties.length; ++j) {
                        PropertyDef property = properties[j];
                        String propColumn = property.column;
                        Object o = resultSet.getObject(propColumn);
                        member.setProperty(property.name, o);
                    }
                }
            }
            IMemberList iMemberList = list;
            return iMemberList;
        }
        catch (SQLException e) {
            throw new OLAPException(e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private String getLevelSqlAlias(RelLevelImpl level) {
        return "c" + level.getName();
    }

    String makeLevelSql(RelLevelImpl level, Connection jdbcConnection) throws OLAPException {
        Util.assertPrecondition(!level.isAll());
        SqlQuery sqlQuery = this.newQuery(jdbcConnection, "while generating query to retrieve members of level " + level);
        sqlQuery.setDistinct(true);
        HashSet columnSet = new HashSet();
        RelLevelImpl[] levels = this.hie.levels;
        RelDimensionImpl dimension = this.hie.dim;
        TableDef tableDef = this.schema.conn.getTableDef(dimension.getTable());
        if (tableDef != null) {
            sqlQuery.addFrom(tableDef);
        } else {
            sqlQuery.addFromTable(null, dimension.getTable(), dimension.getTable());
        }
        int levelDepth = level.getDepth();
        for (int i = 0; i <= levelDepth; ++i) {
            RelLevelImpl level2 = levels[i];
            if (level2.isAll()) continue;
            String column = level2.def.column;
            if (this.hie.dim.isTimeDimension()) {
                column = sqlQuery.getDateColumnFormater(this.schema.conn.dbType).formatDateColumn(level2, level2.def);
                String alias = this.getLevelSqlAlias(level2);
                this.addSelect(sqlQuery, columnSet, column, alias);
            } else {
                this.addSelect(sqlQuery, columnSet, column);
            }
            PropertyImpl[] props = level2.props;
            for (int j = 0; j < props.length; ++j) {
                String propColumn = (String)props[j].getProperty("column");
                this.addSelect(sqlQuery, columnSet, propColumn);
            }
            if (level2.def.orderBy != null) {
                String str = level2.def.orderBy;
                this.addSelect(sqlQuery, columnSet, str);
                if (level2.def.orderMethod != null) {
                    str = str + " " + level2.def.orderMethod;
                }
                sqlQuery.addOrderBy(str);
                continue;
            }
            if (this.hie.dim.isTimeDimension()) {
                column = sqlQuery.getDateColumnFormater(this.schema.conn.dbType).formatDateColumn(level2, level2.def);
                sqlQuery.addOrderBy(column);
                continue;
            }
            column = RelUtil.getLevelNameColumn(level2);
            if (column == null) {
                column = (String)level2.getProperty("column");
            }
            sqlQuery.addOrderBy(column);
        }
        return sqlQuery.toString();
    }

    @Override
    public int getMemberCount() throws OLAPException {
        RelLevelImpl[] levels = (RelLevelImpl[])this.hie.getLevels();
        int count = 0;
        for (int i = 0; i < levels.length; ++i) {
            count += this.getLevelMemberCount(levels[i]);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLevelMemberCount(RelLevelImpl level) throws OLAPException {
        if (level.isAll()) {
            return 1;
        }
        if (this.levelCounts.get(level) != null) {
            return (Integer)this.levelCounts.get(level);
        }
        Connection con = this.schema.conn.getJdbcConnection();
        try {
            int count = this.getMemberCount(level, con);
            this.levelCounts.put(level, new Integer(count));
            int n = count;
            return n;
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private int getMemberCount(RelLevelImpl level, Connection jdbcConnection) throws OLAPException {
        int n;
        boolean[] mustCount = new boolean[1];
        String sql = this.makeLevelMemberCountSql(level, jdbcConnection, mustCount);
        ResultSet resultSet = null;
        try {
            resultSet = RelUtil.executeQuery(jdbcConnection, sql, "MemberReaderImpl.getLevelMemberCount");
            if (!mustCount[0]) {
                Util.assertTrue(resultSet.next());
                int n2 = resultSet.getInt(1);
                return n2;
            }
            ResultSetMetaData rmd = resultSet.getMetaData();
            int nColumns = rmd.getColumnCount();
            int count = 0;
            String[] colStrings = new String[nColumns];
            while (resultSet.next()) {
                boolean isEqual = true;
                for (int i = 0; i < nColumns; ++i) {
                    String colStr = resultSet.getString(i + 1);
                    if (!colStr.equals(colStrings[i])) {
                        isEqual = false;
                    }
                    colStrings[i] = colStr;
                }
                if (isEqual) continue;
                ++count;
            }
            n = count;
        }
        catch (SQLException e) {
            throw new OLAPException(e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return n;
    }

    private String makeLevelMemberCountSql(RelLevelImpl level, Connection jdbcConnection, boolean[] mustCount) throws OLAPException {
        mustCount[0] = false;
        SqlQuery sqlQuery = this.newQuery(jdbcConnection, "while generating query to count members in level " + level);
        int levelDepth = level.getDepth();
        RelLevelImpl[] levels = (RelLevelImpl[])this.hie.getLevels();
        sqlQuery.addFrom(RelUtil.lookupOrCreateTableDef(this.hie.dim.schema, this.hie.dim.getTable()));
        if (levelDepth == levels.length) {
            sqlQuery.addSelect("count(*)");
            return sqlQuery.toString();
        }
        if (!sqlQuery.allowsFromQuery()) {
            String columnList = "";
            int columnCount = 0;
            for (int i = levelDepth; i >= 0; --i) {
                RelLevelImpl level2 = levels[i];
                if (level2.isAll()) continue;
                if (columnCount > 0) {
                    mustCount[0] = true;
                }
                String keyExp = level2.def.column;
                if (columnCount > 0 && sqlQuery.isSybase()) {
                    keyExp = "convert(varchar, " + columnList + ")";
                }
                columnList = columnList + keyExp;
                ++columnCount;
            }
            if (mustCount[0]) {
                sqlQuery.addSelect(columnList);
                sqlQuery.addOrderBy(columnList);
            } else {
                sqlQuery.addSelect("count(DISTINCT " + columnList + ")");
            }
            return sqlQuery.toString();
        }
        sqlQuery.setDistinct(true);
        for (int i = levelDepth; i >= 0; --i) {
            RelLevelImpl level2 = levels[i];
            if (level2.isAll()) continue;
            sqlQuery.addSelect(level2.def.column);
        }
        SqlQuery outerQuery = this.newQuery(jdbcConnection, "while generating query to count members in level " + level);
        outerQuery.addSelect("count(*)");
        outerQuery.addFrom(sqlQuery, "init");
        return outerQuery.toString();
    }

    private void addSelect(SqlQuery query, HashSet columnSet, String column) {
        this.addSelect(query, columnSet, column, null);
    }

    private void addSelect(SqlQuery query, HashSet columnSet, String column, String alias) {
        if (column == null) {
            return;
        }
        if (!columnSet.contains(column = column.toUpperCase())) {
            columnSet.add(column);
            query.addSelect(column, alias);
        }
    }

    protected String makeKeysSql(Connection jdbcConnection) throws OLAPException {
        SqlQuery sqlQuery = this.newQuery(jdbcConnection, "while generating query to retrieve members of " + this.hie);
        sqlQuery.setDistinct(true);
        this.hie.dim.addToSqlQuery(sqlQuery);
        RelLevelImpl[] levels = (RelLevelImpl[])this.hie.getLevels();
        HashSet columnSet = new HashSet();
        for (int i = 0; i < levels.length; ++i) {
            String column;
            RelLevelImpl level = levels[i];
            if (level.isAll()) continue;
            String expString = level.def.column;
            if (this.hie.dim.isTimeDimension()) {
                expString = sqlQuery.getDateColumnFormater(this.schema.conn.dbType).formatDateColumn(level, level.def);
                this.addSelect(sqlQuery, columnSet, expString, this.getLevelSqlAlias(level));
            } else {
                this.addSelect(sqlQuery, columnSet, expString);
            }
            PropertyDef[] properties = level.def.properties;
            for (int j = 0; j < properties.length; ++j) {
                PropertyDef property = properties[j];
                expString = property.column;
                this.addSelect(sqlQuery, columnSet, expString);
            }
            if (level.def.orderBy != null) {
                String str = level.def.orderBy;
                this.addSelect(sqlQuery, columnSet, str);
                if (level.def.orderMethod != null) {
                    str = str + " " + level.def.orderMethod;
                }
                sqlQuery.addOrderBy(str);
                continue;
            }
            if (this.hie.dim.isTimeDimension()) {
                column = sqlQuery.getDateColumnFormater(this.schema.conn.dbType).formatDateColumn(level, level.def);
                sqlQuery.addOrderBy(column);
                continue;
            }
            column = RelUtil.getLevelNameColumn(level);
            if (column != null) {
                sqlQuery.addOrderBy(column);
                continue;
            }
            column = (String)level.getProperty("column");
            sqlQuery.addOrderBy(column);
        }
        return sqlQuery.toString();
    }

    @Override
    public void init() throws OLAPException {
    }
}

