/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.base.CellKey;
import com.kingdee.bos.olap.rel.Aggregation;
import com.kingdee.bos.olap.rel.SegmentDataset;
import com.kingdee.bos.olap.rel.Star;
import com.kingdee.bos.olap.util.Util;
import java.util.Collection;
import org.apache.log4j.Logger;

public class Segment {
    private static Logger logger = CommonLogger.getLogger(Segment.class);
    final Star.Column measure;
    private SegmentDataset data;
    final Aggregation.Axis[] axes;
    private int state;
    private final CellKey cellKey;

    Segment(Star.Column measure, Aggregation.Axis[] axes) {
        this.measure = measure;
        this.axes = axes;
        this.cellKey = new CellKey(new int[axes.length]);
        this.state = 1;
    }

    synchronized void setData(SegmentDataset data, Collection pinnedSegments) {
        this.data = data;
        this.state = 2;
        this.notifyAll();
    }

    Object get(Object[] keys) {
        int missed = 0;
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            Integer integer = this.axes[i].getOffset(key);
            if (integer == null) {
                if (this.axes[i].contains(key)) {
                    ++missed;
                    continue;
                }
                return null;
            }
            this.cellKey.ordinals[i] = integer;
        }
        if (missed > 0) {
            return Util.nullValue;
        }
        Object o = this.data.get(this.cellKey);
        if (o == null) {
            o = Util.nullValue;
        }
        return o;
    }

    boolean wouldContain(Object[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            if (this.axes[i].contains(key)) continue;
            return false;
        }
        return true;
    }

    public boolean isReady() {
        return this.state == 2;
    }

    private String arrayToString(Object[] keys) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < keys.length; ++i) {
            sb.append(keys[i]);
            if (i <= 0) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

