/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.def.TableDef;
import com.kingdee.bos.olap.rel.DBType;
import com.kingdee.bos.olap.rel.RelUtil;
import com.kingdee.bos.olap.rel.Star;
import com.kingdee.bos.olap.rel.dialect.DateColumnFormater;
import com.kingdee.bos.olap.rel.dialect.OracleDateColumnFormater;
import com.kingdee.bos.olap.util.Util;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public class SqlQuery {
    private boolean distinct;
    private String productName;
    private final ClauseList select;
    private final ClauseList from;
    private final ClauseList where;
    private final ClauseList groupBy;
    private final ClauseList having;
    private final ClauseList orderBy;
    private final List fromAliases;
    private final String quoteIdentifierString;
    private final StringBuffer buf;
    private DateColumnFormater dateColumnFormater;

    public SqlQuery(DatabaseMetaData databaseMetaData) throws OLAPException {
        this(databaseMetaData, null);
    }

    private SqlQuery(DatabaseMetaData databaseMetaData, String quoteIdentifierString) throws OLAPException {
        this.quoteIdentifierString = quoteIdentifierString == null ? this.initializeQuoteIdentifierString(databaseMetaData) : quoteIdentifierString;
        this.productName = this.getProduct(databaseMetaData);
        this.select = new ClauseList(true);
        this.from = new ClauseList(true);
        this.where = new ClauseList(false);
        this.groupBy = new ClauseList(false);
        this.having = new ClauseList(false);
        this.orderBy = new ClauseList(false);
        this.fromAliases = new ArrayList();
        this.buf = new StringBuffer(128);
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    private String initializeQuoteIdentifierString(DatabaseMetaData databaseMetaData) throws OLAPException {
        String s = null;
        try {
            s = databaseMetaData.getIdentifierQuoteString();
        }
        catch (SQLException e) {
            return null;
        }
        if (s.trim().length() == 0) {
            s = null;
        }
        return s;
    }

    public String quoteIdentifier(String val) {
        StringBuffer buf = new StringBuffer();
        this.quoteIdentifier(val, buf);
        return buf.toString();
    }

    public void quoteIdentifier(String val, StringBuffer buf) {
        String q = this.getQuoteIdentifierString();
        if (q == null) {
            buf.append(val);
            return;
        }
        if (val.startsWith(q) && val.endsWith(q)) {
            buf.append(val);
            return;
        }
        int k = val.indexOf(46);
        if (k > 0) {
            String val1 = Util.replace(val.substring(0, k), q, q + q);
            String val2 = Util.replace(val.substring(k + 1), q, q + q);
            buf.append(q);
            buf.append(val1);
            buf.append(q);
            buf.append(".");
            buf.append(q);
            buf.append(val2);
            buf.append(q);
        } else {
            String val2 = Util.replace(val, q, q + q);
            buf.append(q);
            buf.append(val2);
            buf.append(q);
        }
    }

    public String quoteIdentifier(String qual, String name) {
        StringBuffer buf = new StringBuffer();
        this.quoteIdentifier(qual, name, buf);
        return buf.toString();
    }

    public void quoteIdentifier(String qual, String name, StringBuffer buf) {
        if (qual == null) {
            this.quoteIdentifier(name, buf);
        } else {
            this.quoteIdentifier(qual, buf);
            buf.append('.');
            this.quoteIdentifier(name, buf);
        }
    }

    public String getQuoteIdentifierString() {
        return this.quoteIdentifierString;
    }

    public DateColumnFormater getDateColumnFormater(DBType dbType) throws OLAPException {
        if (this.dateColumnFormater == null) {
            if (dbType.isKsql() || dbType.isDB2() || dbType.isMSSql()) {
                this.dateColumnFormater = DateColumnFormater.instance;
            } else if (this.isOracle()) {
                this.dateColumnFormater = OracleDateColumnFormater.instance;
            } else {
                throw new OLAPException("unsopported database when use time dimension.");
            }
        }
        return this.dateColumnFormater;
    }

    private String getProduct(DatabaseMetaData databaseMetaData) throws OLAPException {
        try {
            String productName = databaseMetaData.getDatabaseProductName();
            return productName;
        }
        catch (SQLException e) {
            throw new OLAPException("while detecting database product", e);
        }
    }

    public boolean isAccess() throws OLAPException {
        return this.productName.equals("ACCESS");
    }

    public boolean isDB2() throws OLAPException {
        return this.productName.startsWith("DB2");
    }

    public boolean isKingBase() throws OLAPException {
        return this.productName.startsWith("Kingbase");
    }

    String getBestName() throws OLAPException {
        String best = this.isOracle() ? "oracle" : (this.isMSSQL() ? "mssql" : (this.isMySQL() ? "mysql" : (this.isAccess() ? "access" : (this.isPostgres() ? "postgres" : (this.isSybase() ? "sybase" : (this.isDM() ? "dm" : "generic"))))));
        return best;
    }

    public boolean isInformix() throws OLAPException {
        return this.productName.startsWith("Informix");
    }

    public boolean isMSSQL() throws OLAPException {
        return this.productName.toUpperCase().indexOf("SQL SERVER") >= 0;
    }

    public boolean isOracle() throws OLAPException {
        return this.productName.equals("Oracle");
    }

    public boolean isPostgres() throws OLAPException {
        return this.productName.toUpperCase(Locale.ENGLISH).indexOf("POSTGRE") >= 0;
    }

    public boolean isMySQL() throws OLAPException {
        return this.productName.toUpperCase(Locale.ENGLISH).equals("MYSQL");
    }

    public boolean isSybase() throws OLAPException {
        return this.productName.toUpperCase(Locale.ENGLISH).indexOf("SYBASE") >= 0;
    }

    public boolean isDM() throws OLAPException {
        System.out.println("==============SqlQuery isDM=========" + this.productName);
        return this.productName.toUpperCase(Locale.ENGLISH).indexOf("DM") >= 0;
    }

    protected boolean allowsAs() throws OLAPException {
        return !this.isOracle() && !this.isSybase();
    }

    public boolean allowsFromQuery() throws OLAPException {
        return !this.isMySQL() && !this.isInformix() && !this.isSybase();
    }

    public boolean addFromTable(String schema, String table, String alias) throws OLAPException {
        if (this.fromAliases.contains(alias)) {
            return false;
        }
        this.buf.setLength(0);
        if (schema == null) {
            if (table.indexOf(32) > -1) {
                this.quoteIdentifier(table, this.buf);
            } else {
                this.buf.append(table);
            }
        } else {
            if (schema.indexOf(32) > -1) {
                this.quoteIdentifier(schema, this.buf);
            } else {
                this.buf.append(schema);
            }
            this.buf.append('.');
            if (table.indexOf(32) > -1) {
                this.quoteIdentifier(table, this.buf);
            } else {
                this.buf.append(table);
            }
        }
        if (alias != null) {
            if (this.allowsAs()) {
                this.buf.append(" as ");
            } else {
                this.buf.append(' ');
            }
            this.buf.append(alias);
            this.fromAliases.add(alias);
        }
        this.from.add(this.buf.toString());
        return true;
    }

    public boolean addFromQuery(String query, String alias) throws OLAPException {
        Util.assertPrecondition(alias != null);
        if (this.fromAliases.contains(alias)) {
            return false;
        }
        this.buf.setLength(0);
        this.buf.append('(');
        this.buf.append(query);
        this.buf.append(')');
        if (alias != null) {
            Util.assertTrue(alias.length() > 0);
            if (this.allowsAs()) {
                this.buf.append(" as ");
            } else {
                this.buf.append(' ');
            }
            this.buf.append(alias);
            this.fromAliases.add(alias);
        }
        this.from.add(this.buf.toString());
        return true;
    }

    public void addFrom(SqlQuery sqlQuery, String alias) throws OLAPException {
        this.addFromQuery(sqlQuery.toString(), alias);
    }

    public boolean addFrom(TableDef tableDef) throws OLAPException {
        if (tableDef instanceof TableDef) {
            TableDef def = tableDef;
            if (def.sql != null) {
                if (tableDef.generate) {
                    return this.addFromTable(null, def.sql, RelUtil.prixTableName(def.name));
                }
                StringTokenizer st = new StringTokenizer(def.sql, " ");
                if (st.countTokens() == 4 && st.nextToken().equalsIgnoreCase("select") && st.nextToken().equalsIgnoreCase("*") && st.nextToken().equalsIgnoreCase("from")) {
                    return this.addFromTable(null, st.nextToken(), RelUtil.prixTableName(def.name));
                }
                return this.addFromQuery(def.sql, RelUtil.prixTableName(def.name));
            }
            return this.addFromTable(null, def.name, RelUtil.prixTableName(def.name));
        }
        throw Util.newInternal("bad table type " + tableDef.toString());
    }

    public void addIsNotLeafConstraint(Star.Table[] tables) {
        StringBuffer where = new StringBuffer("not (");
        for (int i = 0; i < tables.length; ++i) {
            if (i > 0) {
                where.append(" and ");
            }
            where.append(RelUtil.prixTableName(tables[i].getName())).append(".").append(RelUtil.getIsLeafColumnName()).append("=1");
        }
        where.append(")");
        this.addWhere(where.toString());
    }

    public void addSelect(String expression) throws OLAPException {
        this.addSelect(expression, "c" + this.select.size());
    }

    public void addSelect(String expression, String alias) {
        this.buf.setLength(0);
        this.buf.append(expression);
        if (alias != null) {
            this.buf.append(" as ");
            this.buf.append(alias);
        }
        this.select.add(this.buf.toString());
    }

    public void addWhere(String exprLeft, String exprMid, String exprRight) {
        int len = exprLeft.length() + exprMid.length() + exprRight.length();
        StringBuffer buf = new StringBuffer(len);
        buf.append(exprLeft);
        buf.append(exprMid);
        buf.append(exprRight);
        this.addWhere(buf.toString());
    }

    public void addWhere(String expression) {
        this.where.add(expression);
    }

    public void addGroupBy(String expression) {
        this.groupBy.add(expression);
    }

    public void addHaving(String expression) {
        this.having.add(expression);
    }

    public void addOrderBy(String expression) {
        this.orderBy.add(expression);
    }

    public String toString() {
        this.buf.setLength(0);
        this.select.toBuffer(this.buf, this.distinct ? "select distinct " : "select ", ", ");
        this.from.toBuffer(this.buf, " from ", ", ");
        this.where.toBuffer(this.buf, " where ", " and ");
        this.groupBy.toBuffer(this.buf, " group by ", ", ");
        this.having.toBuffer(this.buf, " having ", " and ");
        this.orderBy.toBuffer(this.buf, " order by ", ", ");
        return this.buf.toString();
    }

    private class ClauseList
    extends ArrayList {
        private final boolean allowDups;

        ClauseList(boolean allowDups) {
            this.allowDups = allowDups;
        }

        void add(String element) {
            if (this.allowDups || !this.contains(element)) {
                super.add(element);
            }
        }

        void toBuffer(StringBuffer buf, String first, String sep) {
            Iterator it = this.iterator();
            boolean firstTime = true;
            while (it.hasNext()) {
                String s = (String)it.next();
                if (firstTime) {
                    buf.append(first);
                    firstTime = false;
                } else {
                    buf.append(sep);
                }
                buf.append(s);
            }
        }
    }
}

