/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.def.TableDef;
import com.kingdee.bos.olap.rel.AggregationManager;
import com.kingdee.bos.olap.rel.ColumnConstraint;
import com.kingdee.bos.olap.rel.RelAggregator;
import com.kingdee.bos.olap.rel.RelCubeImpl;
import com.kingdee.bos.olap.rel.RelLevelImpl;
import com.kingdee.bos.olap.rel.RelSchemaImpl;
import com.kingdee.bos.olap.rel.RelUtil;
import com.kingdee.bos.olap.rel.SqlQuery;
import com.kingdee.bos.olap.rel.dialect.DatabaseMetaUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Star {
    RelSchemaImpl schema;
    RelCubeImpl cube;
    private final Table factTable;
    private final Map mapColumnToName;
    private final Map mapLevelToColumn;
    private final Map mapLevelToNameColumn;
    private boolean hasPCDimension;
    private final AggregationManager am;
    Map mapDimToTable = new HashMap();

    public Star(RelSchemaImpl schema, RelCubeImpl cube, TableDef tableDef) {
        this.schema = schema;
        this.cube = cube;
        this.factTable = new Table(this, tableDef);
        this.mapColumnToName = new HashMap();
        this.mapLevelToColumn = new HashMap();
        this.mapLevelToNameColumn = new HashMap();
        this.am = new AggregationManager(this);
        this.init();
    }

    public void init() {
        Dimension[] dims = this.cube.getDimensions();
        for (int i = 0; i < dims.length; ++i) {
            if (!dims[i].isParentChildrenDimension()) continue;
            this.hasPCDimension = true;
        }
    }

    public boolean hasPCDimension() {
        return this.hasPCDimension;
    }

    public Table getFactTable() {
        return this.factTable;
    }

    public AggregationManager getAggregationManager() {
        return this.am;
    }

    public RelSchemaImpl getSchema() {
        return this.schema;
    }

    public RelCubeImpl getCube() {
        return this.cube;
    }

    Map getMapLevelToColumn() {
        return this.mapLevelToColumn;
    }

    Map getMapLevelToNameColumn() {
        return this.mapLevelToNameColumn;
    }

    public String getColumnName(Column column) {
        return (String)this.mapColumnToName.get(column);
    }

    public void addColumnToName(Column column, String name) {
        this.mapColumnToName.put(column, name);
    }

    public void addDimensionTable(Dimension dimension, Table table) {
        this.mapDimToTable.put(dimension, table);
    }

    public Table getDimensionTable(Dimension dimension) {
        return (Table)this.mapDimToTable.get(dimension);
    }

    public static class Table {
        Star star;
        List columns;
        Table parent;
        TableDef tableDef;
        TableDef originTableDef;
        String primaryKey;
        String foreignKey;

        public Table(Star star, TableDef tableDef) {
            this.star = star;
            this.tableDef = tableDef;
            this.columns = new ArrayList();
        }

        public Table(Star star, TableDef tableDef, Table parent, String primaryKey, String foreignKey) {
            this(star, tableDef);
            this.parent = parent;
            this.primaryKey = primaryKey;
            this.foreignKey = foreignKey;
        }

        public void addColumn(Column column) {
            this.columns.add(column);
        }

        public Star getStar() {
            return this.star;
        }

        public String getName() {
            return this.tableDef.name;
        }

        public String getSql() {
            return this.tableDef.sql;
        }

        public String getWhere() throws OLAPException {
            if (this.parent != null) {
                return new Column(this, this.primaryKey, null).getExpression(null) + " = " + new Column(this.parent, this.foreignKey, null).getExpression(null);
            }
            return null;
        }

        public void addToFrom(SqlQuery query) throws OLAPException {
            TableDef td = this.tableDef;
            query.addFrom(td);
        }

        public void addToFromByOrigin(SqlQuery query) throws OLAPException {
            if (this.originTableDef != null) {
                query.addFrom(this.originTableDef);
            } else {
                this.addToFrom(query);
            }
        }

        public void addConstraint(SqlQuery query) throws OLAPException {
            if (this.parent != null) {
                query.addWhere(this.getWhere());
            }
        }

        public void addIsLeafConstraint(SqlQuery query, Column column) throws OLAPException {
            TableDef td = this.tableDef;
            query.addWhere(RelUtil.prixTableName(td.name) + "." + RelUtil.getIsLeafColumnName() + "=1");
            String str = column.getExpression(query);
            str = str + "=" + RelUtil.prixTableName(column.table.tableDef.name) + "." + RelUtil.getKeyColumnName();
            query.addWhere(str);
        }
    }

    public static class MeasureProperty
    extends Column {
        MeasureProperty(Table table, String columnName) {
            super(table, columnName, null);
        }
    }

    public static class Measure
    extends Column {
        private final RelAggregator aggregator;

        Measure(RelAggregator aggregator, Table table, String columnName) {
            super(table, columnName, null);
            this.aggregator = aggregator;
        }

        public RelAggregator getAggregator() {
            return this.aggregator;
        }

        @Override
        public boolean isNumeric() {
            return true;
        }
    }

    public static class Column {
        Table table;
        String name;
        RelLevelImpl level;

        public Table getTable() {
            return this.table;
        }

        public RelLevelImpl getLevel() {
            return this.level;
        }

        public boolean isNumeric() {
            return false;
        }

        public boolean isDateTime() {
            if (this.level != null) {
                return this.level.getDimension().isTimeDimension() && "true".equalsIgnoreCase(this.level.def.isDateTimeColumn);
            }
            return false;
        }

        public String getExpression(SqlQuery sqlQuery) throws OLAPException {
            StringBuffer sb = new StringBuffer(RelUtil.prixTableName(this.table.tableDef.name));
            sb.append(".").append(this.name);
            if (this.isDateTime()) {
                return sqlQuery.getDateColumnFormater(this.getStar().getSchema().conn.dbType).formatDateColumn(this.level.levelType, sb.toString());
            }
            return sb.toString();
        }

        public Column(Table table, String name, RelLevelImpl level) {
            this.table = table;
            this.name = name;
            this.level = level;
        }

        public Star getStar() {
            return this.table.star;
        }

        private void quoteValue(Object o, StringBuffer buf) {
            String s = o.toString();
            if (o instanceof Number) {
                buf.append(s);
            } else if (o instanceof Date) {
                s = RelUtil.singleQuoteForSql(s);
                buf.append(DatabaseMetaUtil.formatDateValue(this.getStar().schema.conn.dbType, (Date)o));
            } else {
                RelUtil.singleQuoteForSql(s, buf);
            }
        }

        public String createInExpr(String expr, ColumnConstraint[] constraints) {
            ColumnConstraint constraint;
            Object key;
            if (constraints.length == 1 && (key = (constraint = constraints[0]).getValue()) != RelUtil.sqlNullValue) {
                StringBuffer buf = new StringBuffer(64);
                buf.append(expr);
                buf.append(" = ");
                this.quoteValue(key, buf);
                return buf.toString();
            }
            boolean oracle = this.getStar().schema.conn.dbType.isOracle();
            int limit = 1000;
            int notNullCount = 0;
            StringBuffer sb = new StringBuffer(expr);
            sb.append(" in (");
            for (int i = 0; i < constraints.length; ++i) {
                ColumnConstraint constraint2;
                Object key2;
                if (oracle && notNullCount % limit == 0 && notNullCount > 0) {
                    sb.append(") or ").append(expr).append(" in (");
                }
                if ((key2 = (constraint2 = constraints[i]).getValue()) == RelUtil.sqlNullValue) continue;
                if (notNullCount % limit > 0) {
                    sb.append(", ");
                }
                ++notNullCount;
                this.quoteValue(key2, sb);
            }
            sb.append(')');
            if (notNullCount < constraints.length) {
                switch (notNullCount) {
                    case 0: {
                        return expr + " is null";
                    }
                    case 1: {
                        StringBuffer buf = new StringBuffer(64);
                        buf.append('(');
                        buf.append(expr);
                        buf.append(" = ");
                        this.quoteValue(constraints[0].getValue(), buf);
                        buf.append(" or ");
                        buf.append(expr);
                        buf.append(" is null");
                        return buf.toString();
                    }
                }
                StringBuffer buf = new StringBuffer(64);
                buf.append('(');
                buf.append(sb.toString());
                buf.append(" or ");
                buf.append(expr);
                buf.append(" is null");
                return buf.toString();
            }
            return "(" + sb.toString() + ")";
        }
    }
}

