/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.def.CubeDef;
import com.kingdee.bos.olap.def.CubeDimension;
import com.kingdee.bos.olap.def.DimensionUsageDef;
import com.kingdee.bos.olap.def.HierarchyDef;
import com.kingdee.bos.olap.def.LevelDef;
import com.kingdee.bos.olap.def.MeasureDef;
import com.kingdee.bos.olap.def.PropertyDef;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.def.SharedDimensionDef;
import com.kingdee.bos.olap.def.TableDef;
import com.kingdee.bos.olap.rel.RelConnectionImpl;
import com.kingdee.bos.olap.rel.RelUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class StarTables {
    private static Logger logger = CommonLogger.getLogger(StarTables.class);
    public SchemaDef def;
    RelConnectionImpl conn;
    String factTableName_ref;
    String[] dimTableNames_ref;
    String factTableName_gen;
    String[] dimTableNames_gen;
    private HashMap dim2TableName_gen = new HashMap();
    private HashMap dim2ForeignKey = new HashMap();
    private HashMap dim2PrimaryKey = new HashMap();

    public StarTables(SchemaDef def, RelConnectionImpl conn) throws OLAPException {
        this.def = def;
        this.conn = conn;
        CubeDef cubeDef = def.cubes[0];
        this.factTableName_ref = cubeDef.table;
        boolean needTrimFactData = true;
        TableDef tableDef = conn.getTableDef(this.factTableName_ref);
        Connection jdbcConn = conn.getJdbcConnection();
        try {
            int i;
            if (tableDef == null) {
                this.factTableName_gen = this.factTableName_ref;
                needTrimFactData = false;
                this.collectFactColumns(cubeDef);
            } else {
                this.factTableName_gen = tableDef.generate ? tableDef.sql : this.genFactTable(jdbcConn, cubeDef, tableDef.name, tableDef.sql);
            }
            SharedDimensionDef[] sdds = def.dimensions;
            HashMap<String, SharedDimensionDef> map = new HashMap<String, SharedDimensionDef>();
            for (int i2 = 0; i2 < sdds.length; ++i2) {
                map.put(sdds[i2].name, sdds[i2]);
            }
            ArrayList dims = new ArrayList();
            CubeDimension[] cds = cubeDef.dimensions;
            for (i = 0; i < cds.length; ++i) {
                if (!(cds[i] instanceof DimensionUsageDef)) continue;
                dims.add(map.get(cds[i].name));
            }
            this.dimTableNames_ref = new String[dims.size()];
            this.dimTableNames_gen = new String[dims.size()];
            for (i = 0; i < dims.size(); ++i) {
                SharedDimensionDef sdd = (SharedDimensionDef)dims.get(i);
                this.dimTableNames_ref[i] = sdd.table;
                tableDef = conn.getTableDef(sdd.table);
                this.dimTableNames_gen[i] = tableDef == null ? this.genDimTable(jdbcConn, sdd, sdd.table, "select * from " + sdd.table) : (tableDef.generate ? tableDef.sql : this.genDimTable(jdbcConn, sdd, tableDef.name, tableDef.sql));
                this.dim2TableName_gen.put(sdd.name, this.dimTableNames_gen[i]);
            }
            if (needTrimFactData) {
                this.trimFactTableData(cubeDef);
            }
        }
        catch (SQLException e) {
            throw new OLAPException(e);
        }
        finally {
            if (jdbcConn != null) {
                try {
                    jdbcConn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public TableDef[] collectAllTableDef() {
        ArrayList<TableDef> list = new ArrayList<TableDef>();
        TableDef td = new TableDef(this.factTableName_ref, "select * from " + this.factTableName_gen);
        list.add(td);
        for (int i = 0; i < this.dimTableNames_ref.length; ++i) {
            td = new TableDef(this.dimTableNames_ref[i], "select * from " + this.dimTableNames_gen[i]);
            list.add(td);
        }
        TableDef[] tds = new TableDef[list.size()];
        list.toArray(tds);
        return tds;
    }

    public String getTableNameByRefName(String ref) {
        if (ref.equals(this.factTableName_ref)) {
            return this.factTableName_gen;
        }
        return this.getDimTableNameByRefName(ref);
    }

    public String getFactTableName() {
        return this.factTableName_gen;
    }

    public String getDimTableNameByRefName(String ref) {
        for (int i = 0; i < this.dimTableNames_ref.length; ++i) {
            if (!this.dimTableNames_ref[i].equals(ref)) continue;
            return this.dimTableNames_gen[i];
        }
        return null;
    }

    public String getDimTableByDimName(String dimName) {
        return (String)this.dim2TableName_gen.get(dimName);
    }

    private String[] collectFactColumns(CubeDef cubeDef) {
        HashSet set = new HashSet();
        CubeDimension[] cds = cubeDef.dimensions;
        for (int i = 0; i < cds.length; ++i) {
            if (!(cds[i] instanceof DimensionUsageDef)) continue;
            DimensionUsageDef dimDef = (DimensionUsageDef)cds[i];
            this.addToSet(dimDef.foreignKey, set);
            this.dim2ForeignKey.put(dimDef.name, dimDef.foreignKey);
        }
        MeasureDef[] mds = cubeDef.measures;
        for (int i = 0; i < mds.length; ++i) {
            this.addToSet(mds[i].column, set);
        }
        String[] columns = new String[set.size()];
        set.toArray(columns);
        return columns;
    }

    private String[] collectDimColumns(SharedDimensionDef dimDef) {
        HashSet set = new HashSet();
        this.addToSet(dimDef.primaryKey, set);
        HierarchyDef hieDef = dimDef.hierarchies[0];
        LevelDef[] levelDefs = hieDef.levels;
        for (int i = 0; i < levelDefs.length; ++i) {
            this.addToSet(levelDefs[i].column, set);
            this.addToSet(levelDefs[i].childColumn, set);
            this.addToSet(levelDefs[i].parentColumn, set);
            this.addToSet(levelDefs[i].orderBy, set);
            PropertyDef[] propDefs = levelDefs[i].properties;
            for (int j = 0; j < propDefs.length; ++j) {
                this.addToSet(propDefs[j].column, set);
            }
        }
        String[] columns = new String[set.size()];
        set.toArray(columns);
        return columns;
    }

    private void addToSet(String s, HashSet set) {
        if (s != null) {
            set.add(s.toLowerCase());
        }
    }

    private String unionString(String[] columns) {
        return this.unionString(columns, columns.length);
    }

    private String unionString(String[] columns, int count) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(columns[i]);
        }
        return sb.toString();
    }

    private String genDimTable(Connection jdbcConn, SharedDimensionDef dimDef, String name, String sql) throws SQLException, OLAPException {
        this.dim2PrimaryKey.put(dimDef.name, dimDef.primaryKey);
        if ("Time".equals(dimDef.type)) {
            String simple = this.isSimpleSelect(sql);
            if (simple != null) {
                return simple;
            }
            return sql;
        }
        boolean pc = false;
        if (dimDef.hierarchies[0].levels[0].parentColumn != null) {
            pc = true;
        }
        if (pc) {
            String childKey = dimDef.hierarchies[0].levels[0].childColumn;
            if (childKey == null) {
                childKey = dimDef.hierarchies[0].levels[0].column;
            }
            String parentKey = dimDef.hierarchies[0].levels[0].parentColumn;
            String selector = this.unionString(this.collectDimColumns(dimDef));
            String selector0 = selector + ",0 as OLAP_generation";
            String where = " " + dimDef.primaryKey + " in (select distinct " + this.dim2ForeignKey.get(dimDef.name) + " from " + this.factTableName_gen + ")";
            String t = this.isSimpleSelect(sql);
            String from = t != null ? t : "(" + sql + ") as a ";
            long start = System.currentTimeMillis();
            String tempTable = this.conn.getTemporaryTableName("OLAP Temp table for dim " + dimDef.name + ",sql is " + sql);
            this.insertInto(jdbcConn, selector0, from, where, tempTable);
            boolean suc = true;
            int generation = 0;
            while (suc) {
                selector0 = selector + "," + ++generation + " as OLAP_generation";
                where = childKey + " in (select distinct " + parentKey + " from " + tempTable + " where OLAP_generation=" + (generation - 1) + ")";
                where = where + " and " + dimDef.primaryKey + " not in (select distinct " + dimDef.primaryKey + " from " + tempTable + ")";
                suc = this.insertInto(jdbcConn, selector0, from, where, tempTable, false);
            }
            logger.debug((Object)("Select into cost " + (System.currentTimeMillis() - start) + ".ms"));
            return tempTable;
        }
        String selector = this.unionString(this.collectDimColumns(dimDef));
        String where = " " + dimDef.primaryKey + " in (select distinct " + this.dim2ForeignKey.get(dimDef.name) + " from " + this.factTableName_gen + ")";
        String t = this.isSimpleSelect(sql);
        String from = t != null ? t : "(" + sql + ") as a ";
        long start = System.currentTimeMillis();
        String tempTable = this.conn.getTemporaryTableName("OLAP Temp table for dim " + dimDef.name + ",sql is " + sql);
        this.insertInto(jdbcConn, selector, from, where, tempTable);
        logger.debug((Object)("Select into cost " + (System.currentTimeMillis() - start) + ".ms"));
        return tempTable;
    }

    private boolean insertInto(Connection jdbcConn, String selector, String from, String where, String table) throws SQLException, OLAPException {
        return this.insertInto(jdbcConn, selector, from, where, table, true);
    }

    private boolean insertInto(Connection jdbcConn, String selector, String from, String where, String table, boolean createTable) throws SQLException, OLAPException {
        boolean isKsql = this.conn.dbType.isKsql();
        if (this.conn.dbType.isMSSql() || this.conn.dbType.isSybase()) {
            int i;
            String sql = null;
            if (createTable) {
                sql = "select " + selector + " from " + from + " where 1=0";
                RelUtil.selectInto(this.conn, jdbcConn, sql, table);
            }
            return (i = RelUtil.execute(jdbcConn, sql = "insert into " + table + " select " + selector + " from " + from + " where " + where, "SqlServer select into,\u63d2\u5165\u4e34\u65f6\u8868")) > 0;
        }
        if (this.conn.dbType.isOracle()) {
            int i;
            String sql = null;
            if (createTable) {
                sql = "select " + selector + " from " + from + " where 1=0";
                RelUtil.selectInto(this.conn, jdbcConn, sql, table);
            }
            return (i = RelUtil.execute(jdbcConn, sql = "insert into " + table + " select " + selector + " from " + from + " where " + where, "Oracle select into,\u63d2\u5165\u4e34\u65f6\u8868")) > 0;
        }
        if (this.conn.dbType.isDB2()) {
            int i;
            String sql = null;
            if (createTable) {
                sql = "select " + selector + " from " + from + " where 1=0";
                RelUtil.selectInto(this.conn, jdbcConn, sql, table);
            }
            return (i = RelUtil.execute(jdbcConn, sql = "insert into " + table + " select " + selector + " from " + from + " where " + where, "DB2 select into,\u63d2\u5165\u4e34\u65f6\u8868")) > 0;
        }
        throw new OLAPException("Unsupported dbType.");
    }

    private String genFactTable(Connection jdbcConn, CubeDef cubeDef, String name, String sql) throws SQLException, OLAPException {
        String from;
        String[] columns = this.collectFactColumns(cubeDef);
        String foreignKeys = this.unionString(columns, columns.length - cubeDef.measures.length);
        String selector = this.unionString(columns);
        String t = this.isSimpleSelect(sql);
        if (t != null) {
            from = t;
            sql = " select " + selector + " from " + t;
        } else {
            from = "(" + sql + ") a";
            sql = " select " + selector + " from (" + sql + ") a";
        }
        String tempTable = this.conn.getTemporaryTableName("OLAP Temp table for fact,sql is " + sql);
        long start = System.currentTimeMillis();
        this.insertInto(jdbcConn, selector, from, "1=1", tempTable);
        logger.debug((Object)("Select into cost " + (System.currentTimeMillis() - start) + ".ms"));
        int tryCount = 0;
        boolean succeed = false;
        start = System.currentTimeMillis();
        while (tryCount++ < 2) {
            String indexName = StarTables.getTemporaryIndexName(tempTable);
            StringBuffer sb = new StringBuffer("create index ").append(indexName).append(" on ");
            sb.append(tempTable).append("(").append(foreignKeys).append(")");
            try {
                RelUtil.execute(jdbcConn, sb.toString(), "create index for temp table.");
                succeed = true;
                break;
            }
            catch (SQLException e) {
            }
        }
        logger.debug((Object)("Create index for fact temp table " + (succeed ? "succeeded" : "failed") + ".cost " + (System.currentTimeMillis() - start) + "ms."));
        return tempTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimFactTableData(CubeDef cubeDef) throws SQLException, OLAPException {
        StringBuffer sql = new StringBuffer("delete from " + this.factTableName_gen).append(" where ");
        for (int i = 0; i < cubeDef.dimensions.length; ++i) {
            if (!(cubeDef.dimensions[i] instanceof DimensionUsageDef)) continue;
            DimensionUsageDef dud = (DimensionUsageDef)cubeDef.dimensions[i];
            String dimTable = this.getDimTableByDimName(dud.name);
            if (dimTable.indexOf(" ") > -1) {
                dimTable = "(" + dimTable + ")";
            }
            String primaryKey = (String)this.dim2PrimaryKey.get(dud.name);
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append(dud.foreignKey).append(" not in ").append("(select ").append(primaryKey).append(" from ").append(dimTable).append(")");
        }
        Connection connection = null;
        try {
            connection = this.conn.getJdbcConnection();
            RelUtil.execute(connection, sql.toString(), "Trim fact table data.");
        }
        finally {
            CloseUtil.close((Connection)connection);
        }
    }

    private String isSimpleSelect(String sql) {
        StringTokenizer st = new StringTokenizer(sql);
        if (st.countTokens() == 4) {
            if ("select".equalsIgnoreCase(st.nextToken()) && "*".equalsIgnoreCase(st.nextToken()) && "from".equalsIgnoreCase(st.nextToken())) {
                return st.nextToken();
            }
            return null;
        }
        return null;
    }

    private static synchronized String getTemporaryIndexName(String table) {
        String name = "i" + System.currentTimeMillis();
        int len = name.length();
        if (len > 14) {
            name = "tmp_" + name.substring(len - 14, len);
        }
        return name;
    }
}

