/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.remoting;

import com.kingdee.bos.olap.remoting.RemoteException;
import com.kingdee.bos.olap.remoting.RemoteInvoke;
import com.kingdee.bos.olap.util.ByteArrayInputStream;
import com.kingdee.bos.olap.util.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class LocalRemoteInvoke
implements RemoteInvoke {
    private Object proxy;
    private Class clazz;
    private HashMap methods = new HashMap();

    public LocalRemoteInvoke(Object proxy) {
        this.proxy = proxy;
        this.clazz = proxy.getClass();
    }

    @Override
    public Object invoke(String method, Class[] argTypes, Object[] argValues) throws RemoteException {
        Key key = new Key(this.clazz, method, argTypes);
        Method m = (Method)this.methods.get(key);
        if (m == null) {
            try {
                m = this.clazz.getMethod(method, argTypes);
                this.methods.put(key, m);
            }
            catch (SecurityException e) {
                throw new RemoteException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RemoteException(e);
            }
        }
        try {
            Object o = m.invoke(this.proxy, argValues);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            GZIPOutputStream zout = new GZIPOutputStream(bo);
            ObjectOutputStream os = new ObjectOutputStream(zout);
            os.writeObject(o);
            zout.finish();
            os.flush();
            byte[] bs = bo.toByteArray();
            System.out.println(m.getName() + ":" + bs.length + "byte");
            ByteArrayInputStream bi = new ByteArrayInputStream(bs);
            GZIPInputStream zin = new GZIPInputStream(bi);
            ObjectInputStream is = new ObjectInputStream(zin);
            return is.readObject();
        }
        catch (IllegalArgumentException e) {
            throw new RemoteException(e);
        }
        catch (IllegalAccessException e) {
            throw new RemoteException(e);
        }
        catch (InvocationTargetException e) {
            throw new RemoteException(e.getTargetException());
        }
        catch (IOException e) {
            throw new RemoteException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RemoteException(e);
        }
    }

    @Override
    public Object[] invokeBatch(String[] methods, Class[][] argTypes, Object[][] argValues) throws RemoteException {
        return null;
    }

    private class Key {
        Class clazz;
        String method;
        Class[] argTypes;

        Key(Class clazz, String method, Class[] argTypes) {
            this.clazz = clazz;
            this.method = method;
            this.argTypes = argTypes;
        }
    }
}

