/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade.wizzard;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.IConstants;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.excel.io.BookIOUtil;
import com.kingdee.bos.ctrl.excel.io.clipboard.KDSTransferable;
import com.kingdee.bos.ctrl.excel.io.clipboard.StringWalker;
import com.kingdee.bos.ctrl.excel.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.excel.io.kds.BookToKds;
import com.kingdee.bos.ctrl.excel.io.kds.KDSBookToBook;
import com.kingdee.bos.ctrl.excel.io.kds.KdsToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.kdfsax.KDFSAXException;
import com.kingdee.bos.ctrl.kdf.util.printout.PrintableBook;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class WizzardIO
extends KDDialog
implements ISpreadWizzard,
IConstants {
    private final SimpleFileFilter Filter_KDS = new SimpleFileFilter("kds", "kds" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_KDSZIP = new SimpleFileFilter("kdszip", "kdszip" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_PDF = new SimpleFileFilter("pdf", "pdf" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_HTML = new SimpleFileFilter(new String[]{"htm", "html"}, this.getLocalText("Key_Page"));
    private final SimpleFileFilter Filter_Excel = new SimpleFileFilter("xls", "MS Excel" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_KDF = new SimpleFileFilter("kdf", "KDTable" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_XML = new SimpleFileFilter("xml", "xml" + this.getLocalText("Key_Table"));
    private final SimpleFileFilter Filter_TXT = new SimpleFileFilter("txt", "txt" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_HTM = new SimpleFileFilter("htm", "Excel htm" + this.getLocalText("Key_File"));
    private KDLabel _lbFile;
    private KDTextField _tfFile;
    private KDButton _btnFile;
    private KDLabel _lbImportMode;
    private KDComboBox _cbImportMode;
    private KDButton _btnSelAll;
    private KDButton _btnUnSelAll;
    private ImportOptionPanel _pnlIm;
    private ExportOptionPanel _pnlEx;
    private SheetListPanel _pnlSheet;
    private KDButton _btnOk;
    private KDButton _btnCancel;
    private SpreadContext _context;
    private KDFileChooser _chsFile;
    private boolean _isForImport;

    public WizzardIO(Dialog parent, SpreadContext context) {
        super(parent);
        this._context = context;
        this.initDialog();
        this.initComps();
        this.initPanel();
        this.setLocationRelativeTo(parent);
    }

    public WizzardIO(Frame parent, SpreadContext context) {
        super(parent);
        this._context = context;
        this.initDialog();
        this.initComps();
        this.initPanel();
        this.setLocationRelativeTo(parent);
    }

    private void initDialog() {
        this.setSize(500, 300);
        this.setResizable(false);
        this.setModal(true);
        this._chsFile = this.createFileChooser();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                WizzardIO.this._pnlSheet.setData(null);
            }
        });
    }

    private void initComps() {
        this._lbFile = new KDLabel(this.getLocalText("Key_File"));
        this._tfFile = new KDTextField();
        this._tfFile.setEditable(false);
        this._btnFile = new KDButton(this.getLocalText("Key_Scan"));
        this._btnFile.addActionListener((ActionListener)new ChooseFileAction());
        this._lbImportMode = new KDLabel(this.getLocalText("Key_ImportMode"));
        this._cbImportMode = new KDComboBox((Object[])new String[]{this.getLocalText("Key_ImportMode_Override"), this.getLocalText("Key_ImportMode_Append")});
        this._cbImportMode.setEditable(false);
        this._btnSelAll = new KDButton();
        this._btnSelAll.setIcon((Icon)ResourceManager.getImageIcon((String)"tbtn_SelectAll.gif"));
        this._btnSelAll.setBorder(null);
        this._btnSelAll.setLimitedSize(false);
        this._btnSelAll.setToolTipText(this.getLocalText("Key_SelectAllSheets"));
        this._btnSelAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardIO.this._pnlSheet.setAllSelected(true);
            }
        });
        this._btnUnSelAll = new KDButton();
        this._btnUnSelAll.setIcon((Icon)ResourceManager.getImageIcon((String)"tbtn_deleteall.gif"));
        this._btnUnSelAll.setBorder(null);
        this._btnUnSelAll.setLimitedSize(false);
        this._btnUnSelAll.setToolTipText(this.getLocalText("Key_UnSelectAllSheets"));
        this._btnUnSelAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardIO.this._pnlSheet.setAllSelected(false);
            }
        });
        this._pnlIm = new ImportOptionPanel();
        this._pnlEx = new ExportOptionPanel();
        this._pnlSheet = new SheetListPanel();
        this._btnOk = new KDButton(this.getLocalText("Key_Ok"));
        this._btnOk.addActionListener((ActionListener)new FinishAction());
        this.getRootPane().setDefaultButton((JButton)this._btnOk);
        this._btnCancel = new KDButton(this.getLocalText("Key_Cancel"));
        this._btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardIO.this.closeDialog();
            }
        });
    }

    private void initPanel() {
        Container cp = this.getContentPane();
        cp.setLayout(null);
        cp.add((Component)this._lbFile);
        cp.add((Component)this._tfFile);
        cp.add((Component)this._btnFile);
        this._lbFile.setBounds(10, 10, 460, 20);
        this._tfFile.setBounds(10, 35, 370, 20);
        this._btnFile.setBounds(390, 35, 80, 20);
        cp.add((Component)this._lbImportMode);
        cp.add((Component)this._cbImportMode);
        cp.add((Component)this._btnSelAll);
        cp.add((Component)this._btnUnSelAll);
        this._lbImportMode.setBounds(10, 65, 100, 20);
        this._cbImportMode.setBounds(120, 65, 100, 20);
        this._btnSelAll.setBounds(425, 65, 20, 20);
        this._btnUnSelAll.setBounds(450, 65, 20, 20);
        cp.add((Component)((Object)this._pnlIm));
        cp.add((Component)((Object)this._pnlEx));
        cp.add((Component)((Object)this._pnlSheet));
        this._pnlIm.setLocation(10, 90);
        this._pnlEx.setLocation(10, 90);
        this._pnlSheet.setLocation(240, 90);
        cp.add((Component)this._btnOk);
        cp.add((Component)this._btnCancel);
        this._btnOk.setBounds(300, 250, 80, 20);
        this._btnCancel.setBounds(390, 250, 80, 20);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
        this._context.requestFocus();
    }

    private String getLocalText(String key) {
        return LanguageManager.getLangMessage((String)key, WizzardIO.class, (String)"\u64cd\u4f5c\u5931\u8d25");
    }

    private KDFileChooser createFileChooser() {
        KDFileChooser chsFile = new KDFileChooser();
        chsFile.setDialogTitle(this.getLocalText("Key_File"));
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_KDSZIP);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_KDS);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_XML);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_Excel);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_KDF);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_PDF);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_HTML);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_TXT);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_HTM);
        chsFile.setFileFilter((FileFilter)this.Filter_KDS);
        chsFile.setCurrentDirectory(new File("C:" + File.separator + "rq" + File.separator + "kds"));
        return chsFile;
    }

    public void setForImport(boolean b) {
        this._isForImport = b;
    }

    public boolean prepare() {
        this.setTitle(this.getLocalText(this._isForImport ? "Key_ImportFile" : "Key_ExportFile"));
        this._pnlIm.setVisible(this._isForImport);
        this._pnlEx.setVisible(!this._isForImport);
        this._lbImportMode.setVisible(this._isForImport);
        this._cbImportMode.setVisible(this._isForImport);
        if (this._isForImport) {
            FileFilter ff = this._chsFile.getFileFilter();
            this._chsFile.removeChoosableFileFilter((FileFilter)this.Filter_PDF);
            this._chsFile.removeChoosableFileFilter((FileFilter)this.Filter_HTML);
            this._chsFile.addChoosableFileFilter((FileFilter)this.Filter_KDF);
            if (ff != this.Filter_PDF && ff != this.Filter_HTML) {
                this._chsFile.setFileFilter(ff);
            } else {
                this._chsFile.setFileFilter((FileFilter)this.Filter_XML);
            }
            this._pnlSheet.setData(null);
        } else {
            FileFilter ff = this._chsFile.getFileFilter();
            this._chsFile.removeChoosableFileFilter((FileFilter)this.Filter_KDF);
            this._chsFile.addChoosableFileFilter((FileFilter)this.Filter_PDF);
            this._chsFile.addChoosableFileFilter((FileFilter)this.Filter_HTML);
            if (ff != this.Filter_KDF) {
                this._chsFile.setFileFilter(ff);
            } else {
                this._chsFile.setFileFilter((FileFilter)this.Filter_XML);
            }
            this._pnlSheet.setData(this._context.getBook());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WizzardIO.this._btnFile.requestFocusInWindow();
            }
        });
        return true;
    }

    public void commit() {
    }

    private void openSheetList() {
        String fileName = this._tfFile.getText();
        FileFilter filter = this._chsFile.getFileFilter();
        SimpleFileFilter sff = null;
        if (filter instanceof SimpleFileFilter) {
            sff = (SimpleFileFilter)filter;
        }
        if (this.acceptExtension(sff, fileName, "kdszip")) {
            this._pnlSheet.setData(this.openSheetListFromKdsZip(fileName));
        } else if (this.acceptExtension(sff, fileName, "kds")) {
            this._pnlSheet.setData(this.openSheetListFromKds(fileName));
        } else if (this.acceptExtension(sff, fileName, "xls")) {
            this._pnlSheet.setData(this.openSheetListFromXls(fileName));
        } else if (this.acceptExtension(sff, fileName, "pdf")) {
            WindowUtil.msgboxError((Object)this.getLocalText("Key_UnsupportedFileFormat"), (String)this.getLocalText("Key_UnsupportedFileFormat"), (Component)this._context);
        } else if (this.acceptExtension(sff, fileName, "htm") || this.acceptExtension(sff, fileName, "html")) {
            WindowUtil.msgboxError((Object)this.getLocalText("Key_UnsupportedFileFormat"), (String)this.getLocalText("Key_UnsupportedFileFormat"), (Component)this._context);
        } else if (this.acceptExtension(sff, fileName, "txt")) {
            this._pnlSheet.setData(this.openSheetListFromTxt(fileName));
        } else {
            this._pnlSheet.setData(this.openSheetListFromXml(fileName));
        }
    }

    private Book openSheetListFromKdsZip(String fileName) {
        try {
            return BookIOUtil.loadPackFile(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (KDFException e) {
            e.printStackTrace();
        }
        catch (KDFSAXException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Book openSheetListFromKds(String fileName) {
        try {
            KdsToBook ktb = new KdsToBook();
            return ktb.load(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnOpenFile"), (Component)this._context);
            return null;
        }
    }

    private Book openSheetListFromXml(String fileName) {
        try {
            return BookIOUtil.loadFile(fileName, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnOpenFile"), (Component)this._context);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Book openSheetListFromTxt(String fileName) {
        Book book = Book.Manager.getNewBook((String)"", (int)0);
        Sheet sheet = new Sheet(book, new File(fileName).getName().split("\\.")[0]);
        File file = new File(fileName);
        byte[] bytes = new byte[(int)file.length()];
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            is.read(bytes);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{is});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{is});
        }
        CloseUtil.close((Closeable[])new Closeable[]{is});
        String text = new String(bytes);
        StringWalker.SeperateResult sr = null;
        ArrayList<Character> builder = new ArrayList<Character>();
        if (this._pnlIm._cbTab.isSelected()) {
            builder.add(new Character('\t'));
        }
        if (this._pnlIm._cbSemicolon.isSelected()) {
            builder.add(new Character(';'));
        }
        if (this._pnlIm._cbComma.isSelected()) {
            builder.add(new Character(','));
        }
        if (this._pnlIm._cbBlankspace.isSelected()) {
            builder.add(new Character(' '));
        }
        Object[] characters = builder.toArray();
        char[] chars = new char[characters.length];
        for (int i = 0; i < characters.length; ++i) {
            chars[i] = ((Character)characters[i]).charValue();
        }
        sr = StringWalker.separate2Array((String)text, (char[])chars);
        int rows = sr.getRowCount();
        int cols = sr.getColCount();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                sheet.getCell(i, j, true).setValue(new Variant((Object)sr.getValueAt(i, j)));
            }
        }
        book.addSheet(sheet);
        return book;
    }

    private Book openSheetListFromXls(String fileName) {
        KDSBook kdsbook = null;
        try {
            kdsbook = POIXlsReader.parse2((String)fileName);
        }
        catch (FileNotFoundException e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnOpenFile"), (Component)this._context);
            return null;
        }
        catch (IOException e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnOpenFile"), (Component)this._context);
            return null;
        }
        if (kdsbook != null) {
            return KDSBookToBook.traslate(kdsbook);
        }
        String str = this.getLocalText("Key_UnsupportedFileFormat");
        WindowUtil.msgboxError((Object)str, (String)str, (Component)this._context);
        return null;
    }

    private void transBook() {
        if (this._pnlSheet._book == null) {
            String str = this.getLocalText("Key_NeedOpenFile");
            WindowUtil.msgboxError((Object)str, (String)str, (Component)this._context);
            return;
        }
        if (this._cbImportMode.getSelectedIndex() == 0) {
            this._context.setBook(this._pnlSheet._book);
        } else {
            String[] sns = this._pnlSheet.getSelectedSheets();
            if (sns.length > 0) {
                Book book = this._context.getBook();
                for (int i = 0; i < sns.length; ++i) {
                    Sheet oldSheet = book.getSheet(sns[i]);
                    if (oldSheet == null) {
                        book.addSheet(this._pnlSheet._book.getSheet(i), false);
                        continue;
                    }
                    int index = book.getSheetIndexByName(oldSheet.getSheetName());
                    book.getSheet(index).copySheetFrom(this._pnlSheet._book.getSheet(i));
                }
            }
        }
        this._context.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WizzardIO.this._context.requestFocus();
            }
        });
    }

    private void saveToFile() {
        String fileName = this._tfFile.getText();
        FileFilter filter = this._chsFile.getFileFilter();
        SimpleFileFilter sff = null;
        if (filter instanceof SimpleFileFilter) {
            sff = (SimpleFileFilter)filter;
        }
        if (this.acceptExtension(sff, fileName, "kdszip")) {
            fileName = this.addExtension(fileName, "kdszip");
            this.exportToKdsZip(fileName);
        } else if (this.acceptExtension(sff, fileName, "kds")) {
            fileName = this.addExtension(fileName, "kds");
            this.exportToKds(fileName);
        } else if (this.acceptExtension(sff, fileName, "xls")) {
            fileName = this.addExtension(fileName, "xls");
            this.exportToXls(fileName);
        } else if (this.acceptExtension(sff, fileName, "pdf")) {
            fileName = this.addExtension(fileName, "pdf");
            this.exportToPdf(fileName);
        } else if (this.acceptExtension(sff, fileName, "html")) {
            fileName = this.addExtension(fileName, "html");
            this.exportToHtml(fileName);
        } else if (this.acceptExtension(sff, fileName, "txt")) {
            fileName = this.addExtension(fileName, "txt");
            this.exportToTxt(fileName);
        } else if (this.acceptExtension(sff, fileName, "xml")) {
            fileName = this.addExtension(fileName, "xml");
            this.exportToXml(fileName);
        } else {
            fileName = this.addExtension(fileName, "htm");
            this.exportToXslHtm(fileName);
        }
    }

    private boolean acceptExtension(SimpleFileFilter sff, String fileName, String extension) {
        if (sff != null) {
            return sff.acceptExtension(extension);
        }
        return fileName.toLowerCase(Locale.ENGLISH).endsWith(extension.toLowerCase(Locale.ENGLISH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToTxt(String fileName) {
        String[] sns = this._pnlSheet.getSelectedSheets();
        if (sns.length != 1) {
            WindowUtil.msgboxError((Object)this.getLocalText("Key_Txt_ExportError_Content"), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
            return;
        }
        Sheet sheet = this._pnlSheet._book.getSheet(this._pnlSheet.getSelectedSheets()[0]);
        SortedCellBlockArray ba = new SortedCellBlockArray();
        ba.insert((Object)CellBlock.getNewCellBlock((int)0, (int)0, (int)sheet.getMaxRowIndex(), (int)sheet.getMaxColIndex()));
        String result = KDSTransferable.getClipboardString((Sheet)sheet, (SortedCellBlockArray)ba);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(new File(fileName));
            os.write(result.getBytes());
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{os});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{os});
        }
        CloseUtil.close((Closeable[])new Closeable[]{os});
    }

    private void exportToHtml(String fileName) {
        String[] sns = this._pnlSheet.getSelectedSheets();
        if (sns.length == 0) {
            WindowUtil.msgboxError((Object)"", (String)this.getLocalText("\u81f3\u5c11\u9700\u8981\u9009\u62e9\u4e00\u4e2a\u8868\u9875"), (Component)this._context);
        }
        KDSBook kdsbook = BookToKDSBook.traslate(this._pnlSheet._book, sns);
        PrintableBook prtbook = new PrintableBook(kdsbook);
        try {
            new ExportManager().exportToHtmlFile(prtbook, fileName);
        }
        catch (Exception e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
        }
    }

    private void exportToPdf(String fileName) {
        String[] sns = this._pnlSheet.getSelectedSheets();
        if (sns.length == 0) {
            WindowUtil.msgboxError((Object)"", (String)this.getLocalText("\u81f3\u5c11\u9700\u8981\u9009\u62e9\u4e00\u4e2a\u8868\u9875"), (Component)this._context);
        }
        KDSBook kdsbook = BookToKDSBook.traslate(this._pnlSheet._book, sns);
        PrintableBook prtbook = new PrintableBook(kdsbook);
        new ExportManager().exportToPdfFile(prtbook, fileName);
    }

    private void exportToXls(String fileName) {
        String[] sns = this._pnlSheet.getSelectedSheets();
        if (sns.length == 0) {
            WindowUtil.msgboxError((Object)"", (String)this.getLocalText("\u81f3\u5c11\u9700\u8981\u9009\u62e9\u4e00\u4e2a\u8868\u9875"), (Component)this._context);
        }
        KDSBook kdsbook = BookToKDSBook.traslate(this._pnlSheet._book, sns);
        ExportManager em = new ExportManager();
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"TRUE");
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"FALSE");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
        if (this._pnlEx._rbValueAndExcelFormula.isSelected()) {
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
        } else if (this._pnlEx._rbValueAndFormula.isSelected()) {
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
        } else {
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
        }
        try {
            em.exportToExcel(kdsbook, fileName);
        }
        catch (Exception e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToKdsZip(String fileName) {
        FileOutputStream out = null;
        try {
            byte[] bs = BookIOUtil.pack(this._pnlSheet._book);
            out = new FileOutputStream(fileName);
            out.write(bs);
        }
        catch (IOException e) {
            try {
                WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{out});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{out});
        }
        CloseUtil.close((Closeable[])new Closeable[]{out});
    }

    private void exportToKds(String fileName) {
        try {
            BookToKds btk = new BookToKds();
            btk.export(this._pnlSheet._book, fileName);
        }
        catch (IOException e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
        }
    }

    private void exportToXml(String fileName) {
        try {
            BookIOUtil.saveToFile(this._pnlSheet._book, fileName, this._pnlSheet.getSelectedSheets());
        }
        catch (FileNotFoundException e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
        }
        catch (IOException e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
        }
    }

    private void exportToXslHtm(String fileName) {
        try {
            BookIOUtil.saveToHtmFile(this._pnlSheet._book, fileName, this._pnlSheet.getSelectedSheets());
        }
        catch (FileNotFoundException e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
        }
        catch (IOException e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this._context);
        }
    }

    private String addExtension(String fileName, String extension) {
        if (fileName.toLowerCase(Locale.ENGLISH).endsWith(extension.toLowerCase(Locale.ENGLISH))) {
            return fileName;
        }
        return fileName + "." + extension;
    }

    private class FinishAction
    extends AbstractAction {
        private FinishAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WizzardIO.this._isForImport) {
                WizzardIO.this.transBook();
            } else {
                WizzardIO.this.saveToFile();
            }
            WizzardIO.this.closeDialog();
        }
    }

    private class ChooseFileAction
    extends AbstractAction {
        private ChooseFileAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int ret = WizzardIO.this._chsFile.showOpenDialog((Component)((Object)WizzardIO.this));
            if (ret == 0) {
                File file = WizzardIO.this._chsFile.getSelectedFile();
                String fileName = file.getAbsolutePath();
                WizzardIO.this._tfFile.setText(fileName);
                WizzardIO.this._pnlEx.setStatusForTxt(fileName.toLowerCase(Locale.ENGLISH).endsWith("txt"));
                WizzardIO.this._pnlIm.setStatusForTxt(fileName.toLowerCase(Locale.ENGLISH).endsWith("txt"));
                if (WizzardIO.this._isForImport) {
                    WizzardIO.this.openSheetList();
                }
            }
        }
    }

    private class SheetListPanel
    extends KDScrollPane {
        private KDPanel _pnlList;
        private Book _book;

        SheetListPanel() {
            this.setSize(230, 150);
            this.setBorder(new TitledBorder(WizzardIO.this.getLocalText("Key_Sheet")));
            this.getVerticalScrollBar().setUnitIncrement(25);
            this._pnlList = new KDPanel();
            this.setViewportView((Component)this._pnlList);
        }

        void setData(Book book) {
            this._book = book;
            WizzardIO.this._btnOk.setEnabled(this._book != null);
            this._pnlList.removeAll();
            if (book != null && book.getSheetCount() > 0) {
                int count = book.getSheetCount();
                this._pnlList.setLayout((LayoutManager)new GridLayout(count, 1, 5, 0));
                for (int i = 0; i < count; ++i) {
                    KDCheckBox ck = new KDCheckBox(book.getSheetName(i));
                    this._pnlList.add((Component)ck);
                    ck.setLocation(0, i * 25 + 25);
                    ck.setSelected(true);
                }
                this._pnlList.validate();
            }
        }

        void setAllSelected(boolean b) {
            int count = this._pnlList.getComponentCount();
            for (int i = 0; i < count; ++i) {
                ((KDCheckBox)this._pnlList.getComponent(i)).setSelected(b);
            }
        }

        String[] getSelectedSheets() {
            int count = this._pnlList.getComponentCount();
            ArrayList<String> al = new ArrayList<String>(count);
            for (int i = 0; i < count; ++i) {
                if (!((KDCheckBox)this._pnlList.getComponent(i)).isSelected()) continue;
                al.add(this._book.getSheet(i).getSheetName());
            }
            if (al.size() == 0) {
                return new String[0];
            }
            String[] str = new String[al.size()];
            for (int i = 0; i < str.length; ++i) {
                str[i] = (String)al.get(i);
            }
            return str;
        }
    }

    private class ExportOptionPanel
    extends KDScrollPane {
        private KDRadioButton _rbValueAndFormula;
        private KDRadioButton _rbValue;
        private KDRadioButton _rbValueAndExcelFormula;

        ExportOptionPanel() {
            this.setSize(220, 150);
            this.setBorder(new TitledBorder(WizzardIO.this.getLocalText("Key_ExportOption")));
            this.getVerticalScrollBar().setUnitIncrement(25);
            this._rbValueAndFormula = new KDRadioButton(WizzardIO.this.getLocalText("Key_ValueAndFormula"));
            this._rbValueAndFormula.setSelected(true);
            this._rbValueAndExcelFormula = new KDRadioButton(WizzardIO.this.getLocalText("Key_ValueAndExcelformula"));
            this._rbValue = new KDRadioButton(WizzardIO.this.getLocalText("Key_Value"));
            KDButtonGroup bg = new KDButtonGroup();
            bg.add((AbstractButton)this._rbValueAndFormula);
            bg.add((AbstractButton)this._rbValueAndExcelFormula);
            bg.add((AbstractButton)this._rbValue);
            KDPanel pnl = new KDPanel();
            pnl.setLayout((LayoutManager)new GridLayout(3, 1, 5, 0));
            pnl.add((Component)this._rbValueAndFormula);
            this._rbValueAndExcelFormula.setLocation(0, 0);
            pnl.add((Component)this._rbValueAndExcelFormula);
            this._rbValueAndExcelFormula.setLocation(0, 25);
            pnl.add((Component)this._rbValue);
            this._rbValue.setLocation(0, 50);
            this.setViewportView((Component)pnl);
        }

        void setStatusForTxt(boolean isTxt) {
            this._rbValueAndFormula.setEnabled(!isTxt);
            this._rbValue.setEnabled(!isTxt);
            this._rbValueAndExcelFormula.setEnabled(!isTxt);
            if (isTxt) {
                this._rbValue.setSelected(true);
            } else {
                this._rbValueAndFormula.setSelected(true);
            }
        }
    }

    private class ImportOptionPanel
    extends KDScrollPane {
        private KDRadioButton _rbAll;
        private KDRadioButton _rbValue;
        private KDRadioButton _rbFormula;
        private KDCheckBox _cbTab;
        private KDCheckBox _cbSemicolon;
        private KDCheckBox _cbComma;
        private KDCheckBox _cbBlankspace;
        private KDLabel label;

        ImportOptionPanel() {
            this.setSize(220, 150);
            this.setBorder(new TitledBorder(WizzardIO.this.getLocalText("Key_ImportOption")));
            this.getVerticalScrollBar().setUnitIncrement(25);
            this._rbAll = new KDRadioButton(WizzardIO.this.getLocalText("Key_AllContent"));
            this._rbAll.setSelected(true);
            this._rbValue = new KDRadioButton(WizzardIO.this.getLocalText("Key_Value"));
            this._rbFormula = new KDRadioButton(WizzardIO.this.getLocalText("Key_Formula"));
            this._cbTab = new KDCheckBox(WizzardIO.this.getLocalText("Key_Tab"));
            this._cbSemicolon = new KDCheckBox(WizzardIO.this.getLocalText("Key_Semicolon"));
            this._cbComma = new KDCheckBox(WizzardIO.this.getLocalText("Key_Comma"));
            this._cbBlankspace = new KDCheckBox(WizzardIO.this.getLocalText("Key_Blankspace"));
            this.label = new KDLabel(WizzardIO.this.getLocalText("Key_Separator_Select_Title"));
            this._cbTab.setVisible(false);
            this._cbSemicolon.setVisible(false);
            this._cbComma.setVisible(false);
            this._cbBlankspace.setVisible(false);
            this.label.setVisible(false);
            KDButtonGroup bg = new KDButtonGroup();
            bg.add((AbstractButton)this._rbAll);
            bg.add((AbstractButton)this._rbFormula);
            bg.add((AbstractButton)this._rbValue);
            KDPanel pnlOption = new KDPanel();
            pnlOption.setLayout(null);
            pnlOption.add((Component)this._rbAll);
            this._rbAll.setBounds(0, 10, 80, 20);
            pnlOption.add((Component)this._rbValue);
            this._rbValue.setBounds(0, 50, 80, 20);
            pnlOption.add((Component)this._rbFormula);
            this._rbFormula.setBounds(0, 90, 80, 20);
            pnlOption.add((Component)this._cbTab);
            pnlOption.add((Component)this._cbSemicolon);
            pnlOption.add((Component)this._cbComma);
            pnlOption.add((Component)this._cbBlankspace);
            pnlOption.add((Component)this.label);
            this.label.setBounds(100, 10, 100, 15);
            this._cbTab.setBounds(100, 35, 80, 20);
            this._cbSemicolon.setBounds(100, 55, 80, 20);
            this._cbComma.setBounds(100, 75, 80, 20);
            this._cbBlankspace.setBounds(100, 95, 80, 20);
            this._cbTab.setSelected(true);
            this.setViewportView((Component)pnlOption);
        }

        void setStatusForTxt(boolean isTxt) {
            if (isTxt) {
                this._rbAll.setEnabled(false);
                this._rbValue.setEnabled(false);
                this._rbFormula.setEnabled(false);
                this._rbValue.setSelected(true);
                this._cbTab.setVisible(true);
                this._cbSemicolon.setVisible(true);
                this._cbComma.setVisible(true);
                this._cbBlankspace.setVisible(true);
                this.label.setVisible(true);
            } else {
                this._rbAll.setEnabled(true);
                this._rbValue.setEnabled(true);
                this._rbFormula.setEnabled(true);
                this._rbAll.setSelected(true);
                this._cbTab.setVisible(false);
                this._cbSemicolon.setVisible(false);
                this._cbComma.setVisible(false);
                this._cbBlankspace.setVisible(false);
                this.label.setVisible(false);
            }
        }
    }
}

