/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.kdf;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetOption;
import com.kingdee.bos.ctrl.kdf.common.DocInfo;
import com.kingdee.bos.ctrl.kdf.common.Kdf;
import com.kingdee.bos.ctrl.kdf.common.PrintInfo;
import com.kingdee.bos.ctrl.kdf.common.io.Kdf2Xml;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlReader;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class KdfTransformHandler {
    static final Namespace NS_TABLE = Namespace.getNamespace((String)"t", (String)"http://www.kingdee.com/Table");
    static final Namespace NS_STYLE = Namespace.getNamespace((String)"c", (String)"http://www.kingdee.com/Common");
    private HashMap saCache;

    public void exportToKdf(Book book, String fileName) {
        Kdf kdf = this.getEmptyKdf();
        Element bookElm = this.parserToXml(book, kdf);
        try {
            XmlUtil.saveXmlFile((String)fileName, (Element)bookElm);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Book importFromKdf(String fileName) {
        return this.buildBookFromXml(fileName);
    }

    private Book buildBookFromXml(String fileName) {
        Element xmlDocRoot = null;
        try {
            xmlDocRoot = XmlUtil.loadXmlFile((String)fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (xmlDocRoot == null) {
            return null;
        }
        Book book = null;
        List list = xmlDocRoot.getChildren("Table", xmlDocRoot.getNamespace());
        if (!list.isEmpty()) {
            HashMap styles = this.buildStylesFromXml(xmlDocRoot.getChild("Styles", xmlDocRoot.getNamespace()));
            book = Book.Manager.getNewBook((String)this.parserBookName(fileName), (int)0);
            for (int i = list.size() - 1; i >= 0; --i) {
                Element tableNode = (Element)list.get(i);
                Sheet sheet = this.buildSheetFromXml(tableNode, book, styles);
                book.insertSheet(i, sheet);
            }
        }
        return book;
    }

    private HashMap buildStylesFromXml(Element stylesNode) {
        HashMap<Integer, StyleAttributes> styles = new HashMap<Integer, StyleAttributes>();
        List list = stylesNode.getChildren("Style", NS_STYLE);
        if (!list.isEmpty()) {
            for (int i = list.size() - 1; i >= 0; --i) {
                Element styleNode = (Element)list.get(i);
                StyleAttributes sa = StyleParser.parseSA((Element)styleNode);
                Attribute id = styleNode.getAttribute("id");
                int uid = Integer.parseInt(id.getValue());
                sa.setUID(uid);
                styles.put(new Integer(uid), sa);
            }
        }
        return styles;
    }

    private String parserBookName(String fileName) {
        String name = null;
        int p = fileName.lastIndexOf("\\");
        int p2 = fileName.lastIndexOf(".");
        if (p < 0) {
            p = fileName.length() + 1;
        }
        name = fileName.substring(p + 1, p2);
        return name;
    }

    private Sheet buildSheetFromXml(Element tableNode, Book book, HashMap styles) {
        Element sheetOptionNode;
        Element sheetContentNode;
        Element sheetNode = tableNode.getChild("Sheet", NS_TABLE);
        if (sheetNode == null) {
            return null;
        }
        Sheet sheet = new Sheet(book, "");
        String id = tableNode.getAttributeValue("id", NS_TABLE);
        if (!this.isEmptyString(id)) {
            sheet.setName(id);
        }
        if ((sheetContentNode = sheetNode.getChild("Table", NS_TABLE)) != null) {
            this.buildTableFromXml(sheetContentNode, sheet, styles);
        }
        if ((sheetOptionNode = sheetNode.getChild("SheetOptions", NS_TABLE)) != null) {
            this.buildSheetOptionsFromXml(sheetOptionNode, sheet);
        }
        return sheet;
    }

    private void buildSheetOptionsFromXml(Element sheetOptionNode, Sheet sheet) {
        Element gridLineNode;
        Element selectionNode;
        Element mergerNode = sheetOptionNode.getChild("MergeBlocks", NS_TABLE);
        if (mergerNode != null) {
            this.buildMergerFromXml(mergerNode, sheet.getSheetOption().getMerger(true));
        }
        if ((selectionNode = sheetOptionNode.getChild("Selections", NS_TABLE)) != null) {
            this.buildSelectionFromXml(selectionNode, sheet.getSheetOption().getSelection());
            Element activeCellNode = sheetOptionNode.getChild("ActiveCell", NS_TABLE);
            if (activeCellNode != null) {
                this.buildActiveCellFromXml(activeCellNode, sheet.getSheetOption().getSelection());
            }
        }
        if ((gridLineNode = sheetOptionNode.getChild("GridLine", NS_TABLE)) != null) {
            this.buildGridLineFromXml(gridLineNode, sheet.getSheetOption());
        }
    }

    private void buildGridLineFromXml(Element gridLineNode, SheetOption sheetOption) {
        Attribute vertical = gridLineNode.getAttribute("bodyVertical", NS_TABLE);
        Attribute horizon = gridLineNode.getAttribute("bodyHorizon", NS_TABLE);
        try {
            boolean hasV = vertical.getBooleanValue();
            boolean hasH = horizon.getBooleanValue();
            sheetOption.setShowVertLines(hasV);
            sheetOption.setShowHoriLines(hasH);
        }
        catch (Exception e) {
            return;
        }
    }

    private void buildActiveCellFromXml(Element activeCellNode, Selection sel) {
        Attribute rowAttri = activeCellNode.getAttribute("row", NS_TABLE);
        Attribute colAttri = activeCellNode.getAttribute("column", NS_TABLE);
        int row = Integer.parseInt(rowAttri.getValue());
        int col = Integer.parseInt(colAttri.getValue());
        Selection.SelectIterator it = sel.getSelectIterator();
        int i = 0;
        while (it.hasNext()) {
            if (it.next().contains(row, col)) {
                // empty if block
            }
            ++i;
        }
    }

    private void buildSelectionFromXml(Element selectionNode, Selection sel) {
        List list = selectionNode.getChildren("Block", NS_TABLE);
        for (int i = list.size() - 1; i >= 0; --i) {
            Element block = (Element)list.get(i);
            int row = Integer.parseInt(block.getAttribute("top", NS_TABLE).getValue());
            int row2 = Integer.parseInt(block.getAttribute("bottom", NS_TABLE).getValue());
            int col = Integer.parseInt(block.getAttribute("left", NS_TABLE).getValue());
            int col2 = Integer.parseInt(block.getAttribute("right", NS_TABLE).getValue());
            sel.changeSelection(CellBlock.getNewCellBlock((int)row, (int)col, (int)row2, (int)col2), 1);
        }
    }

    private void buildMergerFromXml(Element mergerNode, MergeBlocks merger) {
        Element e = mergerNode.getChild("Body", NS_TABLE);
        if (e != null) {
            List list = e.getChildren("Block", NS_TABLE);
            for (int i = list.size() - 1; i >= 0; --i) {
                Element block = (Element)list.get(i);
                int row = Integer.parseInt(block.getAttribute("top", NS_TABLE).getValue());
                int row2 = Integer.parseInt(block.getAttribute("bottom", NS_TABLE).getValue());
                int col = Integer.parseInt(block.getAttribute("left", NS_TABLE).getValue());
                int col2 = Integer.parseInt(block.getAttribute("right", NS_TABLE).getValue());
                merger.insert((Object)CellBlock.getNewCellBlock((int)row, (int)col, (int)row2, (int)col2));
            }
        }
    }

    private void buildTableFromXml(Element nodeinnerTable, Sheet sheet, HashMap styles) {
        Element e = nodeinnerTable.getChild("Body", NS_TABLE);
        this.buildBodyFromXml(e, sheet);
    }

    private void buildBodyFromXml(Element e, Sheet sheet) {
        Element rowNode = null;
        List list1 = e.getChildren("Row", NS_TABLE);
        int i = 0;
        int rowIndex = 0;
        while (i < list1.size()) {
            rowNode = (Element)list1.get(i);
            String indexvalue = rowNode.getAttributeValue("index", NS_TABLE);
            if (!this.isEmptyString(indexvalue)) {
                rowIndex = Integer.parseInt(indexvalue);
            }
            Row row = sheet.getRow(rowIndex, true);
            List list2 = rowNode.getChildren("Cell", NS_TABLE);
            int j = 0;
            int cellIndex = 0;
            while (j < list2.size()) {
                Element cellNode = (Element)list2.get(j);
                row.getCell(j, true);
                String value = cellNode.getAttributeValue("index", NS_TABLE);
                if (!this.isEmptyString(value)) {
                    cellIndex = Integer.parseInt(value);
                }
                Cell cell = row.getCell(cellIndex, true);
                this.buildCellFromXml(cellNode, cell);
                ++j;
                ++cellIndex;
            }
            ++i;
            ++rowIndex;
        }
    }

    private void buildCellFromXml(Element cellNode, Cell cell) {
        if (cellNode.getChildren().size() == 0) {
            String attVal = cellNode.getText();
            if (attVal != null) {
                cell.setFormula(attVal);
            }
            return;
        }
        Element node = cellNode.getChild("Value", NS_TABLE);
        String cellValue = null;
        if (node != null) {
            cellValue = node.getText();
        }
        cell.setFormula(cellValue);
    }

    private Element parserToXml(Book book, Kdf kdf) {
        Element rootElement = Kdf2Xml.makeDocRoot((Kdf)kdf);
        rootElement.addNamespaceDeclaration(NS_TABLE);
        this.parserSpreadToXml(book, rootElement);
        StyleParser.writeStyles((Element)this.getStylesNode(rootElement), (Namespace)KDFXmlReader.NS_COMMON, this.getSaCache().entrySet().iterator());
        return rootElement;
    }

    final Element getStylesNode(Element rootElement) {
        Element nodeStyles = rootElement.getChild("Styles", rootElement.getNamespace());
        if (null == nodeStyles) {
            nodeStyles = new Element("Styles", rootElement.getNamespace());
            rootElement.addContent((Content)nodeStyles);
        }
        return nodeStyles;
    }

    private void parserSpreadToXml(Book book, Element rootElement) {
        for (int i = 0; i < book.getSheetCount(); ++i) {
            this.parserSheetToXml(book.getSheet(i), rootElement);
        }
    }

    private void parserSheetToXml(Sheet sheet, Element rootElement) {
        Element nodeTable = new Element("Table", rootElement.getNamespace());
        rootElement.addContent((Content)nodeTable);
        nodeTable.setAttribute("id", sheet.getSheetName(), NS_TABLE);
        Element nodeDataStyles = new Element("DataStyles", NS_TABLE);
        nodeTable.addContent((Content)nodeDataStyles);
        Element nodeSheet = new Element("Sheet", NS_TABLE);
        nodeTable.addContent((Content)nodeSheet);
        nodeSheet.setAttribute("name", "NotSupportedInThisVersion", NS_TABLE);
        Element nodeTable2 = new Element("Table", NS_TABLE);
        this.parserSheetTableToXml(nodeTable2, sheet);
        nodeSheet.addContent((Content)nodeTable2);
        Element nodeOptions = new Element("SheetOptions", NS_TABLE);
        this.parserSheetOptionToXml(nodeOptions);
        nodeSheet.addContent((Content)nodeOptions);
    }

    private void parserSheetTableToXml(Element nodeTable, Sheet sheet) {
        this.setTableAttributes(nodeTable, sheet);
        Element nodeBody = new Element("Body", NS_TABLE);
        this.parserSheetBodyToXml(nodeBody, sheet);
        nodeTable.addContent((Content)nodeBody);
    }

    private void parserSheetBodyToXml(Element nodeBody, Sheet sheet) {
        boolean isNeedRowIndex = false;
        int rowCount = sheet.getMaxRowIndex();
        for (int i = 0; i <= rowCount; ++i) {
            Row row = sheet.getRow(i, false);
            if (row == null || row.isNull()) {
                isNeedRowIndex = true;
                continue;
            }
            Element nodeRow = new Element("Row", nodeBody.getNamespace());
            if (isNeedRowIndex) {
                nodeRow.setAttribute("index", String.valueOf(i), NS_TABLE);
                isNeedRowIndex = false;
            }
            this.parserRowToXml(nodeRow, row, sheet);
            nodeBody.addContent((Content)nodeRow);
        }
    }

    private void parserRowToXml(Element nodeRow, Row row, Sheet sheet) {
        boolean isNeedCellIndex = false;
        this.setNodeAttribute(nodeRow, "styleID", this.addSSA(sheet.getRowSSA(row.getIntMark())));
        int colCount = sheet.getMaxColIndex();
        for (int i = 0; i <= colCount; ++i) {
            Cell cell = row.getAt(i);
            if (cell == null || cell.isEmptyContent()) {
                isNeedCellIndex = true;
                continue;
            }
            Element nodeCell = new Element("Cell", NS_TABLE);
            if (isNeedCellIndex) {
                nodeCell.setAttribute("index", String.valueOf(i), NS_TABLE);
                isNeedCellIndex = false;
            }
            this.parserCellToXml(nodeCell, cell);
            nodeRow.addContent((Content)nodeCell);
        }
    }

    private void parserCellToXml(Element nodeCell, Cell cell) {
        if (null == cell || cell.isEmptyContent()) {
            return;
        }
        Element node = null;
        String value = cell.getFormula();
        node = new Element("Value", NS_TABLE);
        node.setText(value);
        nodeCell.addContent((Content)node);
        int type = 0;
        type = cell.getValue().getVt();
        this.setNodeAttribute(nodeCell, "type", String.valueOf(type));
        ShareStyleAttributes ssa = cell.getSSA();
        if (ssa != null) {
            this.setNodeAttribute(nodeCell, "styleID", this.addSSA(ssa));
        }
    }

    private void parserSheetOptionToXml(Element nodeOptions) {
    }

    private void setTableAttributes(Element nodeTable, Sheet sheet) {
        this.setNodeAttribute(nodeTable, "name", sheet.getSheetName());
        this.setNodeAttribute(nodeTable, "styleID", this.addSSA(sheet.getSSA()));
    }

    private Kdf getEmptyKdf() {
        Kdf kdf = new Kdf();
        kdf.setDocInfo(DocInfo.newDefaultInstance());
        kdf.setDataSources(new HashMap());
        kdf.setPrintInfo(PrintInfo.newDefaultInstance());
        kdf.setStyles(new HashMap());
        return kdf;
    }

    private boolean isEmptyString(String value) {
        return null == value || value.trim().equals("");
    }

    private void setNodeAttribute(Element node, String attrName, String value) {
        if (StringUtil.isEmptyString((String)attrName) || StringUtil.isEmptyString((String)value)) {
            return;
        }
        node.setAttribute(attrName, value, NS_TABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addSSA(ShareStyleAttributes ssa) {
        this.getSaCache();
        Integer key = new Integer(ssa.getUID());
        HashMap hashMap = this.saCache;
        synchronized (hashMap) {
            if (this.saCache.get(key) == null) {
                this.saCache.put(key, ssa);
            }
        }
        return key.toString();
    }

    private HashMap getSaCache() {
        if (this.saCache == null) {
            this.saCache = new HashMap();
        }
        return this.saCache;
    }
}

