/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.model.DateTimeModel;
import com.kingdee.bos.ctrl.swing.model.IDateTimeModel;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeDatePickerDownListUI;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class DatePickerDownList
extends JComponent
implements IKDEditor,
IKDComponent,
IKDTextComponent {
    private static final long serialVersionUID = 3369140151590632426L;
    private static final String uiClassID = "DatePickerDownListUI";
    private Object userObject = null;
    private IDateTimeModel model = null;
    private Icon todayIcon = null;
    private ModelDataChangeListener modelListener = null;
    private boolean timeEditorEnabled = false;
    private boolean nullValueEnabled = false;
    private Date maxSelfDate = null;
    private Date minSelfDate = null;
    private boolean required = false;
    private boolean isDecorateButton = true;

    public DatePickerDownList() {
        this(null);
    }

    public DatePickerDownList(IDateTimeModel model) {
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys(this, KeyStroke.getKeyStroke(10, 0));
        if (model == null) {
            this.createDefaultModel();
        } else {
            this.model = model;
        }
        this.setFocusable(true);
        this.setOpaque(true);
        this.updateUI();
    }

    public void setModel(IDateTimeModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model is not null.");
        }
        IDateTimeModel oldModel = this.getModel();
        if (oldModel != model) {
            this.model = model;
            oldModel = null;
            if (this.modelListener != null) {
                this.model.addChangeListener(this.modelListener);
            }
            this.firePropertyChange("model", oldModel, model);
            this.repaint();
            this.revalidate();
        }
    }

    public IDateTimeModel getModel() {
        return this.model;
    }

    public void setMilliSecondEnable(boolean b) {
        if (this.getModel().isMillisecondEnable() == b) {
            return;
        }
        boolean old = this.getModel().isMillisecondEnable();
        this.getModel().setMilliSecondEnable(b);
        try {
            this.getUI().reSetSpinnerFormat();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.firePropertyChange("milliSecondEnabled", (Object)old, (Object)b);
    }

    protected void createDefaultModel() {
        this.model = new DateTimeModel();
        this.model.setDateEnable(true);
        this.model.setTimeEnable(true);
        this.model.setMilliSecondEnable(false);
    }

    @Override
    public void addDataChangeListener(DataChangeListener listener) {
        if (this.modelListener == null) {
            this.modelListener = new ModelDataChangeListener();
            this.getModel().addChangeListener(this.modelListener);
        }
        this.listenerList.add(DataChangeListener.class, listener);
    }

    protected void fireDataChanged(DataChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataChangeListener.class || event == null) continue;
            ((DataChangeListener)listeners[i + 1]).dataChanged(event);
        }
    }

    public void addActionListener(ActionListener l) {
        this.getUI().addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.getUI().removeActionListener(l);
    }

    public void setDecorateButton(boolean b) {
        boolean oldU = this.isDecorateButton();
        if (oldU != b) {
            this.isDecorateButton = b;
            this.firePropertyChange("isDecorateButton", (Object)oldU, (Object)b);
        }
    }

    public boolean isDecorateButton() {
        return this.isDecorateButton;
    }

    @Override
    public Object getValue() {
        if (this.getModel().isEmptyValue()) {
            return null;
        }
        return this.getModel().getValue();
    }

    @Override
    public boolean isDisplay() {
        return this.isVisible();
    }

    @Override
    public void removeDataChangeListener(DataChangeListener listener) {
        this.listenerList.remove(DataChangeListener.class, listener);
    }

    @Override
    public void setDisplay(boolean isDisplay) {
        this.setVisible(isDisplay);
    }

    @Override
    public void setValue(Object value) {
        if (value != null && !(value instanceof Date)) {
            throw new ClassCastException(value.getClass() + " class is not supported.");
        }
        this.getModel().setValue((Date)value);
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public KingdeeDatePickerDownListUI getUI() {
        return (KingdeeDatePickerDownListUI)this.ui;
    }

    public void setUI(KingdeeDatePickerDownListUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI((KingdeeDatePickerDownListUI)UIManager.getUI(this));
    }

    public void setSelectedIcon(Icon icon) {
    }

    public Icon getSelectedIcon() {
        return null;
    }

    public void setTodayIcon(Icon icon) {
    }

    public Icon getTodayIcon() {
        return this.todayIcon;
    }

    public void setTimeEditorEnabled(boolean b) {
        boolean old = this.isTimeEditorEnabled();
        if (old != b) {
            this.timeEditorEnabled = b;
            this.firePropertyChange("timeEditorEnabled", (Object)old, (Object)b);
        }
    }

    public boolean isTimeEditorEnabled() {
        return this.timeEditorEnabled;
    }

    public boolean isNullValueEnabled() {
        return this.nullValueEnabled;
    }

    public void setNullValueEnabled(boolean b) {
        boolean old = this.isNullValueEnabled();
        if (old != b) {
            this.nullValueEnabled = b;
            this.firePropertyChange("nullValueEnabled", (Object)old, (Object)b);
        }
    }

    public boolean mouseDoubleClicked(int x, int y) {
        return this.getUI().mouseSelectedDay(x, y);
    }

    @Override
    public void setEditable(boolean b) {
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    public void setMaximumDate(Date newMaxDate) {
        Date old = this.maxSelfDate;
        if (!CtrlSwingUtilities.judgeEqualsDateObj(newMaxDate, old)) {
            this.maxSelfDate = newMaxDate;
            this.firePropertyChange("maxDateValue", old, this.maxSelfDate);
        }
    }

    public void commitComfirm() {
        this.getUI().commitComfirm();
    }

    public Date getMaximumDate() {
        return this.maxSelfDate;
    }

    public void setMinimumDate(Date newMinDate) {
        Date old = this.minSelfDate;
        if (!CtrlSwingUtilities.judgeEqualsDateObj(newMinDate, old)) {
            this.minSelfDate = newMinDate;
            this.firePropertyChange("minDateValue", old, this.minSelfDate);
        }
    }

    public Date getMinimumDate() {
        return this.minSelfDate;
    }

    public void doFocus() {
        this.getUI().doFocus();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
        Map additionalValues = (Map)s.readObject();
        this.model = (IDateTimeModel)additionalValues.get("model");
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        HashMap<String, IDateTimeModel> additionalValues = new HashMap<String, IDateTimeModel>(1);
        IDateTimeModel model = this.getModel();
        if (model instanceof Serializable) {
            additionalValues.put("model", model);
        }
        s.writeObject(additionalValues);
        s.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    @Override
    public void setAccessAuthority(int authority) {
    }

    @Override
    public int getAccessAuthority() {
        return 0;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        boolean oldValue = this.required;
        this.required = required;
        this.firePropertyChange("required", new Boolean(oldValue), new Boolean(required));
    }

    public void setSundayFirst(boolean sundayFirst) {
        if (this.getUI() != null) {
            this.getUI().setSundayFirst(sundayFirst);
        }
    }

    public boolean isSundayFirst() {
        if (this.getUI() != null) {
            return this.getUI().isSundayFirst();
        }
        return true;
    }

    static {
        UIManager.getDefaults().put(uiClassID, "com.kingdee.bos.ctrl.swing.plaf.KingdeeDatePickerDownListUI");
    }

    private class ModelDataChangeListener
    implements DataChangeListener {
        private ModelDataChangeListener() {
        }

        @Override
        public void dataChanged(DataChangeEvent e) {
            DatePickerDownList.this.fireDataChanged(e);
        }
    }
}

