/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.ComboColorDownList;
import com.kingdee.bos.ctrl.swing.IKDComboColor;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.ComboColorPopupClosedListener;
import com.kingdee.bos.ctrl.swing.event.ComboColorSelectedListener;
import com.kingdee.bos.ctrl.swing.event.ComboColorViewPicClickListener;
import com.kingdee.bos.ctrl.swing.event.ComboColorWillPopupListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.model.ComboColorSelectionModel;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeComboColorUI;
import java.awt.Color;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.colorchooser.ColorSelectionModel;

public class KDComboColor
extends JComponent
implements IKDComboColor,
IKDComponent,
IKDEditor {
    private static final long serialVersionUID = -4643745230133456502L;
    public static final Color TRANSPARENTCOLOR = new Color(255, 255, 255, 0);
    public static final int VIEW_PURE = 1;
    public static final int VIEW_PIC = 2;
    protected Object userObject;
    private int viewType;
    private static final String uiClassID = "KingdeeComboColorUI";
    private ColorSelectionModel selectionModel;
    private ComboColorDownList comboColorDownList;
    private ImageIcon pictureForViewPic = null;
    private PropertyChangeListener downListSelectedColorChangeHandler = new DownListSelectedColorChangeHandler();
    private Insets customInsets;

    public KDComboColor(Color c, Color defaultColor, int viewType) {
        this.setSelectionModel(new ComboColorSelectionModel(c));
        this.setViewType(viewType);
        this.createDownList();
        this.setDefaultColor(defaultColor);
        this.updateUI();
        this.getComboColorDownList().addPropertyChangeListener(this.downListSelectedColorChangeHandler);
        this.setFocusable(true);
    }

    public KDComboColor(Color c, Color defaultColor, int viewType, boolean isUsedColorUI) {
        this.setSelectionModel(new ComboColorSelectionModel(c));
        this.setViewType(viewType);
        this.createDownList(isUsedColorUI);
        this.setDefaultColor(defaultColor);
        this.updateUI();
        this.getComboColorDownList().addPropertyChangeListener(this.downListSelectedColorChangeHandler);
        this.setFocusable(true);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ((KingdeeComboColorUI)this.ui).closePopup();
    }

    public KDComboColor(Color c, Color defaultColor) {
        this(c, defaultColor, 1);
    }

    public KDComboColor(Color c) {
        this(c, Color.BLACK, 1);
    }

    public KDComboColor(int viewType) {
        this(Color.BLACK, Color.BLACK, viewType);
    }

    public KDComboColor(int viewType, boolean isUsedColorUI) {
        this(Color.BLACK, Color.BLACK, viewType, isUsedColorUI);
    }

    public KDComboColor() {
        this(Color.BLACK, Color.BLACK, 1);
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public void addDataChangeListener(DataChangeListener listener) {
        this.listenerList.add(DataChangeListener.class, listener);
    }

    protected void fireDataChanged(Object source, Object newValue, Object oldValue) {
        Object[] listeners = this.listenerList.getListenerList();
        DataChangeEvent changeEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataChangeListener.class) continue;
            if (null == changeEvent) {
                changeEvent = new DataChangeEvent(source.getClass());
            }
            changeEvent.setNewValue(newValue);
            changeEvent.setOldValue(oldValue);
            ((DataChangeListener)listeners[i + 1]).dataChanged(changeEvent);
        }
    }

    @Override
    public Object getValue() {
        return this.getSelectionModel().getSelectedColor();
    }

    @Override
    public boolean isDisplay() {
        return this.isVisible();
    }

    @Override
    public void removeDataChangeListener(DataChangeListener listener) {
        this.listenerList.remove(DataChangeListener.class, listener);
    }

    @Override
    public void setDisplay(boolean isDisplay) {
        this.setVisible(isDisplay);
    }

    @Override
    public void setValue(Object value) {
        if (value != null && !(value instanceof Color)) {
            throw new IllegalArgumentException("value is illegal.");
        }
        this.getSelectionModel().setSelectedColor((Color)value);
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return super.getInsets();
    }

    @Override
    public Color getColor() {
        return this.getSelectionModel().getSelectedColor();
    }

    @Override
    public void setColor(Color c) {
        Color oldColor = this.getColor();
        this.getSelectionModel().setSelectedColor(c);
        this.firePropertyChange("selectedColor", oldColor, c);
    }

    @Override
    public ColorSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(ColorSelectionModel model) {
        ColorSelectionModel oldModel = this.selectionModel;
        this.selectionModel = model;
        if (this.comboColorDownList != null) {
            this.comboColorDownList.setSelectionModel(model);
        }
        this.firePropertyChange("selectionModel", oldModel, model);
    }

    @Override
    public void setViewType(int view) {
        int old = this.viewType;
        if (view != old) {
            this.viewType = view;
            this.firePropertyChange("viewType", old, view);
        }
    }

    @Override
    public int getViewType() {
        return this.viewType;
    }

    public Color getDefaultColor() {
        return this.comboColorDownList.getDefaultColor();
    }

    @Override
    public void setDefaultColor(Color defaultColor) {
        this.comboColorDownList.setDefaultColor(defaultColor);
    }

    public String getDefaultColorPrompt() {
        return this.comboColorDownList.getDefaultColorPrompt();
    }

    public void setDefaultColorPrompt(String string) {
        this.comboColorDownList.setDefaultColorPrompt(string);
    }

    protected void createDownList() {
        if (this.comboColorDownList == null) {
            this.comboColorDownList = new ComboColorDownList(this.getSelectionModel());
        }
    }

    protected void createDownList(boolean isUsedColorUI) {
        if (this.comboColorDownList == null) {
            this.comboColorDownList = new ComboColorDownList(this.getSelectionModel(), true);
        }
    }

    public ComboColorDownList getComboColorDownList() {
        return this.comboColorDownList;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    public ImageIcon getPictureForViewPic() {
        return this.pictureForViewPic;
    }

    public void setPictureForViewPic(ImageIcon icon) {
        ImageIcon old = this.getPictureForViewPic();
        if (!icon.equals(old)) {
            this.pictureForViewPic = icon;
            this.firePropertyChange("pictureForViewPic", old, icon);
        }
    }

    public void setPopupVisible(boolean b) {
        if (this.ui instanceof KingdeeComboColorUI) {
            ((KingdeeComboColorUI)this.ui).setPopupVisible(b);
        }
    }

    public void addWillPopupListener(ComboColorWillPopupListener l) {
        this.listenerList.add(ComboColorWillPopupListener.class, l);
    }

    public void removeWillPopupListener(ComboColorWillPopupListener l) {
        this.listenerList.remove(ComboColorWillPopupListener.class, l);
    }

    public void addPopupClosedListener(ComboColorPopupClosedListener l) {
        this.listenerList.add(ComboColorPopupClosedListener.class, l);
    }

    public void removePopupClosedListener(ComboColorPopupClosedListener l) {
        this.listenerList.remove(ComboColorPopupClosedListener.class, l);
    }

    public void addViewPicClickListener(ComboColorViewPicClickListener l) {
        this.listenerList.add(ComboColorViewPicClickListener.class, l);
    }

    public void removeViewPicClickListener(ComboColorViewPicClickListener l) {
        this.listenerList.remove(ComboColorViewPicClickListener.class, l);
    }

    public void addSelectedListener(ComboColorSelectedListener l) {
        this.comboColorDownList.addSelectedListener(l);
    }

    public void removeSelectedListener(ComboColorSelectedListener l) {
        this.comboColorDownList.removeSelectedListener(l);
    }

    public void addUsedColorPersistence(IUsedColorPersistence i) {
        this.comboColorDownList.addUsedColorPersistence(i);
    }

    static {
        UIManager.getDefaults().put(uiClassID, "com.kingdee.bos.ctrl.swing.plaf.KingdeeComboColorUI");
    }

    public static interface IUsedColorPersistence {
        public void save(LinkedList<Color> var1);

        public LinkedList<Color> load();
    }

    private class DownListSelectedColorChangeHandler
    implements PropertyChangeListener {
        private DownListSelectedColorChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("selectedColor")) {
                KDComboColor.this.firePropertyChange("selectedColor", evt.getOldValue(), evt.getNewValue());
                KDComboColor.this.fireDataChanged(KDComboColor.this.getSelectionModel(), evt.getNewValue(), evt.getOldValue());
            }
        }
    }
}

