/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.dial.BasicDial;
import com.kingdee.bos.ctrl.swing.dial.CustomDialLegend;
import com.kingdee.bos.ctrl.swing.dial.CustomDialRange;
import com.kingdee.bos.ctrl.swing.dial.CustomDialScale;
import com.kingdee.bos.ctrl.swing.dial.DialScale;
import com.kingdee.bos.ctrl.swing.dial.DialTitle;
import com.kingdee.bos.ctrl.swing.dial.KpiNeedle;
import com.kingdee.bos.ctrl.swing.dial.KpiPan;
import com.kingdee.bos.ctrl.swing.dial.KpiTitle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.text.DecimalFormat;
import java.text.Format;

public class KDCustomDial
extends BasicDial
implements IKDComponent {
    private static final long serialVersionUID = 4003452577322196072L;
    private static final String DEFAULTKEY = "0";
    protected Object userObject;
    protected static final int PANRADIUS_NORMAL = 60;
    protected static final double RADIUS_HEIGHT = 0.8783783783783784;

    public KDCustomDial(CustomDialRange range, String title) {
        this.init(range, title);
    }

    public KDCustomDial(CustomDialRange[] ranges, String title) {
        if (ranges.length > 0) {
            this.init(ranges[0], title);
        }
        if (ranges.length > 1) {
            for (int i = 1; i < ranges.length; ++i) {
                this.getScale().addRange(ranges[i]);
            }
        }
    }

    public void init(CustomDialRange range, String title) {
        KpiPan bottomPan = new KpiPan();
        KpiNeedle ndl = new KpiNeedle();
        DecimalFormat ft = new DecimalFormat("###'%'");
        CustomDialScale scale = new CustomDialScale(null, 0, 0, 180);
        scale.setTicksPaint(Color.GRAY);
        scale.setTickLabelPaint(Color.WHITE);
        scale.setTickLabelFormat(ft);
        scale.addRange(range);
        scale.setTotalRange(range);
        KpiTitle ttl = new KpiTitle(title);
        ndl.setScale(scale);
        this.addNeedle(ndl, DEFAULTKEY);
        this.addScale(scale, DEFAULTKEY);
        this.setPan(bottomPan);
        this.setTitle(ttl);
        this.setSize(this.getPreferredSize());
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public CustomDialLegend createLegend() {
        CustomDialLegend legend = CustomDialLegend.createInstance(this.getScale().getRangeList(), 1);
        return legend;
    }

    public CustomDialLegend createLegend(int orientation) {
        CustomDialLegend legend = CustomDialLegend.createInstance(this.getScale().getRangeList(), orientation);
        return legend;
    }

    @Override
    protected void drawTitle(Graphics2D g2) {
        super.drawTitle(g2);
        KpiTitle ttl = this.getKpiTitle();
        Rectangle ttlR = ttl.getRect();
        g2.setPaint(ttl.getOutlinePaint());
        g2.drawLine(ttlR.x, ttlR.y + ttlR.height - 1, ttlR.x + ttlR.width - 1, ttlR.y + ttlR.height - 1);
        g2.drawLine(ttlR.x, ttlR.y + ttlR.height * 2 / 3, ttlR.x, ttlR.y + ttlR.height - 1);
        g2.drawLine(ttlR.x + ttlR.width - 1, ttlR.y + ttlR.height * 2 / 3, ttlR.x + ttlR.width - 1, ttlR.y + ttlR.height - 1);
    }

    @Override
    protected String generateToolTip() {
        DialScale scl = this.getScale(0);
        Format ft = null;
        Object val = null;
        String tip = "";
        if (scl != null) {
            ft = scl.getTickLabelFormat();
        }
        if (ft != null) {
            val = this.getValue();
        }
        if (val != null) {
            tip = ft.format(val);
        }
        return tip;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int i;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.isOpaque()) {
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, width, height);
        }
        Insets ins = this.getInsets();
        Rectangle area = new Rectangle(ins.top, ins.left, width -= ins.left + ins.right, height -= ins.top + ins.bottom);
        Rectangle panR = new Rectangle();
        Rectangle ttlR = new Rectangle();
        this.calcElementRect(area, panR, ttlR);
        if (this.pan != null) {
            this.pan.draw(g, panR, this);
        }
        if (this.scales != null) {
            for (i = 0; i < this.scales.size(); ++i) {
                BasicDial.ScaleItem si = (BasicDial.ScaleItem)this.scales.get(i);
                si.scale.draw(g, panR, this);
            }
        }
        if (this.indicators != null) {
            for (i = 0; i < this.indicators.size(); ++i) {
                BasicDial.IndicatorItem ii = (BasicDial.IndicatorItem)this.indicators.get(i);
                ii.indicator.draw(g, area, this);
            }
        }
        if (this.needles != null) {
            for (i = 0; i < this.needles.size(); ++i) {
                BasicDial.NeedleItem ni = (BasicDial.NeedleItem)this.needles.get(i);
                ni.needle.draw(g, panR, this);
            }
        }
        DialTitle ttl = this.getTitle();
        ttl.setRect(ttlR);
        this.drawTitle(g2);
    }

    private void calcElementRect(Rectangle area, Rectangle panR, Rectangle ttlR) {
        int r = (area.width - 1) / 2;
        int rfromh = (int)((double)(area.height - 19) * 0.8783783783783784);
        if (r > rfromh) {
            r = rfromh;
        }
        panR.width = 2 * r + 1;
        panR.height = (int)((double)r / 0.8783783783783784);
        int h = 19 + panR.height;
        panR.x = area.x + (area.width - panR.width) / 2;
        panR.y = area.y + (area.height - h) / 2;
        ttlR.x = panR.x;
        ttlR.y = panR.y + panR.height;
        ttlR.height = 19;
        ttlR.width = panR.width;
    }

    public CustomDialScale getScale() {
        return (CustomDialScale)this.getScale(0);
    }

    public KpiNeedle getNeedle() {
        return (KpiNeedle)super.getNeedle(0);
    }

    public void clear() {
        this.setValue(null);
        this.getScale().clearRanges();
        this.repaint();
    }

    public KpiTitle getKpiTitle() {
        return (KpiTitle)super.getTitle();
    }

    public KpiPan getKpiPan() {
        return (KpiPan)super.getPan();
    }
}

