/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.common.util.EASEditionUtil;
import com.kingdee.bos.ctrl.swing.LittleArrowButton;
import com.kingdee.bos.ctrl.swing.SimpleMenuBarConstraints;
import com.kingdee.bos.ctrl.swing.SimpleMenuBarLayout;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeBorders;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class KDMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 2210621314523556835L;
    private Icon easIcon = null;
    private JLabel iconLab = null;
    private JLabel logoText = null;
    private HashMap selfMap = null;
    public static final String RIGHTTOP_KEY = "righttop";
    public static final String LEFTBOT_KEY = "leftbot";
    public static final String EASLOGO = "easlogo";
    private static final int MENUINTERVAL = 0;

    public KDMenuBar() {
        this.init();
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
    }

    private void init() {
        this.setLayout(new SimpleMenuBarLayout());
        this.createLogoLab();
        this.setLogo();
        this.verifyEditionType();
        this.addDefaultHidenButton();
        this.setBorder(null);
    }

    private void verifyEditionType() {
        int editionType = 0;
        try {
            editionType = EASEditionUtil.getEditionType();
        }
        catch (Exception e) {
            Logger.global.log(Level.WARNING, "\u83b7\u53d6\u7248\u672c\u7c7b\u578b\u5931\u8d25\uff01\u9ed8\u8ba4\u4f7f\u7528\u4f01\u4e1a\u7248\u3002" + e);
        }
        switch (editionType) {
            case 1: 
            case 2: 
            case 3: {
                this.addLogo(editionType, "backcons", "backcons");
                break;
            }
            default: {
                this.addLogo(editionType, "EASLOGO", null);
            }
        }
    }

    private void addLogo(int editionType, String icon, String text) {
        SimpleMenuBarConstraints cons;
        if (text != null && this.getLogoText(editionType) != null) {
            cons = new SimpleMenuBarConstraints(text, this.getComponentCount() + 1, 5);
            this.add((Component)this.getLogoText(editionType), (Object)cons);
        }
        if (this.getLogoLab() != null) {
            cons = new SimpleMenuBarConstraints(icon, this.getComponentCount() + 1, 0);
            this.add((Component)this.getLogoLab(), (Object)cons);
        }
    }

    public JLabel getLogoText(int editionType) {
        if (this.logoText == null) {
            switch (editionType) {
                case 1: 
                case 2: 
                case 3: {
                    this.logoText = new JLabel(EASEditionUtil.getLocaleText((String)"DEMO_ENTERPRISE_WATER_MARK"));
                    break;
                }
                default: {
                    return null;
                }
            }
            this.logoText.setFont(new Font("Dialog", 1, 12));
            this.logoText.setForeground(Color.WHITE);
            this.logoText.setBackground(new Color(0, 0, 0, 0));
            this.logoText.setBorder(BorderFactory.createEmptyBorder());
            this.logoText.setVerticalAlignment(0);
        }
        return this.logoText;
    }

    protected void addDefaultHidenButton() {
        LittleArrowButton dArrowBu = new LittleArrowButton();
        this.add((Component)dArrowBu, (Object)new SimpleMenuBarConstraints("hidebutton", 0, 0));
    }

    public JComponent addRightComponent(JComponent menu, int rightInterval, Object identify) {
        this.addRightComponent(menu, rightInterval);
        this.setComponentIdentify(menu, identify);
        return menu;
    }

    public JComponent addRightComponent(JComponent menu, int rightInterval) {
        SimpleMenuBarConstraints cons = new SimpleMenuBarConstraints("backcons", this.getComponentCount() + 1, rightInterval);
        if (menu != null) {
            menu.setBackground(Color.decode("#E6EDF3"));
            menu.setOpaque(false);
            if (menu instanceof AbstractButton) {
                menu.setBorder(new KingdeeBorders.ToolBarButtonBorder());
                menu.setFocusable(false);
            }
        }
        super.add((Component)menu, cons);
        return menu;
    }

    @Override
    protected void addImpl(Component comp, Object constants, int index) {
        if (comp != null && comp instanceof JMenu) {
            ((JMenu)comp).setOpaque(false);
            ((JMenu)comp).setRolloverEnabled(true);
        }
        if (constants == null || !(constants instanceof SimpleMenuBarConstraints)) {
            SimpleMenuBarConstraints cons = new SimpleMenuBarConstraints("frontcons", this.getComponentCount() + 1, 0);
            super.addImpl(comp, cons, index);
        } else {
            super.addImpl(comp, constants, index);
        }
    }

    @Override
    public Component add(Component comp, int index) {
        int tempIn = index;
        if (comp instanceof JMenu) {
            tempIn = this.getLogoLab() != null && this.logoText != null ? (tempIn += 3) : (this.getLogoLab() != null ? (tempIn += 2) : ++tempIn);
        }
        return super.add(comp, tempIn);
    }

    public void setMenuIdentify(JMenu menu, Object identify) {
        this.setComponentIdentify(menu, identify);
    }

    public void setComponentIdentify(JComponent comp, Object identify) {
        if (identify == null || comp == null) {
            throw new NullPointerException("JComponent or identify not is null.");
        }
        this.getSelfMap().put(identify, comp);
    }

    public Object getMenuIdentify(JMenu menu) {
        return this.getComponentIdentify(menu);
    }

    public Object getComponentIdentify(JComponent comp) {
        boolean b = this.getSelfMap().containsValue(comp);
        if (b) {
            for (Object obj : this.getSelfMap().keySet()) {
                if (this.getSelfMap().get(obj) != comp) continue;
                return obj;
            }
            return null;
        }
        return null;
    }

    public JMenu add(JMenu menu, Object identify) {
        super.add(menu);
        this.setComponentIdentify(menu, identify);
        return menu;
    }

    public JMenu getMenu(Object identify) {
        JComponent comp = this.getComponent(identify);
        if (comp != null && comp instanceof JMenu) {
            return (JMenu)comp;
        }
        return null;
    }

    public JComponent getComponent(Object identify) {
        Object obj = this.getSelfMap().get(identify);
        if (obj != null && obj instanceof JComponent) {
            return (JComponent)obj;
        }
        return null;
    }

    public boolean removeMenu(Object identify) {
        try {
            JComponent obj = this.getComponent(identify);
            if (obj != null) {
                this.remove(obj);
                this.getSelfMap().remove(identify);
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public Object[] getMenuIdentifys() {
        Set set = this.getSelfMap().keySet();
        if (set != null && set.size() > 0) {
            return set.toArray();
        }
        return null;
    }

    public void setLogo(Icon icon) {
        if (this.getLogoLab() == null) {
            return;
        }
        if (icon != null) {
            this.easIcon = icon;
            this.getLogoLab().setText("");
            this.getLogoLab().setIcon(icon);
            this.getLogoLab().setOpaque(true);
            Dimension dim = new Dimension(icon.getIconWidth(), icon.getIconHeight());
            this.getLogoLab().setPreferredSize(dim);
            this.getLogoLab().setMaximumSize(dim);
            this.getLogoLab().setMinimumSize(dim);
        } else {
            this.getLogoLab().setIcon(null);
            this.getLogoLab().setOpaque(false);
        }
    }

    public void setLogo() {
        if (this.getLogoLab() != null) {
            this.easIcon = UIManager.getIcon("kingdee.logo");
            this.setLogo(this.easIcon);
        }
    }

    public void hideLogo() {
        if (this.getLogoLab() != null) {
            this.getLogoLab().setVisible(false);
        }
    }

    public Icon getLogo() {
        return this.easIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getSelfMap() {
        if (this.selfMap == null) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.selfMap = new HashMap();
            }
        }
        return this.selfMap;
    }

    protected void createLogoLab() {
        if (this.iconLab == null) {
            this.iconLab = new JLabel();
            this.iconLab.setBackground(new Color(0, 0, 0, 0));
            this.iconLab.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public JLabel getLogoLab() {
        return this.iconLab;
    }

    @Override
    public void setToolTipText(String text) {
    }

    @Override
    public JMenu getMenu(int index) {
        if (this.logoText != null) {
            return super.getMenu(index + 3);
        }
        return super.getMenu(index + 2);
    }

    @Override
    public int getMenuCount() {
        if (this.logoText != null) {
            return this.getComponentCount() - 3;
        }
        return this.getComponentCount() - 2;
    }
}

