/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.BasicNumberTextField;
import com.kingdee.bos.ctrl.swing.CtrlPlainDocument;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFormattedTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;

public class KDNumberTextField
extends BasicNumberTextField {
    private static final long serialVersionUID = 5500751254496835513L;
    public static final String undoAction = "undo-numtextfield";
    public static final String redoAction = "redo-numtextfield";
    public UndoManager manager = null;
    private boolean selectAllOnFocus = true;

    public KDNumberTextField() {
        this.init();
    }

    public KDNumberTextField(Object value) {
        super(value);
        this.init();
    }

    public KDNumberTextField(JFormattedTextField.AbstractFormatterFactory factory) {
        super(factory);
        this.init();
    }

    public KDNumberTextField(int dataType) {
        super(dataType);
        this.init();
    }

    @Override
    public boolean isSelectAllOnFocus() {
        return this.selectAllOnFocus;
    }

    @Override
    public void setSelectAllOnFocus(boolean newValue) {
        this.selectAllOnFocus = newValue;
    }

    private void init() {
        if (this.manager == null) {
            this.manager = new UndoManager();
        }
        this.getDocument().addUndoableEditListener(this.manager);
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        KeyStroke newKeyStroke = KeyStroke.getKeyStroke(90, 2, false);
        inputMap.put(newKeyStroke, undoAction);
        newKeyStroke = KeyStroke.getKeyStroke(89, 2, false);
        inputMap.put(newKeyStroke, redoAction);
        actionMap.put(undoAction, new UndoAction());
        actionMap.put(redoAction, new RedoAction());
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        Document document = this.getDocument();
        if (document != null && document instanceof CtrlPlainDocument) {
            if (e.getID() == 1005) {
                ((CtrlPlainDocument)document).setFocusing(false);
            } else {
                ((CtrlPlainDocument)document).setFocusing(true);
            }
        }
        super.processFocusEvent(e);
        if (e.getID() == 1004 && this.isSelectAllOnFocus()) {
            this.selectAll();
        }
    }

    public class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -2407527079560172423L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (KDNumberTextField.this.manager.canRedo()) {
                    KDNumberTextField.this.manager.redo();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 4859651077474114844L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (KDNumberTextField.this.manager.canUndo()) {
                    KDNumberTextField.this.manager.undo();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

