/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.event.TreeNodesDropedEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodesDropedListener;
import com.kingdee.bos.ctrl.swing.event.TreeNodesPreDroppedListener;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeTreeUI;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeCellRenderer;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.DefaultTreeNodesDragDropLogic;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNodesDragDropLogic;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ctrl.swing.tree.TreeDragNode;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class KDTree
extends JTree
implements IKDComponent {
    private static final long serialVersionUID = -3731082352661429603L;
    protected Object userObject = null;
    protected boolean showCheckBox = false;
    protected boolean syncChecked;
    protected boolean dragNodeEnabled = false;
    protected ITreeNodesDragDropLogic dragDropLogic = new DefaultTreeNodesDragDropLogic();
    protected boolean showPopMenuDefaultItem = true;
    protected boolean collapsePathDisabled = false;
    public static final String SHOW_CHECKBOX_PROPERTY = "showCheckBox";
    public static final String SYNCCHECEED_PROPERTY = "syncChecked";
    private static final String ACT_OPEN = "actopen";
    private static final String ACT_CLOSE = "actclose";
    private static final String ACT_OPENLL = "actopenll";
    private static final String ACT_OPENALL = "actopenall";
    private static final String ACT_CLOSEALL = "actcloseall";
    private ActionListener menuItemActionHandler = null;
    private MouseListener treeMouseHandler = null;
    private Insets customInsets;
    private KDPopupMenu kdPopMenu = null;
    private JMenuItem popMenuItemOpen;
    private JMenuItem popMenuItemClose;
    private JMenuItem popMenuItemOpenLL;
    private JMenuItem popMenuItemOpenAll;
    private JMenuItem popMenuItemCloseAll;
    private int currentDepth;

    protected static TreeModel getDefaultTreeModel() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode("KDTree");
        DefaultKingdeeTreeNode parent = new DefaultKingdeeTreeNode("colors");
        root.add(parent);
        parent.add(new DefaultKingdeeTreeNode("blue"));
        parent.add(new DefaultKingdeeTreeNode("violet"));
        parent.add(new DefaultKingdeeTreeNode("red"));
        parent.add(new DefaultKingdeeTreeNode("yellow"));
        parent = new DefaultKingdeeTreeNode("sports");
        root.add(parent);
        parent.add(new DefaultKingdeeTreeNode("basketball"));
        parent.add(new DefaultKingdeeTreeNode("soccer"));
        parent.add(new DefaultKingdeeTreeNode("football"));
        parent.add(new DefaultKingdeeTreeNode("hockey"));
        parent = new DefaultKingdeeTreeNode("food");
        root.add(parent);
        parent.add(new DefaultKingdeeTreeNode("hot dogs"));
        parent.add(new DefaultKingdeeTreeNode("pizza"));
        parent.add(new DefaultKingdeeTreeNode("ravioli"));
        parent.add(new DefaultKingdeeTreeNode("bananas"));
        return new KingdeeTreeModel(root);
    }

    protected static TreeModel createTreeModel(Object value) {
        DefaultKingdeeTreeNode root;
        if (value instanceof Object[] || value instanceof Hashtable || value instanceof Vector) {
            root = new DefaultKingdeeTreeNode("root");
            DynamicKingdeeUtilTreeNode.createChildren(root, value);
        } else {
            root = new DynamicKingdeeUtilTreeNode((Object)"root", value);
        }
        return new KingdeeTreeModel(root, false);
    }

    public KDTree() {
        this(KDTree.getDefaultTreeModel(), false);
    }

    public KDTree(boolean showCheckbox) {
        this(KDTree.getDefaultTreeModel(), showCheckbox);
    }

    public KDTree(Object[] value) {
        this(value, true);
    }

    public KDTree(Object[] value, boolean showCheckbox) {
        this(KDTree.createTreeModel(value), showCheckbox);
        this.setRootVisible(false);
    }

    public KDTree(Vector value) {
        this(value, true);
    }

    public KDTree(Vector value, boolean showCheckbox) {
        this(KDTree.createTreeModel(value), showCheckbox);
        this.setRootVisible(false);
    }

    public KDTree(Hashtable value, boolean showCheckbox) {
        this(KDTree.createTreeModel(value), showCheckbox);
        this.setRootVisible(false);
    }

    public KDTree(ITreeNode root) {
        this(root, true);
    }

    public KDTree(ITreeNode root, boolean showCheckbox) {
        this(root, showCheckbox, false);
    }

    public KDTree(ITreeNode root, boolean showCheckbox, boolean asksAllowsChildren) {
        this(new KingdeeTreeModel(root, asksAllowsChildren), showCheckbox);
    }

    public KDTree(TreeModel newModel) {
        this(newModel, true);
    }

    public KDTree(TreeModel newModel, boolean showCheckbox) {
        super(newModel);
        this.showCheckBox = showCheckbox;
        this.init();
    }

    public void setCustomInsets(Insets newValue) {
        this.customInsets = newValue;
    }

    @Override
    public Insets getInsets() {
        if (this.customInsets != null) {
            return this.customInsets;
        }
        return new Insets(6, 6, 6, 6);
    }

    private void init() {
        this.syncChecked = false;
        this.setCellRenderer(new DefaultKingdeeTreeCellRenderer());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.installMouseListenerForTree();
    }

    public JPopupMenu getPopupMenu() {
        if (this.kdPopMenu == null) {
            this.kdPopMenu = new KDPopupMenu("");
            this.configCommonMenuItem(this.isShowPopMenuDefaultItem());
        }
        return this.kdPopMenu;
    }

    public void setNodeText(DefaultKingdeeTreeNode node, String text) {
        node.setText(text);
        ((KingdeeTreeUI)this.getUI()).redoLayout();
        this.repaint();
    }

    private void configCommonMenuItem(boolean hasCommonMenuItem) {
        if (hasCommonMenuItem) {
            if (this.popMenuItemOpen == null || this.popMenuItemClose == null) {
                this.initSomeMenuItems();
                this.getPopupMenu().insert(this.popMenuItemOpen, 0);
                this.kdPopMenu.insert(this.popMenuItemClose, 1);
                this.kdPopMenu.insert(this.popMenuItemOpenLL, 2);
                this.kdPopMenu.insert(this.popMenuItemOpenAll, 3);
                this.kdPopMenu.insert(this.popMenuItemCloseAll, 4);
            }
        } else {
            this.unInstallMenuItemListeners();
            this.popMenuItemOpen = null;
            this.popMenuItemClose = null;
            this.popMenuItemOpenLL = null;
            this.popMenuItemOpenAll = null;
            this.popMenuItemCloseAll = null;
        }
    }

    private void initSomeMenuItems() {
        this.popMenuItemOpen = new JMenuItem(this.getMLS("popMenuItem1", "\u5c55\u5f00"), UIManager.getIcon("Tree.tbtn_open_menu"));
        this.popMenuItemOpen.setActionCommand(ACT_OPEN);
        this.popMenuItemClose = new JMenuItem(this.getMLS("popMenuItem2", "\u5173\u95ed"), UIManager.getIcon("Tree.tbtn_close_menu"));
        this.popMenuItemClose.setActionCommand(ACT_CLOSE);
        this.popMenuItemOpenLL = new JMenuItem(this.getMLS("popMenuItem3", "\u5c55\u7ea7"), UIManager.getIcon("Tree.tbtn_openlowerlever_menu"));
        this.popMenuItemOpenLL.setActionCommand(ACT_OPENLL);
        this.popMenuItemOpenAll = new JMenuItem(this.getMLS("popMenuItem4", "\u5168\u5c55"), UIManager.getIcon("Tree.tbtn_allopen_menu"));
        this.popMenuItemOpenAll.setActionCommand(ACT_OPENALL);
        this.popMenuItemCloseAll = new JMenuItem(this.getMLS("popMenuItem5", "\u5168\u6536"), UIManager.getIcon("Tree.tbtn_allclose_menu"));
        this.popMenuItemCloseAll.setActionCommand(ACT_CLOSEALL);
        this.installMenuItemListeners();
    }

    private void installMenuItemListeners() {
        this.unInstallMenuItemListeners();
        this.menuItemActionHandler = new ButtonActionHandler();
        this.popMenuItemOpen.addActionListener(this.menuItemActionHandler);
        this.popMenuItemClose.addActionListener(this.menuItemActionHandler);
        this.popMenuItemOpenLL.addActionListener(this.menuItemActionHandler);
        this.popMenuItemOpenAll.addActionListener(this.menuItemActionHandler);
        this.popMenuItemCloseAll.addActionListener(this.menuItemActionHandler);
    }

    private void unInstallMenuItemListeners() {
        if (this.menuItemActionHandler != null) {
            this.popMenuItemOpen.removeActionListener(this.menuItemActionHandler);
            this.popMenuItemClose.removeActionListener(this.menuItemActionHandler);
            this.popMenuItemOpenLL.removeActionListener(this.menuItemActionHandler);
            this.popMenuItemOpenAll.removeActionListener(this.menuItemActionHandler);
            this.popMenuItemCloseAll.removeActionListener(this.menuItemActionHandler);
            this.menuItemActionHandler = null;
        }
    }

    private void installMouseListenerForTree() {
        this.unInstallMouseListenerForTree();
        this.treeMouseHandler = new TreeMouseHandler();
        this.addMouseListener(this.treeMouseHandler);
    }

    private void unInstallMouseListenerForTree() {
        if (this.treeMouseHandler != null) {
            this.removeMouseListener(this.treeMouseHandler);
            this.treeMouseHandler = null;
        }
    }

    public void expandAllNodes(boolean expand, TreeNode node) {
        if (!node.isLeaf()) {
            DefaultMutableTreeNode defnode = (DefaultMutableTreeNode)node;
            Object[] pathtoRoot = defnode.getPath();
            TreePath path = new TreePath(pathtoRoot);
            for (int childcount = defnode.getChildCount() - 1; childcount >= 0; --childcount) {
                TreeNode child = defnode.getChildAt(childcount);
                this.expandAllNodes(expand, child);
            }
            if (expand) {
                this.expandPath(path);
            } else {
                this.collapsePath(path);
            }
        }
    }

    public void expandOnLevel(int level) {
        TreeModel model = this.getModel();
        if (model == null) {
            return;
        }
        TreeNode root = (TreeNode)model.getRoot();
        if (root == null) {
            return;
        }
        this.expandNodeOnLevel((DefaultMutableTreeNode)root, level);
    }

    private void expandNodeOnLevel(DefaultMutableTreeNode node, int level) {
        Object[] pathtoRoot = node.getPath();
        int depth = pathtoRoot.length;
        if (this.currentDepth < depth) {
            this.currentDepth = depth;
        }
        if (depth >= level) {
            return;
        }
        TreePath thepath = new TreePath(pathtoRoot);
        this.expandPath(thepath);
        int childCount = node.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            this.expandNodeOnLevel(child, level);
        }
    }

    protected boolean firePopMenu(TreePath closestPath, TreePath[] selectionPaths, JPopupMenu menu) {
        Object[] listeners = this.listenerList.getListenerList();
        TreePopupMenuEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreePopupMenuListener.class) continue;
            if (e == null) {
                e = new TreePopupMenuEvent(this, closestPath, selectionPaths, menu);
            }
            return ((TreePopupMenuListener)listeners[i + 1]).popMenu(e);
        }
        return false;
    }

    public void addTreePopupMenu(TreePopupMenuListener l) {
        this.listenerList.add(TreePopupMenuListener.class, l);
    }

    public void removeTreePopupMenu(TreePopupMenuListener l) {
        this.listenerList.remove(TreePopupMenuListener.class, l);
    }

    public void addTreeNodeStateChangeListener(TreeNodeStateChangeListener l) {
        this.listenerList.add(TreeNodeStateChangeListener.class, l);
    }

    public void removeTreeNodeStateChangeListener(TreeNodeStateChangeListener l) {
        this.listenerList.remove(TreeNodeStateChangeListener.class, l);
    }

    public void fireTreeNodeStateChange(TreeNode node) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeNodeStateChangeEvent event = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeNodeStateChangeListener.class) continue;
            if (null == event) {
                event = new TreeNodeStateChangeEvent(this, node);
            }
            ((TreeNodeStateChangeListener)listeners[i + 1]).nodeStateChange(event);
        }
    }

    public void addTreeNodesPreDroppedListener(TreeNodesPreDroppedListener l) {
        this.listenerList.add(TreeNodesPreDroppedListener.class, l);
    }

    public void removeTreeNodesPreDroppedListener(TreeNodesPreDroppedListener l) {
        this.listenerList.remove(TreeNodesPreDroppedListener.class, l);
    }

    public void addTreeNodesDropedListener(TreeNodesDropedListener l) {
        this.listenerList.add(TreeNodesDropedListener.class, l);
    }

    public void removeTreeNodesDropedListener(TreeNodesDropedListener l) {
        this.listenerList.remove(TreeNodesDropedListener.class, l);
    }

    public boolean fireNodesPreDropped(TreeDragNode[] dragNodes) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeNodesDropedEvent dropedEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeNodesPreDroppedListener.class) continue;
            if (null == dropedEvent) {
                dropedEvent = new TreeNodesDropedEvent(this, dragNodes);
            }
            ((TreeNodesPreDroppedListener)listeners[i + 1]).preDropped(dropedEvent);
            if (!dropedEvent.isVetoed()) continue;
            return false;
        }
        return true;
    }

    public void fireNodesDroped(TreeDragNode[] dragNodes) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeNodesDropedEvent dropedEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeNodesDropedListener.class) continue;
            if (null == dropedEvent) {
                dropedEvent = new TreeNodesDropedEvent(this, dragNodes);
            }
            ((TreeNodesDropedListener)listeners[i + 1]).droped(dropedEvent);
        }
    }

    @Override
    public void updateUI() {
        this.setUI(new KingdeeTreeUI());
        this.invalidate();
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public boolean isShowCheckBox() {
        return this.showCheckBox;
    }

    public void setShowCheckBox(boolean showCheckBox) {
        boolean oldValue = this.showCheckBox;
        if (oldValue != showCheckBox) {
            this.showCheckBox = showCheckBox;
            this.firePropertyChange(SHOW_CHECKBOX_PROPERTY, oldValue, this.showCheckBox);
        }
    }

    public boolean isSyncChecked() {
        return this.syncChecked;
    }

    public void setSyncChecked(boolean syncChecked) {
        boolean oldValue = this.syncChecked;
        this.syncChecked = syncChecked;
        this.firePropertyChange(SYNCCHECEED_PROPERTY, oldValue, this.syncChecked);
    }

    public void setDragNodeEnabled(boolean enabled) {
        boolean old = this.dragNodeEnabled;
        if (old != enabled) {
            this.dragNodeEnabled = enabled;
            this.firePropertyChange("isdragnodeenabled", old, this.dragNodeEnabled);
        }
    }

    public boolean isDragNodeEnabled() {
        return this.dragNodeEnabled;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String tip = super.getToolTipText(e);
        return tip != null ? tip : this.getToolTipText();
    }

    public ITreeNodesDragDropLogic getNodesDragDropLogic() {
        return this.dragDropLogic;
    }

    public void setNodesDragDropLogic(ITreeNodesDragDropLogic logic) {
        this.dragDropLogic = logic;
    }

    public void removeNodeFromParent(MutableTreeNode node) {
        ((DefaultTreeModel)this.getModel()).removeNodeFromParent(node);
    }

    public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        if (index < 0 || index > parent.getChildCount()) {
            throw new IllegalArgumentException("index less than zero or larger than parent's childCount.");
        }
        ((DefaultTreeModel)this.getModel()).insertNodeInto(newChild, parent, index);
    }

    public void addNodeInto(MutableTreeNode newChild, MutableTreeNode parent) {
        ((DefaultTreeModel)this.getModel()).insertNodeInto(newChild, parent, parent.getChildCount());
    }

    public void removeAllChildrenFromParent(MutableTreeNode parent) {
        for (int i = parent.getChildCount() - 1; i >= 0; --i) {
            ((DefaultTreeModel)this.getModel()).removeNodeFromParent((MutableTreeNode)parent.getChildAt(i));
        }
    }

    public boolean isPathsContainsPath(TreePath[] pa, TreePath p) {
        if (p != null && pa != null) {
            for (int i = pa.length - 1; i >= 0; --i) {
                if (!p.equals(pa[i])) continue;
                return true;
            }
        }
        return false;
    }

    public TreePath getClosestPath(int x, int y) {
        TreeUI ui = this.getUI();
        if (ui != null) {
            TreePath closestPath = ui.getClosestPathForLocation(this, x, y);
            if (closestPath == null) {
                return null;
            }
            Rectangle closestPathRect = this.getPathBounds(closestPath);
            if (y > closestPathRect.y + closestPathRect.height) {
                return null;
            }
            return closestPath;
        }
        return null;
    }

    private String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)"com.kingdee.bos.ctrl.swing.KDTree", (String)defaultValue);
    }

    public boolean isShowPopMenuDefaultItem() {
        return this.showPopMenuDefaultItem;
    }

    public void setShowPopMenuDefaultItem(boolean b) {
        this.showPopMenuDefaultItem = b;
        this.configCommonMenuItem(this.showPopMenuDefaultItem);
    }

    public void setSelectionNode(DefaultKingdeeTreeNode node) {
        TreePath path = null;
        if (node != null) {
            path = new TreePath(node.getPath());
        }
        this.setSelectionPath(path);
    }

    public boolean isCollapsePathDisabled() {
        return this.collapsePathDisabled;
    }

    public void setCollapsePathDisabled(boolean b) {
        this.expandAllNodes(true, (TreeNode)this.getModel().getRoot());
        this.collapsePathDisabled = b;
    }

    @Override
    public void collapsePath(TreePath path) {
        if (!this.collapsePathDisabled) {
            super.collapsePath(path);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        Container ancestor = this.getParent();
        if (ancestor.getClass() != JViewport.class) {
            super.processKeyEvent(e);
            return;
        }
        if (e.getID() == 402 && e.getKeyCode() == 40 && e.getModifiers() == 2) {
            ((KDScrollPane)ancestor.getParent()).doDownAction();
            e.consume();
        } else if (e.getID() == 402 && e.getKeyCode() == 38 && e.getModifiers() == 2) {
            ((KDScrollPane)ancestor.getParent()).doUpAction();
            e.consume();
        } else {
            super.processKeyEvent(e);
        }
    }

    private class TreeMouseHandler
    extends MouseAdapter {
        private TreeMouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            TreePath closestPath;
            if (SwingUtilities.isRightMouseButton(event) && ((KDTree)event.getSource()).isEnabled() && KDTree.this.firePopMenu(closestPath = KDTree.this.getClosestPath(event.getX(), event.getY()), KDTree.this.getSelectionPaths(), KDTree.this.getPopupMenu())) {
                KDTree.this.getPopupMenu().show(KDTree.this, event.getX() + 3, event.getY() + 3);
            }
        }
    }

    private class ButtonActionHandler
    implements ActionListener {
        private ButtonActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (KDTree.ACT_OPEN.equals(command)) {
                TreePath path = KDTree.this.getLeadSelectionPath();
                KDTree.this.expandPath(path);
            } else if (KDTree.ACT_CLOSE.equals(command)) {
                TreePath path = KDTree.this.getLeadSelectionPath();
                KDTree.this.collapsePath(path);
            } else if (KDTree.ACT_OPENLL.equals(command)) {
                TreePath path = KDTree.this.getLeadSelectionPath();
                TreeNode node = (TreeNode)path.getLastPathComponent();
                KDTree.this.expandAllNodes(true, node);
            } else if (KDTree.ACT_OPENALL.equals(command)) {
                KDTree.this.expandAllNodes(true, (TreeNode)KDTree.this.getModel().getRoot());
            } else if (KDTree.ACT_CLOSEALL.equals(command)) {
                KDTree.this.expandAllNodes(false, (TreeNode)KDTree.this.getModel().getRoot());
            }
        }
    }

    public static class DynamicKingdeeUtilTreeNode
    extends DefaultKingdeeTreeNode {
        private static final long serialVersionUID = 5059097501766128961L;
        protected boolean hasChildren;
        protected Object childValue;
        protected boolean loadedChildren = false;

        public static void createChildren(DefaultKingdeeTreeNode parent, Object children) {
            block4: {
                block5: {
                    block3: {
                        if (!(children instanceof Vector)) break block3;
                        Vector childVector = (Vector)children;
                        int maxCounter = childVector.size();
                        for (int counter = 0; counter < maxCounter; ++counter) {
                            parent.add(new DynamicKingdeeUtilTreeNode(childVector.elementAt(counter), childVector.elementAt(counter)));
                        }
                        break block4;
                    }
                    if (!(children instanceof Hashtable)) break block5;
                    Hashtable childHT = (Hashtable)children;
                    Enumeration keys = childHT.keys();
                    while (keys.hasMoreElements()) {
                        Object aKey = keys.nextElement();
                        parent.add(new DynamicKingdeeUtilTreeNode(aKey, childHT.get(aKey)));
                    }
                    break block4;
                }
                if (!(children instanceof Object[])) break block4;
                Object[] childArray = (Object[])children;
                int maxCounter = childArray.length;
                for (int counter = 0; counter < maxCounter; ++counter) {
                    parent.add(new DynamicKingdeeUtilTreeNode(childArray[counter], childArray[counter]));
                }
            }
        }

        public DynamicKingdeeUtilTreeNode(Object value, Object children) {
            super(value);
            this.childValue = children;
            if (children != null) {
                if (children instanceof Vector) {
                    this.setAllowsChildren(true);
                } else if (children instanceof Hashtable) {
                    this.setAllowsChildren(true);
                } else if (children instanceof Object[]) {
                    this.setAllowsChildren(true);
                } else {
                    this.setAllowsChildren(false);
                }
            } else {
                this.setAllowsChildren(false);
            }
        }

        @Override
        public boolean isLeaf() {
            return !this.getAllowsChildren();
        }

        @Override
        public int getChildCount() {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.getChildCount();
        }

        protected void loadChildren() {
            this.loadedChildren = true;
            DynamicKingdeeUtilTreeNode.createChildren(this, this.childValue);
        }

        @Override
        public TreeNode getChildAt(int index) {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.getChildAt(index);
        }

        public Enumeration children() {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.children();
        }
    }
}

