/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.common.util.SizeOf;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;

public class MemoryInspector
extends KDPanel {
    private static final long serialVersionUID = 2784816455266799105L;
    private static final String TEXT = "All(Init + Now):";
    private KDLabel lbDisplay;
    private KDButton btnRefresh;
    private KDButton btnGC;
    private KDComboBox cbScale;
    private long initSize = 0L;
    private int scale = 1;
    private String[] SCALES = new String[]{"B", "KB", "MB", "GB"};

    public MemoryInspector() {
        this(0L);
    }

    public MemoryInspector(long initSize) {
        this(initSize, 1);
    }

    public MemoryInspector(long initSize, int scale) {
        this.initSize = initSize;
        this.lbDisplay = new KDLabel();
        this.cbScale = new KDComboBox(this.SCALES);
        this.btnRefresh = new KDButton(KDResourceManager.getMLS("refresh", "\u5237\u65b0"));
        this.btnGC = new KDButton("GC");
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.lbDisplay);
        this.add(this.cbScale);
        this.add(this.btnRefresh);
        this.add(this.btnGC);
        this.updateText();
        this.cbScale.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = MemoryInspector.this.cbScale.getSelectedItem();
                if (item != null) {
                    if (item.equals(MemoryInspector.this.SCALES[0])) {
                        MemoryInspector.this.setScale(1);
                    } else if (item.equals(MemoryInspector.this.SCALES[1])) {
                        MemoryInspector.this.setScale(1000);
                    } else if (item.equals(MemoryInspector.this.SCALES[2])) {
                        MemoryInspector.this.setScale(1000000);
                    } else if (item.equals(MemoryInspector.this.SCALES[3])) {
                        MemoryInspector.this.setScale(1000000000);
                    }
                    MemoryInspector.this.updateText();
                }
            }
        });
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryInspector.this.updateText();
            }
        });
        this.btnGC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SizeOf.runGC();
                MemoryInspector.this.updateText();
            }
        });
    }

    private void updateText() {
        long s = SizeOf.usedMemory();
        String str = TEXT + s / (long)this.scale + "(" + this.initSize / (long)this.scale + "+" + (s - this.initSize) / (long)this.scale + ")";
        this.lbDisplay.setText(str);
    }

    public long getInitSize() {
        return this.initSize;
    }

    public void setInitSize(long initSize) {
        this.initSize = initSize;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }
}

