/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.SameGridConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Hashtable;
import javax.swing.JComponent;

public class SameGridLayout
implements LayoutManager2 {
    protected static final int MAINGRIDROWS = 8;
    protected static final int MAINGRIDCOLUMNS = 8;
    public int gridRows = 8;
    public int gridColumns = 8;
    protected static final int C_HORZ = 2;
    protected static final int C_NONE = 0;
    protected static final int C_WEST = 17;
    protected static final int C_WIDTH = 1;
    protected static final int C_HEIGHT = 1;
    private Hashtable hash = null;
    private SameGridConstraints defaultSameGridConstraints = new SameGridConstraints(0, 0, 1, 1);

    public SameGridLayout(int gridRows, int gridColumns) {
        this.defaultSameGridConstraints.insets = new Insets(1, 1, 1, 1);
        this.hash = new Hashtable();
        this.checkP(gridRows, gridColumns);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints instanceof SameGridConstraints) {
            this.setConstraints(comp, (SameGridConstraints)constraints);
        } else if (constraints != null) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a SameGridConstraints");
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(200, 300);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        int tempCellHeight;
        int tempCellWidth;
        Dimension parentDim = parent.getSize();
        Insets parentIns = parent.getInsets();
        if (parentIns == null) {
            parentIns = new Insets(1, 1, 1, 1);
        }
        int pHeight = parentDim.height - parentIns.top - parentIns.bottom;
        int pWidth = parentDim.width - parentIns.left - parentIns.right;
        int cellWidth = tempCellWidth = pWidth / this.gridColumns;
        int cellHeight = tempCellHeight = pHeight / this.gridRows;
        Component[] array = parent.getComponents();
        int len = array.length;
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                Component comp = array[i];
                SameGridConstraints sc = this.lookforConstraints(comp);
                Insets scInsets = sc.insets == null ? new Insets(2, 2, 2, 2) : sc.insets;
                int x = sc.gridX * cellWidth + scInsets.left + parentIns.left;
                int y = sc.gridY * cellHeight + scInsets.top + parentIns.top;
                int width = sc.gridWidth * cellWidth - scInsets.left - scInsets.right;
                int height = sc.gridHeight * cellHeight - scInsets.top - scInsets.bottom;
                comp.setBounds(x, y, width, height);
            }
        }
        ((JComponent)parent).setMinimumSize(new Dimension(300, 400));
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(200, 300);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return null;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.hash.remove(comp);
    }

    private SameGridConstraints lookforConstraints(Component comp) {
        SameGridConstraints sc = (SameGridConstraints)this.hash.get(comp);
        if (sc == null) {
            sc = this.defaultSameGridConstraints;
            this.setConstraints(comp, sc);
        }
        return sc;
    }

    private void setConstraints(Component comp, SameGridConstraints constraints) {
        this.hash.put(comp, constraints.clone());
    }

    private void checkP(int gridRows, int gridColumns) {
        this.gridRows = gridRows <= 0 ? 8 : gridRows;
        this.gridColumns = gridColumns <= 0 ? 8 : gridColumns;
    }
}

