/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.SimpleMenuBarConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SizeSequence;
import javax.swing.SwingConstants;

public class SimpleMenuBarLayout
implements LayoutManager2,
SwingConstants {
    private boolean lineWrap = true;
    private JComponent logoComp = null;
    private JComponent hideButton = null;
    private boolean allowedInsets = false;
    private transient Dimension totalPreDim = null;
    private transient Dimension totalMinDim = null;
    private transient Dimension frontPreDim = null;
    private transient Dimension backPreDim = null;
    private transient SizeSequence totalSizeSequence = null;
    private SimpleMenuBarConstraints defaultConstraints = null;
    protected Hashtable comptable;
    private int orientation = 0;
    private static final boolean DEBUG = false;

    public SimpleMenuBarLayout() {
        this(0);
    }

    public SimpleMenuBarLayout(int ori) {
        this.setOrientaion(ori);
        this.comptable = new Hashtable();
        this.defaultConstraints = new SimpleMenuBarConstraints("frontcons", 0, 0);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints instanceof SimpleMenuBarConstraints) {
            this.setConstraints(comp, (SimpleMenuBarConstraints)constraints);
        } else if (constraints != null) {
            throw new IllegalArgumentException("cannot add to layout: constraints must be a SimpleMenuBarConstraints");
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        Dimension maxDim = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
        return maxDim;
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.totalMinDim = null;
        this.totalPreDim = null;
        this.backPreDim = null;
        this.totalSizeSequence = null;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.removeConstraints(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.calculateSizes(parent);
            return this.totalPreDim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension minDim = new Dimension(0, 0);
            try {
                if (this.getOrientation() == 0) {
                    Insets ins;
                    if (this.logoComp != null) {
                        Dimension logoDim = this.logoComp.getPreferredSize();
                        minDim.width += logoDim.width;
                        ins = this.logoComp.getInsets();
                        this.sumDim1(ins, minDim);
                        this.sumDim3(ins, minDim, logoDim);
                    }
                    if (this.hideButton != null) {
                        Dimension hbDim = this.hideButton.getPreferredSize();
                        minDim.width += hbDim.width;
                        ins = this.hideButton.getInsets();
                        this.sumDim1(ins, minDim);
                        this.sumDim3(ins, minDim, hbDim);
                    }
                    minDim.width = Math.max(minDim.width, 120);
                    minDim.height = Math.max(minDim.height, 30);
                } else if (this.logoComp != null) {
                    Dimension logoDim = this.logoComp.getPreferredSize();
                    Insets ins = this.logoComp.getInsets();
                    minDim.height += logoDim.height;
                    this.sumDim2(ins, minDim);
                    this.sumDim4(ins, minDim, logoDim);
                }
                minDim.width = Math.max(minDim.width, 120);
                minDim.height = Math.max(minDim.height, 50);
            }
            catch (Exception ex) {
                minDim = new Dimension(120, 30);
                ex.printStackTrace();
            }
            return minDim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.calculateSizes(parent);
            if (this.getOrientation() == 0) {
                MinInfo minInfo = this.calculateGridHori(parent);
                this.logs(minInfo.toString());
                this.layoutForHorizontal(minInfo, parent);
            } else {
                this.calculateGridVert(parent);
            }
        }
    }

    protected void layoutForHorizontal(MinInfo minInfo, Container parent) {
        int index = minInfo.index;
        if (index == -1) {
            // empty if block
        }
        this.setHideButton(false);
        Rectangle d1 = this.layoutEasLogo(parent, minInfo, new Rectangle(0, 0, 0, 0));
        Rectangle d2 = this.layoutHideButton(parent, minInfo, d1);
        Rectangle d3 = this.layoutBackComp(parent, minInfo, d2);
        this.layoutFrontComp(parent, minInfo, d3);
    }

    protected Rectangle layoutEasLogo(Container parent, MinInfo minInfo, Rectangle rec) {
        int startx;
        int w = 0;
        int starty = 1;
        int h = 1;
        Rectangle parentRect = parent.getBounds();
        if (this.logoComp != null && this.logoComp.isVisible()) {
            Dimension logoD = this.logoComp.getPreferredSize();
            startx = parentRect.width - rec.x - logoD.width - 1;
            int bW = parentRect.height - logoD.height;
            if (bW > 1) {
                starty = bW / 2;
            } else {
                starty = -1;
                --h;
            }
            w = logoD.width;
            h = parentRect.height;
            this.logoComp.setBounds(startx, starty, w, h);
        } else {
            startx = parentRect.width;
            starty = 1;
        }
        return new Rectangle(startx, 1, w, h);
    }

    protected Rectangle layoutHideButton(Container parent, MinInfo minInfo, Rectangle rec) {
        int startx;
        int w = 0;
        int h = 0;
        if (this.hideButton != null && this.hideButton.isVisible()) {
            Dimension hbD = this.hideButton.getPreferredSize();
            Rectangle parentRect = parent.getBounds();
            Insets ins = this.selfInsets(this.logoComp.getInsets());
            startx = rec.x - hbD.width;
            int starty = ins.top;
            w = hbD.width - ins.left - ins.right;
            h = parentRect.height - ins.top - ins.bottom;
            this.hideButton.setBounds(startx + ins.left, starty, w, h);
        } else {
            startx = rec.x;
            boolean starty = false;
        }
        return new Rectangle(startx, 0, w, h);
    }

    protected Rectangle layoutBackComp(Container parent, MinInfo minInfo, Rectangle rec) {
        Rectangle tempRect = new Rectangle(0, 0, 0, 0);
        Vector backVec = this.getBackComps();
        if (backVec != null && backVec.size() > 0) {
            int startx = rec.x;
            int starty = 0;
            int size = backVec.size();
            Rectangle parentRect = parent.getBounds();
            int tempW = 0;
            int tempH = 0;
            for (int i = 0; i < size; ++i) {
                Component comp = (Component)backVec.elementAt(i);
                if (comp == null || !comp.isVisible()) continue;
                if (startx >= this.frontPreDim.width + 25) {
                    Dimension compD = comp.getPreferredSize();
                    Insets ins = this.selfInsets(((JComponent)comp).getInsets());
                    SimpleMenuBarConstraints simpCons = this.lookupConstraints(comp);
                    int interval = 1;
                    if (simpCons != null) {
                        interval = simpCons.rightInterval;
                    }
                    tempW = tempW + compD.width + interval;
                    tempH = Math.max(tempH, compD.height);
                    startx = startx - compD.width - interval;
                    starty = ins.top;
                    int w = compD.width - ins.left - ins.right;
                    int h = parentRect.height - ins.top - ins.bottom - 2;
                    comp.setBounds(startx + ins.left, starty, w, h);
                    continue;
                }
                comp.setBounds(0, 0, 0, 0);
            }
            tempRect.x = startx;
            tempRect.y = starty;
            tempRect.width = tempW;
            tempRect.height = tempH;
        }
        return tempRect;
    }

    protected Rectangle layoutFrontComp(Container parent, MinInfo minInfo, Rectangle rec) {
        Vector frontVec = this.getFrontComps();
        Rectangle tempRect = new Rectangle(0, 0, 0, 0);
        if (frontVec != null && frontVec.size() > 0) {
            Rectangle parentRect = parent.getBounds();
            int startx = 10;
            int starty = 0;
            int tempW = 0;
            int tempH = 0;
            int size = frontVec.size();
            for (int i = 0; i < size; ++i) {
                Component comp = (Component)frontVec.elementAt(i);
                int interval = this.getInterval(i);
                if (comp == null || !comp.isVisible()) continue;
                Dimension compD = comp.getPreferredSize();
                Insets ins = ((JComponent)comp).getInsets();
                startx += interval;
                starty = ins.top;
                int w = compD.width - ins.left - ins.right;
                tempW += w;
                int h = parentRect.height - ins.top - ins.bottom - 2;
                tempH = Math.max(tempH, h);
                comp.setBounds(startx + ins.left, starty, w, h);
                startx += compD.width;
            }
            tempRect.x = startx;
            tempRect.y = starty;
            tempRect.width = tempW;
            tempRect.height = tempH;
        }
        return tempRect;
    }

    public void setConstraints(Component comp, SimpleMenuBarConstraints constraints) {
        String ori = constraints.orientation;
        if (ori == null) {
            ori = "frontcons";
        }
        if (ori.equals("EASLOGO")) {
            this.logoComp = (JComponent)comp;
        } else if (ori.equals("hidebutton")) {
            this.hideButton = (JComponent)comp;
        } else if (ori.equals("frontcons")) {
            Vector<Component> frontVec = (Vector<Component>)this.comptable.get("frontcons");
            if (frontVec == null) {
                frontVec = new Vector<Component>(0);
                this.comptable.put("frontcons", frontVec);
            }
            frontVec.addElement(comp);
        } else if (ori.equals("backcons")) {
            Vector<Component> backVec = (Vector<Component>)this.comptable.get("backcons");
            if (backVec == null) {
                backVec = new Vector<Component>(0);
                this.comptable.put("backcons", backVec);
            }
            backVec.addElement(comp);
        }
        this.comptable.put(comp, constraints.clone());
    }

    private void removeConstraints(Component comp) {
        try {
            SimpleMenuBarConstraints cons = this.lookupConstraints(comp);
            if (cons.orientation.equals("frontcons")) {
                ((Vector)this.comptable.get("frontcons")).remove(comp);
            } else if (cons.orientation.equals("backcons")) {
                ((Vector)this.comptable.get("backcons")).remove(comp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.comptable.remove(comp);
    }

    public SimpleMenuBarConstraints getConstraints(Component comp) {
        SimpleMenuBarConstraints constraints = (SimpleMenuBarConstraints)this.comptable.get(comp);
        if (constraints == null) {
            this.setConstraints(comp, this.defaultConstraints);
            constraints = (SimpleMenuBarConstraints)this.comptable.get(comp);
        }
        return (SimpleMenuBarConstraints)constraints.clone();
    }

    protected SimpleMenuBarConstraints lookupConstraints(Component comp) {
        SimpleMenuBarConstraints constraints = (SimpleMenuBarConstraints)this.comptable.get(comp);
        if (constraints == null) {
            this.setConstraints(comp, this.defaultConstraints);
            constraints = (SimpleMenuBarConstraints)this.comptable.get(comp);
        }
        return constraints;
    }

    public void setOrientaion(int newVal) {
        this.orientation = newVal == 3 || newVal == 7 || newVal == 0 ? 0 : 1;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setLineWrap(boolean b) {
        this.lineWrap = b;
    }

    public boolean getLineWrap() {
        return this.lineWrap;
    }

    private void sumDim1(Insets ins, Dimension dim) {
        if (ins != null && dim != null) {
            dim.width = dim.width + ins.left + ins.right;
        }
    }

    private void sumDim2(Insets ins, Dimension dim) {
        if (ins != null && dim != null) {
            dim.height = dim.height + ins.top + ins.bottom;
        }
    }

    private void sumDim3(Insets ins, Dimension dim, Dimension compD) {
        if (ins != null && dim != null) {
            dim.height = Math.max(dim.height, compD.height + ins.top + ins.bottom);
        }
    }

    private void sumDim4(Insets ins, Dimension dim, Dimension compD) {
        if (ins != null && dim != null) {
            dim.width = Math.max(dim.width, compD.width + ins.left + ins.right);
        }
    }

    private Vector getFrontComps() {
        return (Vector)this.comptable.get("frontcons");
    }

    private Vector getBackComps() {
        return (Vector)this.comptable.get("backcons");
    }

    private MinInfo calculateGridHori(Container parent) {
        MinInfo minInfo = new MinInfo();
        Rectangle parentRect = parent.getBounds();
        if (parentRect.width >= this.totalPreDim.width) {
            minInfo.index = -1;
            minInfo.cons = "allchildren";
            return minInfo;
        }
        int compIndex = this.totalSizeSequence.getIndex(parentRect.width);
        Vector frontVec = this.getFrontComps();
        Vector backVec = this.getBackComps();
        int frontCount = 0;
        int backCount = 0;
        if (frontVec != null) {
            frontCount = frontVec.size();
        }
        if (backVec != null) {
            backCount = backVec.size();
        }
        if (compIndex < frontCount) {
            minInfo.index = compIndex;
            minInfo.cons = "frontcons";
        } else if (compIndex < frontCount + backCount) {
            int tempIndex = compIndex - frontCount;
            tempIndex = tempIndex >= backCount ? backCount - 1 : tempIndex;
            minInfo.index = tempIndex = Math.abs(tempIndex - backCount + 1);
            minInfo.cons = "backcons";
        } else {
            minInfo.index = -2;
        }
        return minInfo;
    }

    private MinInfo calculateGridVert(Container parent) {
        MinInfo minInfo = new MinInfo();
        Rectangle parentRect = parent.getBounds();
        if (parentRect.height >= this.totalPreDim.height) {
            minInfo.index = -1;
            return minInfo;
        }
        int compIndex = this.totalSizeSequence.getIndex(parentRect.height);
        Vector frontVec = this.getFrontComps();
        Vector backVec = this.getBackComps();
        int frontCount = 0;
        int backCount = 0;
        if (frontVec != null) {
            frontCount = frontVec.size();
        }
        if (backVec != null) {
            backCount = backVec.size();
        }
        if (compIndex < frontCount) {
            minInfo.index = compIndex;
            minInfo.cons = "frontcons";
        } else if (compIndex < frontCount + backCount) {
            minInfo.index = compIndex - frontCount;
            minInfo.cons = "backcons";
        } else {
            minInfo.index = -2;
        }
        return minInfo;
    }

    public void setAllowedInsets(boolean b) {
        this.allowedInsets = b;
    }

    private Insets selfInsets(Insets ins) {
        if (this.allowedInsets) {
            return ins;
        }
        return new Insets(0, 0, 0, 0);
    }

    private int getInterval(int index) {
        return 0;
    }

    private void reOrder(Container parent) {
        this.clearSomeVec();
        for (Component comp : parent.getComponents()) {
            SimpleMenuBarConstraints sCons = this.lookupConstraints(comp);
            String ori = sCons.orientation;
            if (ori == null) {
                ori = "frontcons";
            }
            if (ori.equals("frontcons")) {
                this.getFrontComps().addElement(comp);
                continue;
            }
            if (!ori.equals("backcons")) continue;
            this.getBackComps().addElement(comp);
        }
    }

    private void clearSomeVec() {
        if (this.getFrontComps() != null) {
            this.getFrontComps().clear();
        }
        if (this.getBackComps() != null) {
            this.getBackComps().clear();
        }
    }

    private void calculateSizes(Container parent) {
        if (this.totalMinDim == null || this.totalPreDim == null || this.totalSizeSequence == null) {
            int i;
            this.reOrder(parent);
            this.totalMinDim = new Dimension(0, 0);
            this.totalPreDim = new Dimension(0, 0);
            this.totalSizeSequence = new SizeSequence();
            this.frontPreDim = new Dimension(0, 0);
            this.backPreDim = new Dimension(0, 0);
            int sssize = 0;
            Vector frontComps = this.getFrontComps();
            int fccount = frontComps != null ? frontComps.size() : 0;
            Vector backComps = this.getBackComps();
            int bccount = backComps != null ? backComps.size() : 0;
            sssize = fccount + bccount;
            if (this.logoComp != null && this.logoComp.isVisible()) {
                ++sssize;
            }
            int[] sw = new int[sssize];
            for (i = 0; i < sssize; ++i) {
                sw[i] = 0;
            }
            this.totalSizeSequence.setSizes(sw);
            if (frontComps != null && frontComps.size() > 0) {
                fccount = frontComps.size();
                for (i = 0; i < fccount; ++i) {
                    this.calculateOneComponent((Component)frontComps.elementAt(i), i, 0, 0);
                }
            }
            if (backComps != null && backComps.size() > 0) {
                for (int j = bccount - 1; j >= 0; --j) {
                    this.calculateOneComponent((Component)backComps.elementAt(j), Math.abs(j - bccount + 1), fccount, 1);
                }
            }
            if (this.logoComp != null && this.logoComp.isVisible()) {
                this.calculateOneComponent(this.logoComp, fccount + bccount, 0, 0);
            }
        }
    }

    private void calculateOneComponent(Component comp, int index, int frontCount, int type) {
        if (comp == null || !comp.isVisible()) {
            return;
        }
        Dimension preDim = comp.getPreferredSize();
        Dimension minDim = comp.getMinimumSize();
        if (type == 0) {
            int interval = this.getInterval(index);
            if (this.getOrientation() == 0) {
                int preWidth = preDim.width + interval;
                this.totalPreDim.width += preWidth;
                this.totalPreDim.height = Math.max(preDim.height, this.totalPreDim.height);
                this.totalMinDim.width = this.totalMinDim.width + minDim.width + interval;
                this.totalMinDim.height = Math.max(this.totalMinDim.height, minDim.height);
                this.frontPreDim.width += preWidth;
                this.frontPreDim.height = Math.max(this.frontPreDim.height, preDim.height);
                this.totalSizeSequence.setSize(index, preWidth);
            } else {
                int preHeight = preDim.height + interval;
                this.totalPreDim.width = Math.max(this.totalPreDim.width, preDim.width);
                this.totalPreDim.height += preHeight;
                this.totalMinDim.width = Math.max(this.totalMinDim.width, minDim.width);
                this.totalMinDim.height += minDim.height;
                this.frontPreDim.width = Math.max(this.frontPreDim.width, preDim.width);
                this.frontPreDim.height += preHeight;
                this.totalSizeSequence.setSize(index, preHeight);
            }
        } else if (type == 1) {
            SimpleMenuBarConstraints smc = this.lookupConstraints(comp);
            int interval = 0;
            if (smc != null) {
                int n = interval = smc.rightInterval >= 0 ? smc.rightInterval : 0;
            }
            if (this.getOrientation() == 0) {
                int preWidth = preDim.width + interval;
                this.totalPreDim.width += preWidth;
                this.totalPreDim.height = Math.max(preDim.height, this.totalPreDim.height);
                this.totalMinDim.width = this.totalMinDim.width + minDim.width + interval;
                this.totalMinDim.height = Math.max(this.totalMinDim.height, minDim.height);
                this.backPreDim.width = this.frontPreDim.width + preWidth;
                this.backPreDim.height = Math.max(this.frontPreDim.height, preDim.height);
                this.totalSizeSequence.setSize(index + frontCount, preWidth);
            } else {
                int preHeight = preDim.height + interval;
                this.totalPreDim.width = Math.max(this.totalPreDim.width, preDim.width);
                this.totalPreDim.height += preHeight;
                this.totalMinDim.width = Math.max(this.totalMinDim.width, minDim.width);
                this.totalMinDim.height += minDim.height;
                this.backPreDim.width = Math.max(this.backPreDim.width, preDim.width);
                this.backPreDim.height += preHeight;
                this.totalSizeSequence.setSize(index + frontCount, preHeight);
            }
        } else if (type == 3) {
            // empty if block
        }
    }

    private void setHideButton(boolean b) {
        if (this.hideButton != null) {
            this.hideButton.setVisible(b);
        }
    }

    private void logs(String info) {
    }

    private static class MinInfo {
        public static final int ALL_CHIDREN_ON = -1;
        public static final int ALL_CHIDREN_OFF = -2;
        public int index = -1;
        public String cons = "No";

        private MinInfo() {
        }

        public String toString() {
            return "cons=" + this.cons + ",index=" + this.index;
        }
    }
}

