/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDToggleButton;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.LittleArrowButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SizeSequence;
import javax.swing.UIManager;

public class SimpleToolBarLayout
implements LayoutManager2,
Serializable,
PropertyChangeListener {
    private static final long serialVersionUID = 4793188772867699919L;
    private static final boolean DEBUG = false;
    private boolean isLimitedSize = true;
    private SizeSequence totalSize = null;
    private int orientation = 0;
    private LittleArrowButton littleButton = null;
    private static final int COMMON = 0;
    private static final int PRE = 3;
    private Dimension preDim = new Dimension();
    private Dimension minDim = new Dimension();
    private int averageInterval = 0;
    private int[] interArray = null;
    private int counts = 0;
    private static final int All_SHOWN = -1;
    private int oldIndex = -1;
    private Component[] components = null;
    private static int tempCount = 0;
    private JComponent alwaysShownLastComp;
    private int defaultPreWidth;

    SimpleToolBarLayout(JComponent parent, int ori) {
        if (ori == 1) {
            // empty if block
        }
        if (parent != null && parent instanceof KDToolBar) {
            this.isLimitedSize = ((KDToolBar)parent).isLimitedSize();
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        String kv;
        if (comp instanceof LittleArrowButton && (kv = (String)((LittleArrowButton)comp).getClientProperty("container")) != null && kv.equals("true")) {
            this.littleButton = (LittleArrowButton)comp;
            this.logs(" has one LittleArrowButton. ", false);
        }
        ++this.counts;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        --this.counts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            this.calculateTotalSize(target, 3);
            if (target != null && target instanceof KDToolBar) {
                this.setOrientation(((KDToolBar)target).getOrientation());
            }
            if (this.orientation == 0) {
                if (this.isLimitedSize) {
                    this.preDim.height = (Integer)UIManager.get("ToolBar.preHeight");
                } else {
                    Insets ins = target.getInsets();
                    this.preDim.height = this.preDim.height + ins.top + ins.bottom + 2;
                }
            } else if (this.orientation == 1) {
                if (this.isLimitedSize) {
                    this.preDim.width = (Integer)UIManager.get("ToolBar.preWidth");
                } else {
                    Insets ins = target.getInsets();
                    this.preDim.width = this.preDim.width + ins.left + ins.right + 2;
                }
            }
            return this.preDim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            if (this.totalSize == null) {
                this.calculateTotalSize(target, 3);
            }
            return this.minDim;
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            this.logs(" layoutContainer ", true);
            if (target != null && target instanceof KDToolBar) {
                this.setOrientation(((KDToolBar)target).getOrientation());
            }
            int index = this.getEyeable(target);
            this.layoutSecond(target, index);
            this.oldIndex = index;
        }
    }

    private void layoutSecond(Container target, int index) {
        int assistCount = this.littleButton.getSelfComponentCount();
        if (index == -1) {
            this.littleButton.setVisible(false);
            if (assistCount > 0) {
                this.fromLittleBuToToolBar(target, this.littleButton, -1, this.oldIndex);
            }
        } else {
            this.littleButton.setVisible(true);
            if (this.oldIndex == -1) {
                this.fromToolBarToLittleBu(target, this.littleButton, index, -1);
            } else if (index > this.oldIndex) {
                this.fromLittleBuToToolBar(target, this.littleButton, index, this.oldIndex);
            } else {
                this.fromToolBarToLittleBu(target, this.littleButton, index, this.oldIndex);
            }
        }
        this.layoutThird(target);
    }

    private void setOrientation(int orientation) {
        if (orientation == 0) {
            this.orientation = 0;
        } else if (orientation == 1) {
            this.orientation = 1;
        }
    }

    private void layoutThird(Container target) {
        int count = target.getComponentCount();
        this.logs("now count is  " + count, false);
        Rectangle rect = target.getBounds();
        Insets ins = target.getInsets();
        int pW = rect.width - ins.left - ins.right;
        int pH = rect.height - ins.top - ins.bottom;
        int pX = ins.left;
        int pY = ins.top;
        if (this.orientation == 0) {
            if (this.littleButton.isVisible()) {
                Dimension lbDim = this.littleButton.getPreferredSize();
                int lx = rect.width - lbDim.width - ins.right;
                this.littleButton.setBounds(lx, pY, lbDim.width, pH);
            }
            for (int i = 1; i < count; ++i) {
                Component comp = target.getComponent(i);
                if (comp == this.alwaysShownLastComp) {
                    if (i + 1 >= count || !(target.getComponent(i + 1) instanceof JSeparator)) continue;
                    ++i;
                    continue;
                }
                if (!comp.isVisible()) continue;
                Dimension compDim = comp.getPreferredSize();
                int tempH = compDim.height;
                int tempPY = (rect.height - compDim.height) / 2;
                if (!this.isLimitedSize) {
                    tempH = compDim.height;
                    comp.setBounds(pX, tempPY, compDim.width, tempH);
                } else {
                    comp.setBounds(pX, pY + tempPY + 1, compDim.width, tempH);
                }
                pX = pX + compDim.width + this.getInterval(i);
            }
            if (this.alwaysShownLastComp != null) {
                Dimension compDim = this.alwaysShownLastComp.getPreferredSize();
                int tempH = compDim.height;
                int tempPY = (rect.height - compDim.height) / 2;
                int x = 0;
                if (this.littleButton.isVisible()) {
                    x = this.littleButton.getPreferredSize().width;
                }
                this.alwaysShownLastComp.setBounds(rect.width - compDim.width - x, pY + tempPY + 1, compDim.width, tempH);
            }
        } else if (this.orientation == 1) {
            if (this.littleButton.isVisible()) {
                Dimension lbDim = this.littleButton.getPreferredSize();
                int ly = rect.height - lbDim.height - ins.bottom;
                if (lbDim.width < pW) {
                    int etrX = (pW - lbDim.width) / 2;
                    this.littleButton.setBounds(etrX, ly, lbDim.width, lbDim.height);
                } else {
                    this.littleButton.setBounds(pX, ly, pW, lbDim.height);
                }
            }
            for (int i = 1; i < count; ++i) {
                Component comp = target.getComponent(i);
                if (!comp.isVisible()) continue;
                if (this.totalSize.getSize(i) > 0) {
                    Dimension compDim = comp.getPreferredSize();
                    int tempW = compDim.width;
                    int tempX = (rect.width - compDim.width) / 2;
                    if (!this.isLimitedSize) {
                        tempW = compDim.width;
                        comp.setBounds(tempX, pY, tempW, compDim.height);
                    } else {
                        comp.setBounds(pX + tempX + 1, pY, tempW, compDim.height);
                    }
                    pY = pY + compDim.height + this.getInterval(i);
                    continue;
                }
                comp.setBounds(0, 0, 0, 0);
            }
        }
    }

    private void addComponentToToolBar(int oldIndex, int currentIndex, Component[] comps, Container target) {
        int srcIndex = oldIndex + 1;
        int destIndex = currentIndex == -1 ? comps.length - 1 : currentIndex;
        for (int i = srcIndex; i <= destIndex; ++i) {
            this.littleButton.getSelfContainer().remove(comps[i].getParent());
            JComponent comp = (JComponent)comps[i];
            if (comp instanceof JSeparator) {
                ((JSeparator)comp).setOrientation((Integer)comp.getClientProperty("orientation"));
                ((JSeparator)comp).setPreferredSize((Dimension)comp.getClientProperty("preferedSize"));
            }
            target.add(comp);
        }
    }

    private void addComponentToLittleButton(int oldIndex, int currentIndex, Component[] comps, Container target, LittleArrowButton littleBu) {
        int srcIndex = currentIndex + 1;
        int destIndex = comps.length;
        for (int i = srcIndex; i < destIndex; ++i) {
            JComponent comp = (JComponent)comps[i];
            this.setComponentStyle(target, comp);
            if (comp instanceof JSeparator) {
                ((JSeparator)comp).setOrientation(0);
                ((JSeparator)comp).setPreferredSize(new Dimension(8, 2));
            }
            if (this.alwaysShownLastComp == comp) continue;
            littleBu.addSelfComponent(comp);
        }
    }

    private void fromLittleBuToToolBar(Container target, LittleArrowButton littleBu, int currentIndex, int oldIndex) {
        if (currentIndex == -1) {
            if (oldIndex >= 0) {
                this.addComponentToToolBar(oldIndex, currentIndex, this.components, target);
            }
        } else if (currentIndex > oldIndex) {
            this.addComponentToToolBar(oldIndex, currentIndex, this.components, target);
        }
    }

    private void fromToolBarToLittleBu(Container target, LittleArrowButton littleBu, int currentIndex, int oldIndex) {
        if (oldIndex == -1) {
            this.addComponentToLittleButton(oldIndex, currentIndex, this.components, target, littleBu);
        } else if (currentIndex < oldIndex) {
            this.addComponentToLittleButton(oldIndex, currentIndex, this.components, target, littleBu);
        }
    }

    private void setComponentStyle(Container target, Component comp) {
        if (target instanceof KDToolBar && comp instanceof KDWorkButton && ((KDWorkButton)comp).isControlByParent()) {
            ((KDWorkButton)comp).setTextIconDisStyle(((KDToolBar)target).getTextIconDisStyle());
        }
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("orientation")) {
            this.orientation = 0;
        } else if (name.equals("IsLimitedSize")) {
            this.isLimitedSize = (Boolean)e.getNewValue();
        }
    }

    private int getEyeable(Container target) {
        this.calculateTotalSize(target, 0);
        Rectangle rect = target.getBounds();
        int index = -1;
        if (this.orientation == 1) {
            int tempHeight = 0;
            int rectH = rect.height;
            int littleButtonHeight = this.littleButton.getPreferredSize().height;
            if (rectH >= this.preDim.height) {
                this.logs(" all shown ", false);
                return -1;
            }
            index = this.totalSize.getIndex(rectH);
            for (int i = 0; i < this.components.length; ++i) {
                if ((tempHeight += this.totalSize.getSize(i)) <= rectH - littleButtonHeight) continue;
                index = i - 1;
                break;
            }
        } else {
            int tempWidth = 0;
            int rectW = rect.width;
            int littleButtonWidth = this.littleButton.getPreferredSize().width;
            if (rectW >= (this.alwaysShownLastComp == null ? this.preDim.width : this.defaultPreWidth)) {
                this.logs(" all shown ", false);
                return -1;
            }
            index = this.totalSize.getIndex(rectW);
            for (int i = 0; i < this.components.length; ++i) {
                tempWidth = i == 0 ? (tempWidth += 0) : (tempWidth += this.totalSize.getSize(i));
                if (tempWidth <= rectW - littleButtonWidth + 3) continue;
                index = i - 1;
                break;
            }
            if (this.alwaysShownLastComp != null && index > 0) {
                --index;
            }
        }
        this.logs(" current index is   " + index, false);
        return index;
    }

    private void calculateTotalSize(Container target, int type) {
        int tlCount = target.getComponentCount();
        int lbCount = this.littleButton.getSelfComponentCount();
        int count = tlCount + lbCount;
        this.logs("coutn is " + (count + lbCount), true);
        this.totalSize = new SizeSequence(count);
        this.preDim = new Dimension();
        this.minDim = new Dimension();
        int[] sw = new int[count];
        for (int i = 0; i < count; ++i) {
            sw[i] = 0;
        }
        this.totalSize.setSizes(sw);
        Component[] tlComps = target.getComponents();
        Component[] lbComps = this.littleButton.getSelfComponents();
        this.components = new Component[count];
        System.arraycopy(tlComps, 0, this.components, 0, tlCount);
        System.arraycopy(lbComps, 0, this.components, tlCount, lbCount);
        this.adjustComponentPosition();
        this.adjustSeparatorVisible(this.components);
        for (int j = 0; j < count; ++j) {
            Component comp = this.components[j];
            if (comp == this.littleButton) {
                this.totalSize.setSize(j, 0);
            }
            if (comp.isVisible()) {
                if (target instanceof KDToolBar && comp instanceof KDWorkButton && ((KDWorkButton)comp).isControlByParent()) {
                    ((KDWorkButton)comp).setTextIconDisStyle(((KDToolBar)target).getTextIconDisStyle());
                }
                Dimension compDim = comp.getPreferredSize();
                Dimension compMinDim = comp.getMinimumSize();
                int tempInter = this.getInterval(j);
                int inerW = 0;
                int inerH = 0;
                if (this.orientation == 1) {
                    if (comp instanceof KDWorkButton || comp instanceof KDToggleButton || comp instanceof JSeparator || comp instanceof KDLabel) {
                        inerW = compDim.width;
                        inerH = tempInter + compDim.height;
                        this.totalSize.setSize(j, inerH);
                        if (j != 0) {
                            this.preDim.width = Math.max(this.preDim.width, inerW);
                            this.preDim.height += inerH;
                        }
                        this.minDim.width = Math.max(this.minDim.width, compMinDim.width);
                        this.minDim.height = compMinDim.height + inerH;
                        continue;
                    }
                    this.totalSize.setSize(j, 0);
                    continue;
                }
                inerW = tempInter + compDim.width;
                inerH = compDim.height;
                this.totalSize.setSize(j, inerW);
                if (this.alwaysShownLastComp == comp) continue;
                if (j != 0) {
                    this.preDim.width += inerW;
                    this.preDim.height = Math.max(this.preDim.height, inerH);
                }
                this.minDim.width = compMinDim.width + inerW;
                this.minDim.height = Math.max(compMinDim.height, this.minDim.height);
                continue;
            }
            this.totalSize.setSize(j, 0);
        }
        if (this.alwaysShownLastComp != null) {
            this.defaultPreWidth = this.preDim.width + this.alwaysShownLastComp.getPreferredSize().width;
            this.preDim.width = Integer.MAX_VALUE;
        }
    }

    private void adjustComponentPosition() {
        int length = this.components.length;
        for (int i = 0; i < length; ++i) {
            Component comp = this.components[i];
            if (!(comp instanceof JComponent) || ((JComponent)comp).getClientProperty("alwaysLast") != Boolean.TRUE) continue;
            for (int j = i; j < length - 1; ++j) {
                this.components[j] = this.components[j + 1];
            }
            this.components[length - 1] = comp;
        }
    }

    public int getInterval(int index) {
        if (this.interArray == null) {
            return this.averageInterval;
        }
        int as = this.interArray.length;
        if (index >= as) {
            return this.averageInterval;
        }
        return this.interArray[index];
    }

    public void setInterval(int index, int newInterval) {
        int tempC;
        if (this.interArray == null) {
            this.interArray = new int[this.counts];
            for (int i = 0; i < this.counts; ++i) {
                this.interArray[i] = this.averageInterval;
            }
        }
        if (index >= (tempC = this.interArray.length)) {
            int[] tempArray = new int[index + 1];
            for (int j = 0; j < index + 1; ++j) {
                tempArray[j] = this.averageInterval;
            }
            System.arraycopy(this.interArray, 0, tempArray, 0, tempC);
            this.interArray = new int[index + 1];
            for (int z = 0; z < index + 1; ++z) {
                this.interArray[z] = this.averageInterval;
            }
            System.arraycopy(tempArray, 0, this.interArray, 0, index + 1);
        }
        this.interArray[index] = newInterval;
    }

    public void setAverageInter(int newAverage) {
        if (newAverage < 0) {
            this.averageInterval = 0;
        }
        this.averageInterval = newAverage;
    }

    private void logs(String info, boolean b) {
    }

    private void adjustSeparatorVisible(Component[] components) {
        int preVisibleSeparator = -1;
        int firstVisibleComponent = this.getFirstVisibleComponent(components);
        int lastVisibleComponent = this.getLastVisibleComponent(components);
        if (components.length > 1) {
            for (int i = 1; i < components.length; ++i) {
                JComponent comp = (JComponent)components[i];
                if (comp instanceof JPopupMenu.Separator) {
                    comp.setVisible(false);
                    continue;
                }
                if (!(comp instanceof JSeparator)) continue;
                if (firstVisibleComponent == -1) {
                    comp.setVisible(false);
                    continue;
                }
                if (i < firstVisibleComponent) {
                    comp.setVisible(false);
                    continue;
                }
                if (i > lastVisibleComponent) {
                    comp.setVisible(false);
                    continue;
                }
                if (this.isPreVisibleCompSeparator(components, preVisibleSeparator, i)) {
                    comp.setVisible(false);
                    continue;
                }
                comp.setVisible(true);
                preVisibleSeparator = i;
            }
        }
    }

    private int getFirstVisibleComponent(Component[] components) {
        for (int i = 1; i < components.length - 1; ++i) {
            JComponent comp = (JComponent)components[i];
            if (!comp.isVisible() || comp instanceof JSeparator) continue;
            return i;
        }
        return -1;
    }

    private int getLastVisibleComponent(Component[] components) {
        if (this.getFirstVisibleComponent(components) == -1) {
            return -1;
        }
        for (int i = components.length - 1; i > 1; --i) {
            JComponent comp = (JComponent)components[i];
            if (!comp.isVisible() || comp instanceof JSeparator) continue;
            return i;
        }
        return -1;
    }

    private boolean isPreVisibleCompSeparator(Component[] components, int pre, int current) {
        if (pre == -1) {
            return false;
        }
        for (int i = current - 1; i >= pre; --i) {
            JComponent comp = (JComponent)components[i];
            if (!comp.isVisible() || comp instanceof JSeparator) continue;
            return false;
        }
        return true;
    }

    public void setHorizontalAlwayShownAtLastComponent(JComponent alwaysShownLastComp) {
        this.alwaysShownLastComp = alwaysShownLastComp;
    }
}

